/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.GameType;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GameTypeTDM
extends GameType {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 25;
    public int time;

    public GameTypeTDM() {
        super("Team Deathmatch", "TDM", 2, true);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
        if (GameTypeTDM.teamsManager.currentRound.teams != null && GameTypeTDM.teamsManager.currentRound.teams[0] != null && GameTypeTDM.teamsManager.currentRound.teams[1] != null) {
            int bestScore;
            PlayerData data;
            Team teamA = GameTypeTDM.teamsManager.currentRound.teams[0];
            Team teamB = GameTypeTDM.teamsManager.currentRound.teams[1];
            teamA.sortPlayers();
            teamB.sortPlayers();
            EntityPlayerMP bestPlayerA = null;
            EntityPlayerMP bestPlayerB = null;
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    ++GameTypeTDM.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeTDM.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeTDM.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    ++GameTypeTDM.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeTDM.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeTDM.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    data = GameTypeTDM.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerA = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    data = GameTypeTDM.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerB = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (bestPlayerA != null) {
                GameTypeTDM.getPlayerInfo(bestPlayerA).addExp(250.0f);
                ++GameTypeTDM.getPlayerInfo(bestPlayerA).MVPCount;
                GameTypeTDM.getPlayerInfo(bestPlayerA).savePlayerStats();
            }
            if (bestPlayerB != null) {
                GameTypeTDM.getPlayerInfo(bestPlayerB).addExp(250.0f);
                ++GameTypeTDM.getPlayerInfo(bestPlayerB).MVPCount;
                GameTypeTDM.getPlayerInfo(bestPlayerB).savePlayerStats();
            }
        }
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GameTypeTDM.getPlayerData(player) == null || GameTypeTDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GameTypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GameTypeTDM.getPlayerData(attacker) == null || GameTypeTDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GameTypeTDM.getPlayerData((EntityPlayerMP)player).team == GameTypeTDM.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GameTypeTDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return attackerTeam != victimTeam || this.friendlyFire;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GameTypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GameTypeTDM.getPlayerData((EntityPlayerMP)player).score;
            } else if (GameTypeTDM.getPlayerData((EntityPlayerMP)attacker).team == GameTypeTDM.getPlayerData((EntityPlayerMP)player).team) {
                --GameTypeTDM.getPlayerData((EntityPlayerMP)attacker).score;
            } else {
                GameTypeTDM.givePoints(attacker, 1);
                ++GameTypeTDM.getPlayerData((EntityPlayerMP)attacker).kills;
                ++GameTypeTDM.getPlayerInfo((EntityPlayerMP)attacker).kills;
                GameTypeTDM.getPlayerInfo(attacker).addExp(GameTypeTDM.getPlayerInfo((EntityPlayerMP)player).rank * 2);
                GameTypeTDM.getPlayerInfo(attacker).updateLongestKill(attacker.func_70032_d((Entity)player));
                GameTypeTDM.getPlayerInfo(attacker).savePlayerStats();
            }
        } else {
            --GameTypeTDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GameTypeTDM.getPlayerData((EntityPlayerMP)player).deaths;
        ++GameTypeTDM.getPlayerInfo((EntityPlayerMP)player).deaths;
        GameTypeTDM.getPlayerInfo(player).savePlayerStats();
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GameTypeTDM.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GameTypeTDM.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        ArrayList<ITeamBase> bases = GameTypeTDM.teamsManager.currentRound.map.getBasesPerTeam(GameTypeTDM.teamsManager.currentRound.getTeamID(data.newTeam));
        for (ITeamBase base : bases) {
            if (!base.getMap().equals(GameTypeTDM.teamsManager.currentRound.map)) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.equalsIgnoreCase("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.equalsIgnoreCase("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.equalsIgnoreCase("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("TDMScoreLimit");
        this.friendlyFire = tags.func_74767_n("TDMFriendlyFire");
        this.autoBalance = tags.func_74767_n("TDMAutoBalance");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("TDMScoreLimit", this.scoreLimit);
        tags.func_74757_a("TDMFriendlyFire", this.friendlyFire);
        tags.func_74757_a("TDMAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return GameTypeTDM.teamsManager.currentRound != null && team.score == GameTypeTDM.teamsManager.currentRound.scoreLimit;
    }
}

