/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.GameType;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GameTypeDM
extends GameType {
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;

    public GameTypeDM() {
        super("Free For All", "DM", 2, true);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
        if (GameTypeDM.teamsManager.currentRound.teams != null && GameTypeDM.teamsManager.currentRound.teams[0] != null && GameTypeDM.teamsManager.currentRound.teams[1] != null) {
            int bestScore;
            PlayerData data;
            Team teamA = GameTypeDM.teamsManager.currentRound.teams[0];
            Team teamB = GameTypeDM.teamsManager.currentRound.teams[1];
            teamA.sortPlayers();
            teamB.sortPlayers();
            EntityPlayerMP bestPlayerA = null;
            EntityPlayerMP bestPlayerB = null;
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    ++GameTypeDM.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeDM.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeDM.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    ++GameTypeDM.getPlayerInfo((EntityPlayerMP)this.getPlayer((String)name)).playedRounds;
                    GameTypeDM.getPlayerInfo(this.getPlayer(name)).updateAVG();
                    GameTypeDM.getPlayerInfo(this.getPlayer(name)).savePlayerStats();
                }
            }
            if (teamA.members != null) {
                for (String name : teamA.members) {
                    data = GameTypeDM.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerA = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (teamB.members != null) {
                for (String name : teamB.members) {
                    data = GameTypeDM.getPlayerData(this.getPlayer(name));
                    bestScore = 0;
                    if (data.score <= bestScore) continue;
                    bestPlayerB = this.getPlayer(name);
                    bestScore = data.score;
                }
            }
            if (bestPlayerA != null && bestPlayerB != null) {
                if (GameTypeDM.getPlayerData(bestPlayerA).score > GameTypeDM.getPlayerData(bestPlayerB).score) {
                    GameTypeDM.getPlayerInfo(bestPlayerA).addExp(250.0f);
                    ++GameTypeDM.getPlayerInfo(bestPlayerA).MVPCount;
                    GameTypeDM.getPlayerInfo(bestPlayerA).savePlayerStats();
                } else if (GameTypeDM.getPlayerData(bestPlayerA).score < GameTypeDM.getPlayerData(bestPlayerB).score) {
                    GameTypeDM.getPlayerInfo(bestPlayerB).addExp(250.0f);
                    ++GameTypeDM.getPlayerInfo(bestPlayerB).MVPCount;
                    GameTypeDM.getPlayerInfo(bestPlayerB).savePlayerStats();
                }
            }
        }
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GameTypeDM.getPlayerData(player) == null || GameTypeDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GameTypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GameTypeDM.getPlayerData(attacker) == null || GameTypeDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GameTypeDM.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
        }
        return GameTypeDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GameTypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GameTypeDM.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GameTypeDM.getPlayerData((EntityPlayerMP)attacker).score;
                ++GameTypeDM.getPlayerData((EntityPlayerMP)attacker).kills;
                ++GameTypeDM.getPlayerInfo((EntityPlayerMP)attacker).kills;
                GameTypeDM.getPlayerInfo(attacker).addExp((float)GameTypeDM.getPlayerInfo((EntityPlayerMP)player).rank * 2.2f);
                GameTypeDM.getPlayerInfo(attacker).updateLongestKill(attacker.func_70032_d((Entity)player));
                GameTypeDM.getPlayerInfo(attacker).savePlayerStats();
            }
        } else {
            --GameTypeDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GameTypeDM.getPlayerData((EntityPlayerMP)player).deaths;
        ++GameTypeDM.getPlayerInfo((EntityPlayerMP)player).deaths;
        GameTypeDM.getPlayerInfo(player).savePlayerStats();
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GameTypeDM.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GameTypeDM.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        if (data.newTeam == Team.spectators) {
            ArrayList<ITeamBase> bases = GameTypeDM.teamsManager.currentRound.map.getBasesPerTeam(GameTypeDM.teamsManager.currentRound.getTeamID(data.newTeam));
            for (ITeamBase base : bases) {
                if (!base.getMap().equals(GameTypeDM.teamsManager.currentRound.map)) continue;
                for (int i = 0; i < base.getObjects().size(); ++i) {
                    if (!base.getObjects().get(i).isSpawnPoint()) continue;
                    validSpawnPoints.add(base.getObjects().get(i));
                }
            }
        } else {
            for (int k = 2; k < 4; ++k) {
                ArrayList<ITeamBase> bases = GameTypeDM.teamsManager.currentRound.map.getBasesPerTeam(k);
                for (ITeamBase base : bases) {
                    if (base.getMap() != GameTypeDM.teamsManager.currentRound.map) continue;
                    for (int i = 0; i < base.getObjects().size(); ++i) {
                        if (!base.getObjects().get(i).isSpawnPoint()) continue;
                        validSpawnPoints.add(base.getObjects().get(i));
                    }
                }
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("DMScoreLimit");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("DMScoreLimit", this.scoreLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return false;
    }

    @Override
    public boolean shouldAutobalance() {
        return false;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return false;
    }
}

