/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.sync.ShotData;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ByteBufferBulletHitBridge;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class TEST_PacketShotData
extends PacketBase {
    private List<ShotData> shotData;

    public TEST_PacketShotData() {
    }

    public TEST_PacketShotData(List<ShotData> shotData) {
        this.shotData = shotData;
    }

    public TEST_PacketShotData(ShotData shotData) {
        this.shotData = new ArrayList<ShotData>();
        this.shotData.add(shotData);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.shotData.size());
        for (int i = 0; i < this.shotData.size(); ++i) {
            ShotData currentCast;
            ShotData current = this.shotData.get(i);
            data.writeByte((int)((byte)current.slot));
            data.writeInt(InfoType.infoTypes.indexOf(current.shotFrom));
            data.writeInt(InfoType.infoTypes.indexOf(current.shotType));
            if (!(current instanceof ShotData.SpawnClientEntityShotData)) {
                if (current instanceof ShotData.InstantShotData) {
                    currentCast = (ShotData.InstantShotData)current;
                    data.writeByte(1);
                    data.writeInt(((ShotData.InstantShotData)currentCast).shooterID);
                    ((ShotData.InstantShotData)currentCast).origin.writeToBuffer(data);
                    ByteBufferBulletHitBridge.WriteToBuffer(((ShotData.InstantShotData)currentCast).hit, data);
                    ((ShotData.InstantShotData)currentCast).hitPos.writeToBuffer(data);
                    data.writeFloat(((ShotData.InstantShotData)currentCast).damage);
                    data.writeBoolean(((ShotData.InstantShotData)currentCast).isExtraBullet);
                    data.writeBoolean(((ShotData.InstantShotData)currentCast).silenced);
                    continue;
                }
                data.writeByte(2);
                continue;
            }
            currentCast = (ShotData.SpawnClientEntityShotData)current;
            data.writeByte(0);
            data.writeInt(currentCast.shooterID);
            currentCast.origin.writeToBuffer(data);
            data.writeInt(currentCast.direction.length);
            for (Vector3f v : currentCast.direction) {
                v.writeToBuffer(data);
            }
            for (int k = 0; k < currentCast.clientBulletId.length; ++k) {
                data.writeInt(currentCast.clientBulletId[k]);
            }
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.shotData = new ArrayList<ShotData>();
        int numEntries = data.readInt();
        block5: for (int i = 0; i < numEntries; ++i) {
            byte slot = data.readByte();
            InfoType shotFrom = InfoType.getType(data.readInt());
            ShootableType shotType = (ShootableType)InfoType.getType(data.readInt());
            byte dataType = data.readByte();
            switch (dataType) {
                case 0: {
                    int k;
                    int shooterID = data.readInt();
                    Vector3f origin = Vector3f.readFromBuffer(data);
                    int len = data.readInt();
                    Vector3f[] direction = new Vector3f[len];
                    int[] clientBulletId = new int[len];
                    for (k = 0; k < len; ++k) {
                        direction[k] = Vector3f.readFromBuffer(data);
                    }
                    for (k = 0; k < len; ++k) {
                        clientBulletId[k] = data.readInt();
                    }
                    this.shotData.add(new ShotData.SpawnClientEntityShotData((int)slot, shotFrom, shotType, shooterID, origin, direction, clientBulletId));
                    continue block5;
                }
                case 1: {
                    int shooterID = data.readInt();
                    Vector3f origin = Vector3f.readFromBuffer(data);
                    BulletHit hitData = ByteBufferBulletHitBridge.ReadFromBuffer(data);
                    Vector3f hit = Vector3f.readFromBuffer(data);
                    float damage = data.readFloat();
                    boolean isExtraBullet = data.readBoolean();
                    boolean silenced = data.readBoolean();
                    this.shotData.add(new ShotData.InstantShotData((int)slot, shotFrom, shotType, shooterID, origin, hitData, hit, damage, isExtraBullet, silenced));
                    continue block5;
                }
                case 2: {
                    this.shotData.add(new ShotData(slot, shotFrom, shotType));
                }
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player, Side.SERVER);
        for (ShotData entry : this.shotData) {
            if (entry.slot == -1) {
                if (!(entry.shotFrom instanceof GunType)) continue;
                ((ItemGun)entry.shotFrom.item).ServerHandleShotData(null, entry.slot, player.field_70170_p, (Entity)player, false, entry);
                continue;
            }
            ItemStack gunStack = player.field_71071_by.func_70301_a(entry.slot);
            if (gunStack == null || !(gunStack.func_77973_b() instanceof ItemGun)) continue;
            ItemGun gunItem = (ItemGun)gunStack.func_77973_b();
            boolean isOffHand = data.offHandGunSlot + 1 == entry.slot;
            gunItem.ServerHandleShotData(gunStack, entry.slot, player.field_70170_p, (Entity)player, isOffHand, entry);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        for (ShotData entry : this.shotData) {
            if (entry instanceof ShotData.InstantShotData) {
                ShotData.InstantShotData instantData = (ShotData.InstantShotData)entry;
                if (!(entry.shotFrom instanceof GunType)) continue;
                ItemGun gunItem = (ItemGun)entry.shotFrom.getItem();
                gunItem.DoInstantShot(clientPlayer.field_70170_p, ByteBufferBulletHitBridge.GetEntityByID(instantData.shooterID), instantData.shotFrom, (BulletType)instantData.shotType, instantData.origin, instantData.hitPos, instantData.hit, instantData.damage, instantData.isExtraBullet, instantData.silenced);
                continue;
            }
            FlansMod.log("Only expect instant shot types on client side.");
        }
    }
}

