/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketHitMarker
extends PacketBase {
    public float penAmount = 1.0f;
    public boolean headshot = false;
    public boolean explosionHit = false;

    public PacketHitMarker() {
    }

    public PacketHitMarker(boolean head, float pen, boolean explosion) {
        this.headshot = head;
        this.penAmount = pen;
        this.explosionHit = explosion;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(this.headshot);
        data.writeFloat(this.penAmount);
        data.writeBoolean(this.explosionHit);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.headshot = data.readBoolean();
        this.penAmount = data.readFloat();
        this.explosionHit = data.readBoolean();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log("Received unexpected PacketHitMarker on server.");
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansModClient.hitMarker = true;
        FlansModClient.hitMarkerPenAmount = this.penAmount;
        FlansModClient.hitMarkerHeadshot = this.headshot;
        FlansModClient.hitMarkerExplosion = this.explosionHit;
    }
}

