/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxEntry;
import com.flansmod.common.guns.boxes.GunPage;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GunBoxType
extends InfoType {
    public BlockGunBox block;
    public String topTexturePath;
    public String sideTexturePath;
    public String bottomTexturePath;
    public IIcon top;
    public IIcon side;
    public IIcon bottom;
    public int nextGun = -1;
    public GunBoxEntry[] gunEntries;
    public List<GunPage> gunPages = new ArrayList<GunPage>();
    public GunPage currentPage;
    public String guiTexturePath;
    public String gunBoxTextColor = "404040";
    public String itemListTextColor = "404040";
    public String itemTextColor = "404040";
    public String pageTextColor = "FFFFFF";
    public String buttonTextColor = "FFFFFF";
    public String buttonTextHoverColor = "FFFFA0";
    private static int lastIconIndex = 2;
    public static HashMap<String, GunBoxType> gunBoxMap = new HashMap();

    public GunBoxType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        this.gunEntries = new GunBoxEntry[8];
        this.currentPage = new GunPage("Default");
    }

    @Override
    public void postRead(TypeFile file) {
        this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun + 1));
        this.gunPages.add(this.currentPage);
        if (this.shortName != null && this.isValid) {
            gunBoxMap.put(this.shortName, this);
        }
    }

    @Override
    protected void readLine(String[] split, TypeFile file) {
        if (split.length < 1) {
            return;
        }
        String kword = split[0];
        if (kword.equalsIgnoreCase("Page") || kword.equalsIgnoreCase("SetPage")) {
            try {
                StringBuilder pageName = new StringBuilder();
                for (int i = 1; i < split.length; ++i) {
                    pageName.append(split[i]);
                    if (i + 1 >= split.length) continue;
                    pageName.append(" ");
                }
                if (this.gunEntries[0] != null) {
                    this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun + 1));
                    this.iteratePage(pageName.toString());
                } else {
                    this.currentPage.setPageName(pageName.toString());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Setting Page name failed", split, ex);
            }
        }
        if (kword.equalsIgnoreCase("AddGun")) {
            try {
                InfoType type = InfoType.getType(split[1]);
                if (type == null) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Unable to find item for gunbox, skipping entry", split, null);
                    return;
                }
                List<ItemStack> parts = this.getRecipe(split);
                ++this.nextGun;
                if (this.nextGun > this.gunEntries.length - 1) {
                    this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun));
                    this.iteratePage("Default " + (this.gunPages.size() + 2));
                    ++this.nextGun;
                }
                this.gunEntries[this.nextGun] = new GunBoxEntry(type, parts);
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding gun to GunBox failed", split, ex);
            }
        }
        if (kword.equalsIgnoreCase("AddAmmo") || kword.equalsIgnoreCase("AddAltAmmo") || kword.equalsIgnoreCase("AddAlternateAmmo")) {
            try {
                InfoType ammoType = InfoType.getType(split[1]);
                if (ammoType == null || ammoType.item == null) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Ammo item not found for gunbox, skipping", split, null);
                    return;
                }
                this.gunEntries[this.nextGun].addAmmoEntry(new GunBoxEntry(ammoType, this.getRecipe(split)));
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding ammo to GunBox failed", split, ex);
            }
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.topTexturePath = ConfigUtils.configString(config, "TopTexture", this.topTexturePath);
            this.bottomTexturePath = ConfigUtils.configString(config, "BottomTexture", this.bottomTexturePath);
            this.sideTexturePath = ConfigUtils.configString(config, "SideTexture", this.sideTexturePath);
            this.guiTexturePath = ConfigUtils.configString(config, "GuiTexture", this.guiTexturePath);
            this.gunBoxTextColor = ConfigUtils.configString(config, "GunBoxNameColor", this.gunBoxTextColor);
            this.pageTextColor = ConfigUtils.configString(config, "PageTextColor", this.pageTextColor);
            this.itemListTextColor = ConfigUtils.configString(config, "ListTextColor", this.itemListTextColor);
            this.itemTextColor = ConfigUtils.configString(config, "ItemTextColor", this.itemTextColor);
            this.buttonTextColor = ConfigUtils.configString(config, "ButtonTextColor", this.buttonTextColor);
            this.buttonTextHoverColor = ConfigUtils.configString(config, "ButtonTextHighlight", this.buttonTextHoverColor);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error thrown while loading GunBox", null, ex);
            this.isValid = false;
        }
    }

    public void iteratePage(String s) {
        this.gunPages.add(this.currentPage);
        this.gunEntries = new GunBoxEntry[8];
        this.nextGun = -1;
        this.currentPage = new GunPage(s);
    }

    public static GunBoxType getBox(String s) {
        return gunBoxMap.get(s);
    }

    public static GunBoxType getBox(Block block) {
        for (GunBoxType type : gunBoxMap.values()) {
            if (type.block != block) continue;
            return type;
        }
        return null;
    }

    public List<ItemStack> getRecipe(String[] split) {
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i = 0; i < (split.length - 2) / 2; ++i) {
            ItemStack recipeElement = null;
            recipeElement = split[i * 2 + 3].contains(".") ? GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1]), this.shortName) : GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0, this.shortName);
            if (recipeElement != null) {
                recipe.add(recipeElement);
                continue;
            }
            FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for recipe", split, null);
        }
        return recipe;
    }

    @Override
    public void addRecipe(Item par1Item) {
        block27: {
            if (this.smeltableFrom != null) {
                ItemStack recipeElement = GunBoxType.getRecipeElement(this.smeltableFrom, 0);
                if (recipeElement != null) {
                    GameRegistry.addSmelting((ItemStack)recipeElement, (ItemStack)new ItemStack(this.item), (float)0.0f);
                } else {
                    FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for SmeltableFrom", null, null);
                }
            }
            if (this.recipeLine == null) {
                return;
            }
            try {
                if (!this.shapeless) {
                    Object[] newRecipe1;
                    int last;
                    int rows = 3;
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                        if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(1);
                            }
                        }
                    }
                    if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                        }
                        if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                            }
                        }
                    }
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[1];
                        newRecipe[1] = this.recipe[2];
                        this.recipe = newRecipe;
                        --rows;
                        if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[1];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[0];
                        newRecipe[1] = this.recipe[1];
                        this.recipe = newRecipe;
                        if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[0];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                        this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                        ItemStack recipeElement = null;
                        recipeElement = this.recipeLine[i * 2 + 2].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.valueOf(this.recipeLine[i * 2 + 2].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                        if (recipeElement == null) {
                            FlansMod.logPackError(null, this.packName, this.shortName, "Could not find item for recipe", new String[]{this.recipeLine[i * 2 + 2]}, null);
                        }
                        this.recipe[i * 2 + rows + 1] = recipeElement;
                    }
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
                } else {
                    this.recipe = new Object[this.recipeLine.length - 1];
                    for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                        ItemStack recipeElement = null;
                        recipeElement = this.recipeLine[i + 1].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.valueOf(this.recipeLine[i + 1].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i + 1], 0);
                        if (recipeElement == null) {
                            FlansModClient.logPackError(null, this.packName, this.shortName, "Could not find item for recipe", new String[]{this.recipeLine[i + 1]}, null);
                        }
                        this.recipe[i] = recipeElement;
                    }
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
                }
            }
            catch (Exception e) {
                if (this.recipe != null) {
                    StringBuilder msg = new StringBuilder(" : ");
                    for (Object o : this.recipe) {
                        msg.append(" ").append(o);
                    }
                    FlansMod.log("Failed to add recipe for : " + this.shortName + msg);
                } else {
                    FlansMod.log("Failed to add recipe for : " + this.shortName);
                }
                if (!FlansMod.printStackTrace) break block27;
                e.printStackTrace();
            }
        }
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }
}

