/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.network.PacketExplosion;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcheli.aircraft.MCH_EntityAircraft;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class FlansModExplosion
extends Explosion {
    private static final int boomRadius = 16;
    private static final Random explosionRNG = new Random();
    private HashMap<EntityPlayer, Vec3> playerLocations = new HashMap();
    private World worldObj;
    public InfoType type;
    public EntityPlayer player;
    private float radius;
    private float power;
    private final float damageVsLiving;
    private final float damageVsPlayer;
    private final float damageVsPlane;
    private final float damageVsVehicle;
    public boolean breakBlocks;
    public boolean canceled = false;
    public boolean canDamageSelf;

    public FlansModExplosion(World w, Entity e, EntityPlayer p, InfoType t, double x, double y, double z, float explosionRadius, float explosionPower, boolean breakBlocks, float damageLiving, float damagePlayer, float damagePlane, float damageVehicle, int smokeCount, int debrisCount, boolean damageSelf) {
        super(w, e, x, y, z, explosionRadius);
        this.radius = explosionRadius;
        this.power = explosionPower;
        this.worldObj = w;
        this.type = t;
        this.player = p;
        this.field_77286_a = false;
        this.field_82755_b = true;
        this.breakBlocks = breakBlocks;
        this.damageVsPlayer = damagePlayer;
        this.damageVsLiving = damageLiving;
        this.damageVsPlane = damagePlane;
        this.damageVsVehicle = damageVehicle;
        this.canDamageSelf = damageSelf;
        this.func_77278_a();
        this.func_77279_a(true);
        this.spawnParticle(smokeCount, debrisCount);
        this.canceled = ForgeEventFactory.onExplosionStart((World)this.worldObj, (Explosion)this);
        if (!this.worldObj.field_72995_K) {
            for (Object playerEntity : this.worldObj.field_73010_i) {
                EntityPlayerMP entityplayer;
                if (!(playerEntity instanceof EntityPlayerMP) || !((entityplayer = (EntityPlayerMP)playerEntity).func_70092_e(x, y, z) < 4096.0)) continue;
                FlansMod.getPacketHandler().sendTo(new PacketExplosion(x, y, z, explosionRadius), entityplayer);
            }
        }
    }

    public void func_77278_a() {
        HashSet hashset = Sets.newHashSet();
        boolean flag = true;
        boolean sendHitmarker = false;
        this.field_77281_g.addAll(hashset);
        float diameter = this.radius * 2.0f;
        int j = MathHelper.func_76128_c((double)(this.field_77284_b - (double)diameter - 1.0));
        int k = MathHelper.func_76128_c((double)(this.field_77284_b + (double)diameter + 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)diameter - 1.0));
        int l = MathHelper.func_76128_c((double)(this.field_77285_c + (double)diameter + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)diameter - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)diameter + 1.0));
        List list = this.worldObj.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)j, (double)j1, (double)k1, (double)k, (double)l, (double)i1));
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)diameter);
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            double d9;
            double d7;
            double d5;
            double d13;
            Entity entity = (Entity)list.get(l1);
            double relDist = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)diameter;
            if (!(relDist <= 1.0) && (!(entity instanceof EntityDriveable) || !(relDist <= 2.0)) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double exposure = this.getBlockDensity2(vec3, entity.field_70121_D);
            double d10 = (1.0 - relDist) * exposure;
            float dmg = (int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)diameter + 1.0);
            boolean isGrenade = this.type instanceof GrenadeType;
            if (entity instanceof MCH_EntityAircraft) {
                if (isGrenade) {
                    if (this.player != null && this.player.field_70154_o != null) {
                        dmg *= 4.0f;
                    }
                    dmg = Math.min(200.0f, dmg);
                } else {
                    dmg = 10.0f;
                }
            } else if (entity instanceof EntityLivingBase) {
                if (entity.field_70154_o == null) {
                    if (isGrenade) {
                        if (this.type.shortName.equalsIgnoreCase("c4")) {
                            dmg *= 1.6f;
                        } else if (this.player != null && this.player.field_70154_o != null) {
                            dmg *= 4.0f;
                        }
                    } else {
                        dmg *= 1.4f;
                    }
                } else {
                    dmg = 0.0f;
                }
            } else {
                dmg = 1.0f;
            }
            entity.func_70097_a((DamageSource)new EntityDamageSourceFlans(this.type.shortName, this.field_77283_e, this.player, this.type, false, false), dmg);
        }
    }

    public static ArrayList<MovingObjectPosition> rayTraceBlocks(Vec3 vec31, Vec3 vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, World world, int maxHits) {
        ArrayList<MovingObjectPosition> hits = new ArrayList<MovingObjectPosition>();
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                MovingObjectPosition movingobjectposition;
                Vec3.func_72443_a((double)vec31.field_72450_a, (double)vec31.field_72448_b, (double)vec31.field_72449_c);
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                Block block = world.func_147439_a(l, i1, j1);
                if ((!ignoreBlockWithoutBoundingBox || stopOnLiquid && block instanceof BlockLiquid || block.func_149668_a(world, l, i1, j1) != null) && block.func_149678_a(world.func_72805_g(l, i1, j1), stopOnLiquid) && (movingobjectposition = block.func_149731_a(world, l, i1, j1, vec31, vec32)) != null) {
                    hits.add(movingobjectposition);
                }
                int k1 = 200;
                boolean prevWasHit = false;
                while (k1-- >= 0) {
                    MovingObjectPosition movingobjectposition1;
                    ForgeDirection enumfacing;
                    Vec3 pvec31 = Vec3.func_72443_a((double)vec31.field_72450_a, (double)vec31.field_72448_b, (double)vec31.field_72449_c);
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return hits;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return hits;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? ForgeDirection.WEST : ForgeDirection.EAST;
                        vec31 = Vec3.func_72443_a((double)d0, (double)(vec31.field_72448_b + d7 * d3), (double)(vec31.field_72449_c + d8 * d3));
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? ForgeDirection.DOWN : ForgeDirection.UP;
                        vec31 = Vec3.func_72443_a((double)(vec31.field_72450_a + d6 * d4), (double)d1, (double)(vec31.field_72449_c + d8 * d4));
                    } else {
                        enumfacing = k > j1 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
                        vec31 = Vec3.func_72443_a((double)(vec31.field_72450_a + d6 * d5), (double)(vec31.field_72448_b + d7 * d5), (double)d2);
                    }
                    if (prevWasHit) {
                        hits.get((int)(hits.size() - 1)).hitInfo = vec31.func_72444_a(pvec31);
                        prevWasHit = false;
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == ForgeDirection.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == ForgeDirection.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == ForgeDirection.SOUTH ? 1 : 0);
                    block = world.func_147439_a(l, i1, j1);
                    if (ignoreBlockWithoutBoundingBox && (!stopOnLiquid || !(block instanceof BlockLiquid)) && block.func_149668_a(world, l, i1, j1) == null || !block.func_149678_a(world.func_72805_g(l, i1, j1), stopOnLiquid) || (movingobjectposition1 = block.func_149731_a(world, l, i1, j1, vec31, vec32)) == null) continue;
                    hits.add(movingobjectposition1);
                    prevWasHit = true;
                }
                return hits;
            }
            return hits;
        }
        return hits;
    }

    public float getBlockDensity2(Vec3 vec, AxisAlignedBB bb) {
        double d0 = 1.0 / ((bb.field_72336_d - bb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((bb.field_72337_e - bb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((bb.field_72334_f - bb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            float unblockedRays = 0.0f;
            int totalRays = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * (double)f;
                        double d6 = bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * (double)f1;
                        double d7 = bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * (double)f2;
                        ArrayList<MovingObjectPosition> pos = FlansModExplosion.rayTraceBlocks(Vec3.func_72443_a((double)(d5 + d3), (double)d6, (double)(d7 + d4)), vec, true, true, false, this.worldObj, 5);
                        if (pos != null && !pos.isEmpty()) {
                            float strength;
                            float originalStrength = strength = this.radius * 3.0f;
                            for (MovingObjectPosition p : pos) {
                                Block block = this.worldObj.func_147439_a(p.field_72311_b, p.field_72312_c, p.field_72309_d);
                                float resist = block.func_149638_a(this.field_77283_e);
                                if ((strength -= resist) <= 0.0f) {
                                    strength = 0.0f;
                                    break;
                                }
                                BlockPos b = new BlockPos(p.field_72311_b, p.field_72312_c, p.field_72309_d);
                            }
                            unblockedRays += strength / originalStrength;
                        } else {
                            unblockedRays += 1.0f;
                        }
                        ++totalRays;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return unblockedRays / (float)totalRays;
        }
        return 0.0f;
    }

    public void spawnParticle(int numSmoke, int numDebris) {
        float smokeRand;
        float mod = this.radius * 0.1f;
        for (int smoke = 0; smoke < numSmoke; ++smoke) {
            smokeRand = (float)Math.random();
            if ((double)smokeRand < 0.25) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.25 && (double)smokeRand < 0.5) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.5 && (double)smokeRand < 0.75) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if (!((double)smokeRand > 0.75)) continue;
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.flare", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
        }
        for (int debris = 0; debris < numDebris; ++debris) {
            smokeRand = (float)Math.random();
            if ((double)smokeRand < 0.25) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.25 && (double)smokeRand < 0.5) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, (float)Math.random() * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if ((double)smokeRand > 0.5 && (double)smokeRand < 0.75) {
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, (float)Math.random() * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
                continue;
            }
            if (!((double)smokeRand > 0.75)) continue;
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.debris1", this.field_77284_b, this.field_77285_c, this.field_77282_d, -((float)Math.random()) * mod, (float)Math.random() * mod, -((float)Math.random()) * mod), this.field_77284_b, this.field_77285_c, this.field_77282_d, 150.0f, this.worldObj.field_73011_w.field_76574_g);
        }
    }

    public Map func_77277_b() {
        return this.playerLocations;
    }

    public EntityLivingBase func_94613_c() {
        return this.field_77283_e == null ? null : (this.field_77283_e instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.field_77283_e).func_94083_c() : (this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null));
    }

    public static void clientExplosion(World worldObj, float explosionSize, double explosionX, double explosionY, double explosionZ) {
        double d7;
        double d6;
        double d5;
        int k;
        int j;
        int i;
        ArrayList affectedBlockPositions = new ArrayList();
        Entity exploder = null;
        Explosion explosion = new Explosion(worldObj, exploder, explosionX, explosionY, explosionZ, explosionSize);
        if (explosionSize < 2.0f) {
            explosionX += (double)(explosionRNG.nextFloat() - 0.5f);
            explosionZ += (double)(explosionRNG.nextFloat() - 0.5f);
        }
        boolean isSmoking = true;
        float f = explosionSize;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    d5 = explosionX;
                    d6 = explosionY;
                    d7 = explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = explosionSize * (0.7f + worldObj.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1 = MathHelper.func_76128_c((double)d5);
                        int k1 = MathHelper.func_76128_c((double)d6);
                        int l1 = MathHelper.func_76128_c((double)d7);
                        Block block = worldObj.func_147439_a(j1, k1, l1);
                        float f3 = 0.0f;
                        if ((f1 -= (f3 + 0.3f) * f2) > 0.0f && (exploder == null || exploder.func_145774_a(explosion, worldObj, j1, k1, l1, block, f1))) {
                            hashset.add(new ChunkPosition(j1, k1, l1));
                        }
                        d5 += d0 * (double)f2;
                        d6 += d1 * (double)f2;
                        d7 += d2 * (double)f2;
                    }
                }
            }
        }
        affectedBlockPositions.addAll(hashset);
        i = MathHelper.func_76128_c((double)(explosionX - (double)(explosionSize *= 2.0f) - 1.0));
        j = MathHelper.func_76128_c((double)(explosionX + (double)explosionSize + 1.0));
        k = MathHelper.func_76128_c((double)(explosionY - (double)explosionSize - 1.0));
        int i2 = MathHelper.func_76128_c((double)(explosionY + (double)explosionSize + 1.0));
        int l = MathHelper.func_76128_c((double)(explosionZ - (double)explosionSize - 1.0));
        int j2 = MathHelper.func_76128_c((double)(explosionZ + (double)explosionSize + 1.0));
        List list = worldObj.func_72839_b(exploder, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        Vec3 vec3 = Vec3.func_72443_a((double)explosionX, (double)explosionY, (double)explosionZ);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f(explosionX, explosionY, explosionZ) / (double)explosionSize;
            if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - explosionX) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - explosionY) * d6 + (d7 = entity.field_70161_v - explosionZ) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            double d10 = worldObj.func_72842_a(vec3, entity.field_70121_D);
            double d11 = (1.0 - d4) * d10;
            double d8 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
            entity.field_70159_w += d5 * d8;
            entity.field_70181_x += d6 * d8;
            entity.field_70179_y += d7 * d8;
        }
        explosionSize = f;
        if (explosionSize >= 2.0f && isSmoking) {
            worldObj.func_72869_a("hugeexplosion", explosionX, explosionY, explosionZ, 1.0, 0.0, 0.0);
        } else {
            worldObj.func_72869_a("largeexplode", explosionX, explosionY, explosionZ, 1.0, 0.0, 0.0);
        }
        Iterator iterator = affectedBlockPositions.iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            ++cnt;
            ChunkPosition chunkposition = (ChunkPosition)iterator.next();
            int i3 = chunkposition.field_151329_a;
            int j3 = chunkposition.field_151327_b;
            int k2 = chunkposition.field_151328_c;
            Block block = worldObj.func_147439_a(i3, j3, k2);
            double d0 = (float)i3 + worldObj.field_73012_v.nextFloat();
            double d1 = (float)j3 + worldObj.field_73012_v.nextFloat();
            double d2 = (float)k2 + worldObj.field_73012_v.nextFloat();
            double d3 = d0 - explosionX;
            double d4 = d1 - explosionY;
            double d52 = d2 - explosionZ;
            double d62 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d52 * d52));
            d3 /= d62;
            d4 /= d62;
            d52 /= d62;
            double d72 = 0.5 / (d62 / (double)explosionSize + 0.1);
            d3 *= (d72 *= (double)(worldObj.field_73012_v.nextFloat() * worldObj.field_73012_v.nextFloat() + 0.3f));
            d4 *= d72;
            d52 *= d72;
            if (explosionSize <= 1.0f && cnt % 4 == 0 || explosionSize > 1.0f) {
                FlansMod.proxy.spawnParticle("explode", (d0 + explosionX * 1.0) / 2.0, (d1 + explosionY * 1.0) / 2.0, (d2 + explosionZ * 1.0) / 2.0, d3, d4, d52);
            }
            block = Blocks.field_150350_a;
            if (explosionSize <= 2.0f) {
                if (cnt % 8 == 0) {
                    block = FlansModExplosion.getNearBlock(worldObj, i3, j3, k2);
                }
            } else {
                block = FlansModExplosion.getNearBlock(worldObj, i3, j3, k2);
            }
            if (block == Blocks.field_150350_a) continue;
            float m = explosionSize;
            m = m <= 1.0f ? (m *= 2.0f) : (m *= 0.5f);
            String pname = "blockdust_" + Block.func_149682_b((Block)block) + "_" + worldObj.func_72805_g(i3, j3, k2);
            FlansMod.proxy.spawnParticle(pname, (d0 + explosionX * 1.0) / 2.0, (d1 + explosionY * 1.0) / 2.0, (d2 + explosionZ * 1.0) / 2.0, d3 * (double)m, d4 * (double)m, d52 * (double)m);
        }
    }

    public static Block getNearBlock(World w, int x, int y, int z) {
        int[][] offset = new int[][]{{0, -1, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}};
        for (int i = 0; i < offset.length; ++i) {
            Block block;
            if (y <= 1 && offset[i][1] != 0 || (block = w.func_147439_a(x + offset[i][0], y + offset[i][1], z + offset[i][2])) == Blocks.field_150350_a) continue;
            return block;
        }
        return Blocks.field_150350_a;
    }
}

