/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.animation.AnimationController;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.FlightController;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.eventhandlers.DriveableDeathByHandEvent;
import com.flansmod.common.network.PacketDriveableControl;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.network.PacketPlaneAnimator;
import com.flansmod.common.network.PacketPlaneControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Matrix4f;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class EntityPlane
extends EntityDriveable {
    public float flapsYaw;
    public float flapsPitchLeft;
    public float flapsPitchRight;
    public int soundPosition;
    public int bombDelay;
    public int gunDelay;
    public int ticksSinceUsed = 0;
    public boolean varGear = true;
    public boolean varDoor = false;
    public boolean varWing = false;
    public boolean doorsHaveShut = false;
    public int toggleTimer = 0;
    public EnumPlaneMode mode;
    public Vector3f wingPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f coreWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f coreWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevWingPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevWingRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevWingWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevWingWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevCoreWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevCoreWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevTailWheelPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevTailWheelRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoorPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoorRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public float xSpeed = 0.0f;
    public float ySpeed = 0.0f;
    public float zSpeed = 0.0f;
    public float rollSpeed = 0.0f;
    public FlightController flightController = new FlightController();
    public AnimationController anim = new AnimationController();
    public boolean initiatedAnim = false;

    public EntityPlane(World world) {
        super(world);
    }

    public EntityPlane(World world, double x, double y, double z, PlaneType type, DriveableData data, EntityPlayer p) {
        super(world, type, data, p);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.initType(type, false);
    }

    public EntityPlane(World world, double x, double y, double z, EntityPlayer placer, PlaneType type, DriveableData data) {
        this(world, x, y + 5.625, z, type, data, placer);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.rotatePitch(type.restingPitch);
    }

    @Override
    public void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
        EnumPlaneMode enumPlaneMode = this.mode = ((PlaneType)type).mode == EnumPlaneMode.HELI ? EnumPlaneMode.HELI : EnumPlaneMode.PLANE;
        if (((PlaneType)type).mode == EnumPlaneMode.VTOL) {
            this.mode = EnumPlaneMode.HELI;
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("Pos", (NBTBase)this.func_70087_a(new double[]{this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v}));
        tag.func_74757_a("VarGear", this.varGear);
        tag.func_74757_a("VarDoor", this.varDoor);
        tag.func_74757_a("VarWing", this.varWing);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varGear = tag.func_74767_n("VarGear");
        this.varDoor = tag.func_74767_n("VarDoor");
        this.varWing = tag.func_74767_n("VarWing");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (!FlansMod.proxy.mouseControlEnabled()) {
            return;
        }
        float sensitivity = 0.02f;
        this.flapsPitchLeft -= sensitivity * (float)deltaY;
        this.flapsPitchRight -= sensitivity * (float)deltaY;
        if (this.mode != EnumPlaneMode.SIXDOF) {
            this.flapsPitchLeft -= sensitivity * (float)deltaX;
            this.flapsPitchRight += sensitivity * (float)deltaX;
        } else {
            this.flapsPitchLeft -= sensitivity * (float)deltaX;
            this.flapsPitchRight += sensitivity * (float)deltaX;
        }
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        super.setPositionRotationAndMotion(x, y, z, yaw, pitch, roll, motX, motY, motZ, velYaw, velPitch, velRoll, throt, steeringYaw);
        this.flapsYaw = steeringYaw;
    }

    public void setRotorPosition(float current, float previous) {
        this.rotorAngle = current;
        this.prevRotorAngle = previous;
    }

    public void setPropPosition(float current, float previous) {
        this.propAngle = current;
        this.prevPropAngle = previous;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        PlaneType type = this.getPlaneType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            if (i == 0) {
                this.bombDelay = type.planeBombDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        PlaneType type = this.getPlaneType();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        boolean canThrust = (this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || this.getDriveableData().fuelInTank > 0.0f) && this.isEngineActive() || type.fuelTankSize < 0;
        switch (key) {
            case 0: {
                if (canThrust || this.throttle < 0.0f) {
                    this.throttle += 0.002f;
                    if (this.throttle > 1.0f) {
                        this.throttle = 1.0f;
                    }
                    this.xSpeed += 0.5f;
                }
                return true;
            }
            case 1: {
                if (canThrust || this.throttle > 0.0f) {
                    this.throttle -= 0.005f;
                    if (this.throttle < -1.0f) {
                        this.throttle = -1.0f;
                    }
                    if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                        this.throttle = 0.0f;
                    }
                    this.xSpeed -= 0.5f;
                }
                return true;
            }
            case 2: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsYaw -= 1.0f;
                }
                this.zSpeed -= 1.0f;
                return true;
            }
            case 3: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsYaw += 1.0f;
                }
                this.zSpeed += 1.0f;
                return true;
            }
            case 4: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsPitchLeft += 1.0f;
                    this.flapsPitchRight += 1.0f;
                }
                this.ySpeed += 1.0f;
                return true;
            }
            case 5: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsPitchLeft -= 1.0f;
                    this.flapsPitchRight -= 1.0f;
                }
                this.ySpeed -= 1.0f;
                return true;
            }
            case 6: {
                if (this.seats[0].field_70153_n != null) {
                    this.seats[0].field_70153_n.func_82142_c(false);
                    this.seats[0].field_70153_n.func_70078_a(null);
                }
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K && (type.invInflight || Math.abs(this.throttle) < 0.1f && this.field_70122_E)) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.seats[0].field_70153_n, this.field_70170_p, this);
                }
                return true;
            }
            case 8: 
            case 9: {
                return super.pressKey(key, player);
            }
            case 10: {
                FlansMod.proxy.changeControlMode((EntityPlayer)this.seats[0].field_70153_n);
                this.seats[0].playerLooking = new RotatedAxes(0.0f, 0.0f, 0.0f);
                return true;
            }
            case 11: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsPitchLeft += 1.0f;
                    this.flapsPitchRight -= 1.0f;
                } else {
                    this.flapsYaw -= 0.25f;
                }
                return true;
            }
            case 12: {
                if (this.mode != EnumPlaneMode.SIXDOF) {
                    this.flapsPitchLeft -= 1.0f;
                    this.flapsPitchRight += 1.0f;
                } else {
                    this.flapsYaw += 0.25f;
                }
                return true;
            }
            case 13: {
                if (this.toggleTimer <= 0 && this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)(this.field_70163_u - 3.0), (int)this.field_70161_v)) {
                    this.varGear = !this.varGear;
                    player.func_145747_a((IChatComponent)new ChatComponentText("Landing gear " + (this.varGear ? "down" : "up")));
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 15: {
                if (this.toggleTimer <= 0) {
                    if (type.hasWing) {
                        this.varWing = !this.varWing;
                        player.func_145747_a((IChatComponent)new ChatComponentText("Switching mode"));
                    }
                    if (type.mode == EnumPlaneMode.VTOL) {
                        this.mode = this.mode == EnumPlaneMode.HELI ? EnumPlaneMode.PLANE : EnumPlaneMode.HELI;
                        player.func_145747_a((IChatComponent)new ChatComponentText(this.mode == EnumPlaneMode.HELI ? "Entering hover mode" : "Entering plane mode"));
                    }
                    this.anim.changeState(this.varWing ? 0 : 1);
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 16: {
                this.axes.setAngles(this.axes.getYaw(), 0.0f, 0.0f);
                return true;
            }
            case 17: {
                break;
            }
            case 18: {
                if (!type.hasFlare || this.ticksFlareUsing > 0 || this.flareDelay > 0) break;
                this.ticksFlareUsing = type.timeFlareUsing * 20;
                this.flareDelay = type.flareDelay;
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
                } else if (!type.flareSound.isEmpty()) {
                    PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.flareSound, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        super.updateKeyHeldState(key, held);
        if (!this.field_70170_p.field_72995_K) {
            switch (key) {
                default: 
            }
        }
    }

    @Override
    public void func_70071_h_() {
        boolean thePlayerIsDrivingThis;
        super.func_70071_h_();
        this.prevWingPos = this.wingPos;
        this.prevWingRot = this.wingRot;
        this.prevWingWheelPos = this.wingWheelPos;
        this.prevWingWheelRot = this.wingWheelRot;
        this.prevCoreWheelPos = this.coreWheelPos;
        this.prevCoreWheelRot = this.coreWheelRot;
        this.prevTailWheelPos = this.tailWheelPos;
        this.prevTailWheelRot = this.tailWheelRot;
        this.prevDoorPos = this.doorPos;
        this.prevDoorRot = this.doorRot;
        if (this.getPlaneType().valkyrie) {
            if (!this.initiatedAnim) {
                this.anim.initPoses();
                this.anim.initAnim();
                this.initiatedAnim = true;
                this.anim.changeState(this.varWing ? 0 : 1);
            }
            if (this.initiatedAnim) {
                int i = this.varWing ? 0 : 1;
                this.anim.UpdateAnim(i);
            }
        }
        if (this.initiatedAnim && this.throttle > 0.2f) {
            Vector3f v = this.anim.getFullPosition(new Vector3f(151.0f, -25.0f, -24.0f), this.anim.parts.get(5));
            v = this.axes.findLocalVectorGlobally(new Vector3f(-v.x, -v.y, v.z));
            Vector3f v2 = this.anim.getFullPosition(new Vector3f(151.0f, -25.0f, 24.0f), this.anim.parts.get(8));
            v2 = this.axes.findLocalVectorGlobally(new Vector3f(-v2.x, -v2.y, v2.z));
            for (int i = 0; i < 4; ++i) {
                if (!Float.isNaN(v.x)) {
                    FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.afterburn", this.field_70165_t + (double)(v2.x / 16.0f), this.field_70163_u + (double)(v2.y / 16.0f), this.field_70161_v + (double)(v2.z / 16.0f), 0.0, 0.0, 0.0), this.field_70165_t + (double)(v2.x / 16.0f), this.field_70163_u + (double)(v2.y / 16.0f), this.field_70161_v + (double)(v2.z / 16.0f), 150.0f, this.field_71093_bK);
                }
                if (Float.isNaN(v.x)) continue;
                FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.afterburn", this.field_70165_t + (double)(v.x / 16.0f), this.field_70163_u + (double)(v.y / 16.0f), this.field_70161_v + (double)(v.z / 16.0f), 0.0, 0.0, 0.0), this.field_70165_t + (double)(v.x / 16.0f), this.field_70163_u + (double)(v.y / 16.0f), this.field_70161_v + (double)(v.z / 16.0f), 150.0f, this.field_71093_bK);
            }
        }
        PlaneType type = this.getPlaneType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Plane type null. Not ticking plane");
            return;
        }
        boolean bl = thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        if (type.setPlayerInvisible && !this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.seats[0].field_70153_n.func_82142_c(true);
        }
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.planeLife > 0 && this.ticksSinceUsed > TeamsManager.planeLife * 20) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (this.varFlare || this.ticksFlareUsing > 0) && this.field_70173_aa % 5 == 0) {
            Vector3f dir = this.axes.findLocalVectorGlobally(new Vector3f(0.0f, -0.5f, 0.0f));
            FlansMod.proxy.spawnParticle("flansmod.flare", this.field_70165_t, this.field_70163_u, this.field_70161_v, dir.x, dir.y, dir.z);
        }
        if (this.ticksFlareUsing > 0) {
            --this.ticksFlareUsing;
        }
        if (this.flareDelay > 0) {
            --this.flareDelay;
        }
        if (this.bombDelay > 0) {
            --this.bombDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (!this.varWing) {
            this.wingPos = this.transformPart(this.wingPos, type.wingPos1, type.wingRate);
            this.wingRot = this.transformPart(this.wingRot, type.wingRot1, type.wingRotRate);
        } else {
            this.wingPos = this.transformPart(this.wingPos, type.wingPos2, type.wingRate);
            this.wingRot = this.transformPart(this.wingRot, type.wingRot2, type.wingRotRate);
        }
        if (this.varGear) {
            this.wingWheelPos = this.transformPart(this.wingWheelPos, type.wingWheelPos1, type.wingWheelRate);
            this.wingWheelRot = this.transformPart(this.wingWheelRot, type.wingWheelRot1, type.wingWheelRotRate);
            this.coreWheelPos = this.transformPart(this.coreWheelPos, type.bodyWheelPos1, type.bodyWheelRate);
            this.coreWheelRot = this.transformPart(this.coreWheelRot, type.bodyWheelRot1, type.bodyWheelRotRate);
            this.tailWheelPos = this.transformPart(this.tailWheelPos, type.tailWheelPos1, type.tailWheelRate);
            this.tailWheelRot = this.transformPart(this.tailWheelRot, type.tailWheelRot1, type.tailWheelRotRate);
        } else {
            this.wingWheelPos = this.transformPart(this.wingWheelPos, type.wingWheelPos2, type.wingWheelRate);
            this.wingWheelRot = this.transformPart(this.wingWheelRot, type.wingWheelRot2, type.wingWheelRotRate);
            this.coreWheelPos = this.transformPart(this.coreWheelPos, type.bodyWheelPos2, type.bodyWheelRate);
            this.coreWheelRot = this.transformPart(this.coreWheelRot, type.bodyWheelRot2, type.bodyWheelRotRate);
            this.tailWheelPos = this.transformPart(this.tailWheelPos, type.tailWheelPos2, type.tailWheelRate);
            this.tailWheelRot = this.transformPart(this.tailWheelRot, type.tailWheelRot2, type.tailWheelRotRate);
        }
        if (!this.varDoor) {
            this.doorPos = this.transformPart(this.doorPos, type.doorPos1, type.doorRate);
            this.doorRot = this.transformPart(this.doorRot, type.doorRot1, type.doorRotRate);
        } else {
            this.doorPos = this.transformPart(this.doorPos, type.doorPos2, type.doorRate);
            this.doorRot = this.transformPart(this.doorRot, type.doorRot2, type.doorRotRate);
        }
        if (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)(this.field_70163_u - 10.0), (int)this.field_70161_v) && (double)this.throttle <= 0.4) {
            if (!this.varGear && this.seats[0] != null && this.seats[0].field_70153_n != null && type.autoDeployLandingGearNearGround) {
                ((EntityPlayer)this.seats[0].field_70153_n).func_145747_a((IChatComponent)new ChatComponentText("Deploying landing gear"));
            }
            this.varGear = true;
            if (type.foldWingForLand) {
                if (this.varWing && this.seats[0] != null && this.seats[0].field_70153_n != null) {
                    ((EntityPlayer)this.seats[0].field_70153_n).func_145747_a((IChatComponent)new ChatComponentText("Extending wings"));
                }
                this.varWing = false;
            }
        }
        if (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)(this.field_70163_u - 3.0), (int)this.field_70161_v) && (double)this.throttle <= 0.05 && type.autoOpenDoorsNearGround) {
            if (!this.doorsHaveShut) {
                this.varDoor = true;
            }
            this.doorsHaveShut = true;
        } else if (!type.flyWithOpenDoor) {
            this.varDoor = false;
            this.doorsHaveShut = false;
        }
        if (!this.isPartIntact(EnumDriveablePart.tail) && type.spinWithoutTail) {
            this.flapsYaw = 15.0f;
        }
        this.flapsYaw *= 0.9f;
        this.flapsPitchLeft *= 0.9f;
        this.flapsPitchRight *= 0.9f;
        if (this.flapsYaw > 20.0f) {
            this.flapsYaw = 20.0f;
        }
        if (this.flapsYaw < -20.0f) {
            this.flapsYaw = -20.0f;
        }
        if (this.flapsPitchRight > 20.0f) {
            this.flapsPitchRight = 20.0f;
        }
        if (this.flapsPitchRight < -20.0f) {
            this.flapsPitchRight = -20.0f;
        }
        if (this.flapsPitchLeft > 20.0f) {
            this.flapsPitchLeft = 20.0f;
        }
        if (this.flapsPitchLeft < -20.0f) {
            this.flapsPitchLeft = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        boolean canThrust = this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || data.fuelInTank > 0.0f || type.fuelTankSize < 0;
        float throttlePull = 0.99f;
        if (this.seats[0] != null && this.seats[0].field_70153_n != null && this.mode == EnumPlaneMode.HELI && canThrust && type.heliThrottlePull) {
            this.throttle = (this.throttle - 0.5f) * throttlePull + 0.5f;
        }
        if (!canThrust) {
            this.throttle = (float)((double)this.throttle * 0.99);
            if ((double)this.throttle > 0.8) {
                this.throttle = (float)((double)this.throttle - 0.001);
            }
            if (this.throttle > 0.0f) {
                this.throttle = (float)((double)this.throttle - 0.001);
            }
        }
        this.flightController.fly(this);
        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        if (motion > 10.0) {
            this.field_70159_w *= 10.0 / motion;
            this.field_70181_x *= 10.0 / motion;
            this.field_70179_y *= 10.0 / motion;
        } else if (this.seats[0] == null || !(this.seats[0].field_70153_n instanceof EntityPlayer)) {
            this.field_70159_w *= (double)(1.0f - 0.05f * (type.emptyDrag - 1.0f));
            this.field_70179_y *= (double)(1.0f - 0.05f * (type.emptyDrag - 1.0f));
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null || this.field_70170_p == null || !type.floatOnWater || !this.field_70170_p.func_72953_d(wheel.field_70121_D)) continue;
            this.field_70181_x += (double)type.buoyancy;
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.field_70167_r = wheel.field_70163_u;
            wheel.func_70091_d(this.field_70159_w, this.onDeck ? 0.0 : this.field_70181_x, this.field_70179_y);
        }
        this.correctWheelPos();
        for (int i = 0; i < 2; ++i) {
            Vector3f amountToMoveCar = new Vector3f(this.field_70159_w / 2.0, this.onDeck ? 0.0 : this.field_70181_x / 2.0, this.field_70179_y / 2.0);
            for (EntityWheel wheel : this.wheels) {
                if (wheel == null) continue;
                this.field_70122_E = true;
                wheel.field_70122_E = true;
                wheel.field_70177_z = this.axes.getYaw();
                Vector3f wPos = this.getPlaneType().wheelPositions[wheel.ID].position;
                if (type.valkyrie && this.varWing) {
                    wPos = new Vector3f(wPos.x, wPos.y + 5.625f, wPos.z);
                }
                Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(wPos);
                Vector3f currentWheelPos = new Vector3f(wheel.field_70165_t - this.field_70165_t, wheel.field_70163_u - this.field_70163_u, wheel.field_70161_v - this.field_70161_v);
                float targetWheelLength = targetWheelPos.length();
                float currentWheelLength = currentWheelPos.length();
                float dLength = targetWheelLength - currentWheelLength;
                float dAngle = Vector3f.angle(targetWheelPos, currentWheelPos);
                if (Float.isNaN(dAngle) || (double)currentWheelLength < 1.0E-4) continue;
                float newLength = currentWheelLength + dLength * type.wheelSpringStrength;
                Vector3f rotateAround = Vector3f.cross(targetWheelPos, currentWheelPos, null);
                Matrix4f mat = new Matrix4f();
                mat.m00 = currentWheelPos.x;
                mat.m10 = currentWheelPos.y;
                mat.m20 = currentWheelPos.z;
                mat.rotate(dAngle * type.wheelSpringStrength, rotateAround);
                if (!(this.field_70173_aa <= 5 || type.valkyrie && this.anim.timeSinceSwitch < 10)) {
                    this.axes.rotateGlobal(-dAngle * type.wheelSpringStrength, rotateAround);
                }
                Vector3f newWheelPos = new Vector3f(mat.m00, mat.m10, mat.m20);
                newWheelPos.normalise().scale(newLength);
                float wheelProportion = 0.75f;
                Vector3f amountToMoveWheel = new Vector3f();
                amountToMoveWheel.x = (newWheelPos.x - currentWheelPos.x) * (1.0f - wheelProportion);
                amountToMoveWheel.y = (newWheelPos.y - currentWheelPos.y) * (1.0f - wheelProportion);
                amountToMoveWheel.z = (newWheelPos.z - currentWheelPos.z) * (1.0f - wheelProportion);
                amountToMoveCar.x -= (newWheelPos.x - currentWheelPos.x) * (1.0f - wheelProportion);
                amountToMoveCar.y -= (newWheelPos.y - currentWheelPos.y) * (1.0f - wheelProportion);
                amountToMoveCar.z -= (newWheelPos.z - currentWheelPos.z) * (1.0f - wheelProportion);
                amountToMoveCar.y = (float)((double)amountToMoveCar.y + (wheel.field_70163_u - wheel.field_70167_r - (this.onDeck ? 0.0 : this.field_70181_x)) * 0.5 / (double)this.wheels.length);
                wheel.func_70091_d(amountToMoveWheel.x, amountToMoveWheel.y, amountToMoveWheel.z);
            }
            this.func_70091_d(amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        }
        if (this.field_70154_o != null && this.field_70154_o.getClass().toString().indexOf("mcheli.aircraft.MCH_EntitySeat") > 0) {
            this.axes.setAngles(this.field_70154_o.field_70177_z + 90.0f, 0.0f, 0.0f);
        }
        this.checkForCollisions();
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketPlaneControl(this));
            FlansMod.getPacketHandler().sendToServer(new PacketPlaneAnimator(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        float updateSpeed = 0.01f;
        if (!this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketPlaneControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
            FlansMod.getPacketHandler().sendToAllAround(new PacketPlaneAnimator(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.func_70106_y();
        }
    }

    @Override
    public boolean gearDown() {
        return this.varGear;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i, boolean doDamage) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        PlaneType type = PlaneType.getPlane(this.driveableType);
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null) && (damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d || TeamsManager.survivalCanBreakVehicles)) {
            ItemStack planeStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            planeStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(planeStack.field_77990_d);
            DriveableDeathByHandEvent driveableDeathByHandEvent = new DriveableDeathByHandEvent(this, (EntityPlayer)damagesource.func_76346_g(), planeStack);
            MinecraftForge.EVENT_BUS.post((Event)driveableDeathByHandEvent);
            if (!driveableDeathByHandEvent.isCanceled()) {
                this.func_70099_a(planeStack, 0.5f);
                if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityPlayer) {
                    FlansMod.log("Player %s broke plane %s (%d) at (%f, %f, %f)", ((EntityPlayerMP)damagesource.func_76346_g()).getDisplayName(), type.shortName, this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70106_y();
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    @Override
    public boolean canHitPart(EnumDriveablePart part) {
        return this.varGear || part != EnumDriveablePart.coreWheel && part != EnumDriveablePart.leftWingWheel && part != EnumDriveablePart.rightWingWheel && part != EnumDriveablePart.tailWheel;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        return this.attackEntityFrom(damagesource, i, true);
    }

    public PlaneType getPlaneType() {
        return PlaneType.getPlane(this.driveableType);
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    public Vector3f transformPart(Vector3f current, Vector3f target, Vector3f rate) {
        if (Math.sqrt((current.x - target.x) * (current.x - target.x)) > (double)(rate.x / 2.0f)) {
            if (current.x > target.x) {
                current.x -= rate.x;
            } else if (current.x < target.x) {
                current.x += rate.x;
            }
        } else {
            current.x = target.x;
        }
        if (Math.sqrt((current.y - target.y) * (current.y - target.y)) > (double)(rate.y / 2.0f)) {
            if (current.y > target.y) {
                current.y -= rate.y;
            } else if (current.y < target.y) {
                current.y += rate.y;
            }
        } else {
            current.y = target.y;
        }
        if (Math.sqrt((current.z - target.z) * (current.z - target.z)) > (double)(rate.z / 2.0f)) {
            if (current.z > target.z) {
                current.z -= rate.z;
            } else if (current.z < target.z) {
                current.z += rate.z;
            }
        } else {
            current.z = target.z;
        }
        return current;
    }

    @Override
    public String getBombInventoryName() {
        return "Bombs";
    }

    @Override
    public String getMissileInventoryName() {
        return "Missiles";
    }

    @Override
    public boolean hasMouseControlMode() {
        return true;
    }
}

