/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.vector.Vector3f;

public class CollisionBox {
    public float x;
    public float y;
    public float z;
    public float w;
    public float h;
    public float d;
    public float health;
    public EnumDriveablePart part;
    public float penetrationResistance = 5.0f;

    public CollisionBox(float health, int x, int y, int z, int w, int h, int d) {
        this.health = health;
        this.x = (float)x / 16.0f;
        this.y = (float)y / 16.0f;
        this.z = (float)z / 16.0f;
        this.w = (float)w / 16.0f;
        this.h = (float)h / 16.0f;
        this.d = (float)d / 16.0f;
    }

    public CollisionBox(float health, int x, int y, int z, int w, int h, int d, float penResistance) {
        this(health, x, y, z, w, h, d);
        this.penetrationResistance = penResistance;
    }

    public Vector3f getCentre() {
        return new Vector3f(this.x + this.w / 2.0f, this.y + this.h / 2.0f, this.z + this.d / 2.0f);
    }

    public Vector3f getRootPosition() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public float getRadius() {
        return new Vector3f(this.w / 2.0f, this.h / 2.0f, this.d / 2.0f).length();
    }
}

