/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.AnimTankTrack;
import com.flansmod.client.model.AnimTrackLink;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.tmt.ModelRendererTurbo;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ModelVehicle
extends ModelDriveable {
    public ModelRendererTurbo[] turretModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] barrelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] ammoModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] frontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] backWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFrontLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFrontLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftBackLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightBackLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] leftAnimTrackModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[][] rightAnimTrackModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] fancyTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimTrackModel1 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimTrackModel1 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimTrackModel2 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimTrackModel2 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimTrackModel3 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimTrackModel3 = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] trailerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] steeringWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drillHeadModel = new ModelRendererTurbo[0];
    public Vector3f drillHeadOrigin = new Vector3f();
    public ModelRendererTurbo[] barrelSpecModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] animBarrelModel = new ModelRendererTurbo[0];
    public Vector3f barrelAttach = new Vector3f();
    public ModelRendererTurbo[] doorAnimModel = new ModelRendererTurbo[0];
    public Vector3f doorAttach = new Vector3f();
    public ModelRendererTurbo[] door2AnimModel = new ModelRendererTurbo[0];
    public Vector3f door2Attach = new Vector3f();
    public ModelRendererTurbo[] drakonModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drakonReloadModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drakonArmModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drakonRailModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drakonDoorModel = new ModelRendererTurbo[0];
    public Vector3f drakonArmAttach = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f drakonRailAttach = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f drakonDoorAttach = new Vector3f(0.0f, 0.0f, 0.0f);
    public float animFrameLeft = 0.0f;
    public float animFrameRight = 0.0f;
    public Vector3f turretScale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f turretTrans = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean fancyTurret = false;
    public String turretName;
    public float legMoveSpeed = 1.0f;
    public float legMaxMove = 1.0f;
    public float legSteerAmount = 1.0f;
    public boolean legSpeedChange = true;

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityVehicle)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.leftBackWheelModel);
        this.renderPart(this.rightBackWheelModel);
        this.renderPart(this.leftFrontWheelModel);
        this.renderPart(this.rightFrontWheelModel);
        this.renderPart(this.rightTrackModel);
        this.renderPart(this.leftTrackModel);
        this.renderPart(this.leftFrontLegModel);
        this.renderPart(this.rightFrontLegModel);
        this.renderPart(this.leftBackLegModel);
        this.renderPart(this.rightBackLegModel);
        this.renderPart(this.rightTrackWheelModels);
        this.renderPart(this.leftTrackWheelModels);
        this.renderPart(this.bodyDoorCloseModel);
        this.renderPart(this.trailerModel);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.turretScale.x, (float)this.turretScale.y, (float)this.turretScale.z);
        GL11.glTranslatef((float)this.turretTrans.x, (float)this.turretTrans.y, (float)this.turretTrans.z);
        this.renderPart(this.turretModel);
        this.renderPart(this.barrelModel);
        GL11.glPopMatrix();
        this.renderPart(this.drillHeadModel);
        for (ModelRendererTurbo[] mods : this.ammoModel) {
            this.renderPart(mods);
        }
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.renderPart(latm);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.renderPart(ratm);
        }
        this.renderPart(this.rightAnimTrackModel1);
        this.renderPart(this.leftAnimTrackModel1);
        this.renderPart(this.rightAnimTrackModel2);
        this.renderPart(this.leftAnimTrackModel2);
        this.renderPart(this.rightAnimTrackModel3);
        this.renderPart(this.leftAnimTrackModel3);
        this.renderPart(this.steeringWheelModel);
        this.renderPart(this.steeringWheelModel);
        this.renderPart(this.barrelSpecModel);
        this.renderTrackInGUI(type);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.barrelAttach.x, (float)this.barrelAttach.y, (float)(-this.barrelAttach.z));
        this.renderPart(this.animBarrelModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.doorAttach.x, (float)this.doorAttach.y, (float)(-this.doorAttach.z));
        this.renderPart(this.doorAnimModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.door2Attach.x, (float)this.door2Attach.y, (float)(-this.door2Attach.z));
        this.renderPart(this.door2AnimModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.drakonArmAttach.x, (float)this.drakonArmAttach.y, (float)this.drakonArmAttach.z);
        this.renderPart(this.drakonArmModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.drakonRailAttach.x, (float)this.drakonRailAttach.y, (float)this.drakonRailAttach.z);
        this.renderPart(this.drakonRailModel);
        this.renderPart(this.drakonModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.drakonDoorAttach.x, (float)this.drakonDoorAttach.y, (float)this.drakonDoorAttach.z);
        this.renderPart(this.drakonDoorModel);
        GL11.glPopMatrix();
    }

    public void renderTrackInGUI(DriveableType type) {
        float rotZ;
        AnimTankTrack rightTrack = new AnimTankTrack(type.rightTrackPoints, type.trackLinkLength);
        AnimTankTrack leftTrack = new AnimTankTrack(type.leftTrackPoints, type.trackLinkLength);
        int numLinks = Math.round(rightTrack.getTrackLength() / type.trackLinkLength);
        AnimTrackLink[] trackLinksLeft = new AnimTrackLink[numLinks];
        AnimTrackLink[] trackLinksRight = new AnimTrackLink[numLinks];
        for (int i = 0; i < numLinks; ++i) {
            float progress = 0.01f + type.trackLinkLength * (float)i;
            int trackPart = leftTrack.getTrackPart(progress);
            trackLinksLeft[i] = new AnimTrackLink(progress);
            trackLinksRight[i] = new AnimTrackLink(progress);
            trackLinksLeft[i].position = leftTrack.getPositionOnTrack(progress);
            trackLinksRight[i].position = rightTrack.getPositionOnTrack(progress);
            trackLinksLeft[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(leftTrack.points.get(trackPart == 0 ? leftTrack.points.size() - 1 : trackPart - 1), trackLinksLeft[i].position));
            trackLinksRight[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(rightTrack.points.get(trackPart == 0 ? rightTrack.points.size() - 1 : trackPart - 1), trackLinksRight[i].position));
            trackLinksLeft[i].zRot = this.rotateTowards(leftTrack.points.get(trackPart == 0 ? leftTrack.points.size() - 1 : trackPart - 1), trackLinksLeft[i].position);
            trackLinksRight[i].zRot = this.rotateTowards(rightTrack.points.get(trackPart == 0 ? rightTrack.points.size() - 1 : trackPart - 1), trackLinksRight[i].position);
        }
        for (AnimTrackLink link : trackLinksLeft) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(link.position.x / 16.0f), (float)(link.position.y / 16.0f), (float)(link.position.z / 16.0f));
            for (rotZ = link.zRot; rotZ > 180.0f; rotZ -= 360.0f) {
            }
            while (rotZ <= -180.0f) {
                rotZ += 360.0f;
            }
            GL11.glRotatef((float)(rotZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderPart(this.fancyTrackModel);
            GL11.glPopMatrix();
        }
        for (AnimTrackLink link : trackLinksRight) {
            for (rotZ = link.zRot; rotZ > 180.0f; rotZ -= 360.0f) {
            }
            while (rotZ <= -180.0f) {
                rotZ += 360.0f;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(link.position.x / 16.0f), (float)(link.position.y / 16.0f), (float)(link.position.z / 16.0f));
            GL11.glRotatef((float)(rotZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderPart(this.fancyTrackModel);
            GL11.glPopMatrix();
        }
    }

    public float rotateTowards(Vector3f point, Vector3f original) {
        return (float)Math.atan2(point.y - original.y, point.x - original.x);
    }

    public void render(float f5, EntityVehicle vehicle, float f) {
        int n;
        boolean blStomp;
        boolean rotateWheels = vehicle.getVehicleType().rotateWheels;
        this.animFrameLeft = vehicle.animFrameLeft;
        this.animFrameRight = vehicle.animFrameRight;
        float bias = 0.1f;
        float scaleRight = vehicle.lastRelSpeedRight * (1.0f - bias) + (this.legSpeedChange ? vehicle.throttle : 1.0f) * (1.0f - vehicle.wheelsYaw / 20.0f * this.legSteerAmount) * bias;
        float scaleLeft = vehicle.lastRelSpeedLeft * (1.0f - bias) + (this.legSpeedChange ? vehicle.throttle : 1.0f) * (1.0f + vehicle.wheelsYaw / 20.0f * this.legSteerAmount) * bias;
        vehicle.lastRelSpeedRight = scaleRight;
        vehicle.lastRelSpeedLeft = scaleLeft;
        float adjScaleRight = this.legSpeedChange ? Math.signum(scaleRight) * 0.4f + 0.6f * scaleRight * scaleRight : scaleRight;
        float adjScaleLeft = this.legSpeedChange ? Math.signum(scaleLeft) * 0.4f + 0.6f * scaleLeft * scaleLeft : scaleLeft;
        scaleRight = (float)Math.sqrt(Math.abs(scaleRight)) * (this.legSpeedChange ? 1.0f : Math.min(1.0f, Math.abs(vehicle.throttle) * 10.0f));
        scaleLeft = (float)Math.sqrt(Math.abs(scaleLeft)) * (this.legSpeedChange ? 1.0f : Math.min(1.0f, Math.abs(vehicle.throttle) * 10.0f));
        scaleRight = (double)scaleRight > 0.01 ? scaleRight : 0.0f;
        float f2 = scaleLeft = (double)scaleLeft > 0.01 ? scaleLeft : 0.0f;
        if (!Minecraft.func_71410_x().func_147113_T()) {
            vehicle.legAnimPosRight += adjScaleRight * f;
            vehicle.legAnimPosLeft += adjScaleLeft * f;
        }
        float frLegYaw = (float)Math.sin((double)(vehicle.legAnimPosRight * this.legMoveSpeed) + 0.0) * scaleRight * this.legMaxMove;
        float brLegYaw = (float)Math.sin((double)(vehicle.legAnimPosRight * this.legMoveSpeed) + 4.71) * scaleRight * this.legMaxMove;
        float flLegYaw = (float)Math.sin((double)(vehicle.legAnimPosLeft * this.legMoveSpeed) + 3.14) * scaleLeft * this.legMaxMove;
        float blLegYaw = (float)Math.sin((double)(vehicle.legAnimPosLeft * this.legMoveSpeed) + 7.8500000000000005) * scaleLeft * this.legMaxMove;
        boolean frStomp = frLegYaw * vehicle.frLegYawLast < 0.0f;
        boolean flStomp = flLegYaw * vehicle.flLegYawLast < 0.0f;
        boolean brStomp = brLegYaw * vehicle.brLegYawLast < 0.0f;
        boolean bl = blStomp = blLegYaw * vehicle.blLegYawLast < 0.0f;
        if (frStomp && vehicle.getVehicleType().stompSoundFrontRight != null) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound(vehicle.getVehicleType().stompSoundFrontRight), 10.0f, 1.0f / (float)(Math.random() * (double)0.4f + (double)0.8f), (float)vehicle.field_70165_t, (float)vehicle.field_70163_u, (float)vehicle.field_70161_v));
        }
        if (flStomp && vehicle.getVehicleType().stompSoundFrontLeft != null) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound(vehicle.getVehicleType().stompSoundFrontLeft), 10.0f, 1.0f / (float)(Math.random() * (double)0.4f + (double)0.8f), (float)vehicle.field_70165_t, (float)vehicle.field_70163_u, (float)vehicle.field_70161_v));
        }
        if (brStomp && vehicle.getVehicleType().stompSoundBackRight != null) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound(vehicle.getVehicleType().stompSoundBackRight), 10.0f, 1.0f / (float)(Math.random() * (double)0.4f + (double)0.8f), (float)vehicle.field_70165_t, (float)vehicle.field_70163_u, (float)vehicle.field_70161_v));
        }
        if (blStomp && vehicle.getVehicleType().stompSoundBackLeft != null) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound(vehicle.getVehicleType().stompSoundBackLeft), 10.0f, 1.0f / (float)(Math.random() * (double)0.4f + (double)0.8f), (float)vehicle.field_70165_t, (float)vehicle.field_70163_u, (float)vehicle.field_70161_v));
        }
        vehicle.frLegYawLast = frLegYaw;
        vehicle.flLegYawLast = flLegYaw;
        vehicle.brLegYawLast = brLegYaw;
        vehicle.blLegYawLast = blLegYaw;
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aBodyModel : this.bodyModel) {
                aBodyModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aBodyDoorOpenModel : this.bodyDoorOpenModel) {
                if (!vehicle.varDoor) continue;
                aBodyDoorOpenModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aBodyDoorCloseModel : this.bodyDoorCloseModel) {
                if (vehicle.varDoor) continue;
                aBodyDoorCloseModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aSteeringWheelModel : this.steeringWheelModel) {
                aSteeringWheelModel.field_78795_f = !vehicle.hugeBoat ? vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f : -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aSteeringWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backLeftWheel)) {
            for (ModelRendererTurbo aLeftBackWheelModel : this.leftBackWheelModel) {
                aLeftBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aLeftBackWheelModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aLeftBackLegModel : this.leftBackLegModel) {
                aLeftBackLegModel.field_78808_h = blLegYaw * (float)Math.PI / 2.5f;
                aLeftBackLegModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backRightWheel)) {
            for (ModelRendererTurbo aRightBackWheelModel : this.rightBackWheelModel) {
                aRightBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aRightBackWheelModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aRightBackLegModel : this.rightBackLegModel) {
                aRightBackLegModel.field_78808_h = brLegYaw * (float)Math.PI / 2.5f;
                aRightBackLegModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontLeftWheel)) {
            for (ModelRendererTurbo aLeftFrontWheelModel : this.leftFrontWheelModel) {
                aLeftFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aLeftFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aLeftFrontWheelModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aLeftFrontLegModel : this.leftFrontLegModel) {
                aLeftFrontLegModel.field_78808_h = flLegYaw * (float)Math.PI / 2.5f;
                aLeftFrontLegModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontRightWheel)) {
            for (ModelRendererTurbo aRightFrontWheelModel : this.rightFrontWheelModel) {
                aRightFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aRightFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aRightFrontWheelModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo aRightFrontLegModel : this.rightFrontLegModel) {
                aRightFrontLegModel.field_78808_h = frLegYaw * (float)Math.PI / 2.5f;
                aRightFrontLegModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontWheel)) {
            for (ModelRendererTurbo aFrontWheelModel : this.frontWheelModel) {
                aFrontWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aFrontWheelModel.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                aFrontWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backWheel)) {
            for (ModelRendererTurbo aBackWheelModel : this.backWheelModel) {
                aBackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                aBackWheelModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.leftTrack)) {
            for (ModelRendererTurbo aLeftTrackModel : this.leftTrackModel) {
                aLeftTrackModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo leftTrackWheelModel : this.leftTrackWheelModels) {
                leftTrackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                leftTrackWheelModel.render(f5, this.oldRotateOrder);
            }
            if (vehicle.animFrameLeft == 0) {
                for (ModelRendererTurbo aLeftTrackModel1 : this.leftAnimTrackModel1) {
                    aLeftTrackModel1.render(f5, this.oldRotateOrder);
                }
            } else if (vehicle.animFrameLeft == 1) {
                for (ModelRendererTurbo aLeftTrackModel2 : this.leftAnimTrackModel2) {
                    aLeftTrackModel2.render(f5, this.oldRotateOrder);
                }
            } else if (vehicle.animFrameLeft == 2) {
                for (ModelRendererTurbo aLeftTrackModel3 : this.leftAnimTrackModel3) {
                    aLeftTrackModel3.render(f5, this.oldRotateOrder);
                }
            }
            for (int i = 0; i < this.leftAnimTrackModel.length; ++i) {
                if ((float)i != this.animFrameLeft) continue;
                ModelRendererTurbo[] modelRendererTurboArray = this.leftAnimTrackModel[i];
                n = modelRendererTurboArray.length;
                for (int aLeftTrackModel3 = 0; aLeftTrackModel3 < n; ++aLeftTrackModel3) {
                    ModelRendererTurbo aLeftAnimTrackModel = modelRendererTurboArray[aLeftTrackModel3];
                    aLeftAnimTrackModel.render(f5, this.oldRotateOrder);
                }
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.rightTrack)) {
            for (ModelRendererTurbo aRightTrackModel : this.rightTrackModel) {
                aRightTrackModel.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo rightTrackWheelModel : this.rightTrackWheelModels) {
                rightTrackWheelModel.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                rightTrackWheelModel.render(f5, this.oldRotateOrder);
            }
            if (vehicle.animFrameRight == 0) {
                for (ModelRendererTurbo aRightTrackModel1 : this.rightAnimTrackModel1) {
                    aRightTrackModel1.render(f5, this.oldRotateOrder);
                }
            } else if (vehicle.animFrameRight == 1) {
                for (ModelRendererTurbo aRightTrackModel2 : this.rightAnimTrackModel2) {
                    aRightTrackModel2.render(f5, this.oldRotateOrder);
                }
            } else if (vehicle.animFrameRight == 2) {
                for (ModelRendererTurbo aRightTrackModel3 : this.rightAnimTrackModel3) {
                    aRightTrackModel3.render(f5, this.oldRotateOrder);
                }
            }
            for (int i = 0; i < this.rightAnimTrackModel.length; ++i) {
                if ((float)i != this.animFrameRight) continue;
                ModelRendererTurbo[] modelRendererTurboArray = this.rightAnimTrackModel[i];
                n = modelRendererTurboArray.length;
                for (int aRightTrackModel3 = 0; aRightTrackModel3 < n; ++aRightTrackModel3) {
                    ModelRendererTurbo aRightAnimTrackModel = modelRendererTurboArray[aRightTrackModel3];
                    aRightAnimTrackModel.render(f5, this.oldRotateOrder);
                }
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.trailer)) {
            for (ModelRendererTurbo aTrailerModel : this.trailerModel) {
                aTrailerModel.render(f5, this.oldRotateOrder);
            }
        }
        for (EntitySeat seat : vehicle.seats) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part) || vehicle.rotateWithTurret(seat.seatInfo)) continue;
            float yaw = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * f;
            float pitch = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                GL11.glPushMatrix();
                GL11.glScalef((float)vehicle.getVehicleType().vehicleGunModelScale, (float)vehicle.getVehicleType().vehicleGunModelScale, (float)vehicle.getVehicleType().vehicleGunModelScale);
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)vehicle.getVehicleType().vehicleGunModelScale, (float)vehicle.getVehicleType().vehicleGunModelScale, (float)vehicle.getVehicleType().vehicleGunModelScale);
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            GL11.glPopMatrix();
        }
    }

    public void renderDoor(EntityVehicle vehicle, float f5) {
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aDoorAnimModel : this.doorAnimModel) {
                aDoorAnimModel.func_78785_a(f5);
            }
        }
    }

    public void renderDoor2(EntityVehicle vehicle, float f5) {
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aDoor2AnimModel : this.door2AnimModel) {
                aDoor2AnimModel.func_78785_a(f5);
            }
        }
    }

    public void renderTurret(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle, float dt) {
        float dDoorAngle;
        float dRailAngle;
        float dArmAngle;
        VehicleType type = vehicle.getVehicleType();
        GL11.glPushMatrix();
        GL11.glScalef((float)this.turretScale.x, (float)this.turretScale.y, (float)this.turretScale.z);
        GL11.glTranslatef((float)this.turretTrans.x, (float)this.turretTrans.y, (float)this.turretTrans.z);
        if (this.fancyTurret) {
            ResourceLocation turretobj = new ResourceLocation("flansmod", "models/" + this.turretName);
            IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)turretobj);
            GL11.glPushMatrix();
            float scale = 1.0f;
            model.renderAll();
            GL11.glPopMatrix();
        }
        float yaw = vehicle.seats[0].looking.getYaw();
        float pitch = vehicle.seats[0].looking.getPitch();
        float dPitch = vehicle.seats[0].looking.getPitch() - vehicle.seats[0].prevLooking.getPitch();
        float aPitch = vehicle.seats[0].prevLooking.getPitch() + dPitch * dt;
        for (ModelRendererTurbo aTurretModel : this.turretModel) {
            aTurretModel.render(f5, this.oldRotateOrder);
        }
        for (ModelRendererTurbo aBarrelModel : this.barrelModel) {
            aBarrelModel.field_78808_h = -(aPitch * (float)Math.PI / 180.0f);
            aBarrelModel.render(f5, this.oldRotateOrder);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.barrelAttach.x, (float)this.barrelAttach.y, (float)(-this.barrelAttach.z));
        GL11.glRotatef((float)(-aPitch), (float)0.0f, (float)0.0f, (float)1.0f);
        for (ModelRendererTurbo aBarrelModel : this.barrelSpecModel) {
            aBarrelModel.render(f5, this.oldRotateOrder);
        }
        GL11.glPopMatrix();
        for (int i = 0; i < this.ammoModel.length; ++i) {
            if (i < type.numMissileSlots && vehicle.getDriveableData().missiles[i] == null) continue;
            for (int j = 0; j < this.ammoModel[i].length; ++j) {
                this.ammoModel[i][j].field_78808_h = -pitch * (float)Math.PI / 180.0f;
                this.ammoModel[i][j].render(f5, this.oldRotateOrder);
            }
        }
        float armAngle = vehicle.drakonArmAngle;
        for (dArmAngle = vehicle.drakonArmAngle - vehicle.prevDrakonArmAngle; dArmAngle > 180.0f; dArmAngle -= 360.0f) {
        }
        while (dArmAngle <= -180.0f) {
            dArmAngle += 360.0f;
        }
        float drakonArmAngle = vehicle.prevDrakonArmAngle + dArmAngle * dt;
        float railAngle = vehicle.drakonRailAngle;
        for (dRailAngle = vehicle.drakonRailAngle - vehicle.prevDrakonRailAngle; dRailAngle > 180.0f; dRailAngle -= 360.0f) {
        }
        while (dRailAngle <= -180.0f) {
            dRailAngle += 360.0f;
        }
        float drakonRailAngle = vehicle.prevDrakonRailAngle + dRailAngle * dt;
        float doorAngle = vehicle.drakonDoorAngle;
        for (dDoorAngle = vehicle.drakonDoorAngle - vehicle.prevDrakonDoorAngle; dDoorAngle > 180.0f; dDoorAngle -= 360.0f) {
        }
        while (dDoorAngle <= -180.0f) {
            dDoorAngle += 360.0f;
        }
        float drakonDoorAngle = vehicle.prevDrakonDoorAngle + dDoorAngle * dt;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.drakonArmAttach.x, (float)this.drakonArmAttach.y, (float)this.drakonArmAttach.z);
        GL11.glRotatef((float)drakonArmAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        for (ModelRendererTurbo aArmModel : this.drakonArmModel) {
            aArmModel.render(f5, this.oldRotateOrder);
        }
        GL11.glTranslatef((float)(this.drakonRailAttach.x - this.drakonArmAttach.x), (float)(this.drakonRailAttach.y - this.drakonArmAttach.y), (float)(this.drakonRailAttach.z - this.drakonArmAttach.z));
        GL11.glRotatef((float)drakonRailAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        for (ModelRendererTurbo aRailModel : this.drakonRailModel) {
            aRailModel.render(f5, this.oldRotateOrder);
        }
        if (vehicle.canFireIT1) {
            for (ModelRendererTurbo aMissileModel : this.drakonModel) {
                aMissileModel.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.reloadingDrakon && !vehicle.canFireIT1) {
            for (ModelRendererTurbo aMissileModel : this.drakonReloadModel) {
                aMissileModel.render(f5, this.oldRotateOrder);
            }
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.drakonDoorAttach.x, (float)this.drakonDoorAttach.y, (float)this.drakonDoorAttach.z);
        GL11.glRotatef((float)drakonDoorAngle, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo aDoorModel : this.drakonDoorModel) {
            aDoorModel.render(f5, this.oldRotateOrder);
        }
        GL11.glPopMatrix();
        for (EntitySeat seat : vehicle.seats) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part) || !vehicle.rotateWithTurret(seat.seatInfo)) continue;
            EntitySeat driverSeat = vehicle.seats[0];
            float driverYaw = driverSeat.prevLooking.getYaw() + (driverSeat.looking.getYaw() - driverSeat.prevLooking.getYaw()) * dt;
            float yaw2 = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * dt;
            float pitch2 = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * dt;
            float effectiveYaw = yaw2 - driverYaw;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
        }
        GL11.glPopMatrix();
    }

    public void renderAnimBarrel(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle, float dt) {
        if (vehicle.isPartIntact(EnumDriveablePart.turret)) {
            for (ModelRendererTurbo aAnimBarrelModel : this.animBarrelModel) {
                aAnimBarrelModel.render(f5, this.oldRotateOrder);
            }
        }
    }

    public void renderDrillBit(EntityVehicle vehicle, float f) {
        if (vehicle.isPartIntact(EnumDriveablePart.harvester)) {
            for (ModelRendererTurbo adrillHeadModel : this.drillHeadModel) {
                adrillHeadModel.render(0.0625f, this.oldRotateOrder);
            }
        }
    }

    public void renderFancyTracks(EntityVehicle vehicle, float f) {
        for (ModelRendererTurbo adrillHeadModel : this.fancyTrackModel) {
            adrillHeadModel.render(0.0625f, this.oldRotateOrder);
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.bodyDoorOpenModel);
        this.flip(this.bodyDoorCloseModel);
        this.flip(this.turretModel);
        this.flip(this.barrelModel);
        this.flip(this.barrelSpecModel);
        this.flip(this.animBarrelModel);
        this.flip(this.leftFrontWheelModel);
        this.flip(this.rightFrontWheelModel);
        this.flip(this.leftBackWheelModel);
        this.flip(this.rightBackWheelModel);
        this.flip(this.rightFrontLegModel);
        this.flip(this.leftFrontLegModel);
        this.flip(this.rightBackLegModel);
        this.flip(this.leftBackLegModel);
        this.flip(this.rightTrackModel);
        this.flip(this.leftTrackModel);
        this.flip(this.rightTrackWheelModels);
        this.flip(this.leftTrackWheelModels);
        this.flip(this.trailerModel);
        this.flip(this.steeringWheelModel);
        this.flip(this.frontWheelModel);
        this.flip(this.backWheelModel);
        this.flip(this.drillHeadModel);
        this.flip(this.rightAnimTrackModel1);
        this.flip(this.leftAnimTrackModel1);
        this.flip(this.rightAnimTrackModel2);
        this.flip(this.leftAnimTrackModel2);
        this.flip(this.rightAnimTrackModel3);
        this.flip(this.leftAnimTrackModel3);
        this.flip(this.drakonArmModel);
        this.flip(this.drakonRailModel);
        this.flip(this.drakonDoorModel);
        this.flip(this.drakonModel);
        this.flip(this.drakonReloadModel);
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.flip(latm);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.flip(ratm);
        }
        this.flip(this.doorAnimModel);
        this.flip(this.door2AnimModel);
        this.flip(this.fancyTrackModel);
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.bodyDoorOpenModel, x, y, z);
        this.translate(this.bodyDoorCloseModel, x, y, z);
        this.translate(this.turretModel, x, y, z);
        this.translate(this.barrelModel, x, y, z);
        this.translate(this.barrelSpecModel, x, y, z);
        this.translate(this.animBarrelModel, x, y, z);
        this.translate(this.leftFrontWheelModel, x, y, z);
        this.translate(this.rightFrontWheelModel, x, y, z);
        this.translate(this.leftBackWheelModel, x, y, z);
        this.translate(this.rightBackWheelModel, x, y, z);
        this.translate(this.leftFrontLegModel, x, y, z);
        this.translate(this.rightFrontLegModel, x, y, z);
        this.translate(this.leftBackLegModel, x, y, z);
        this.translate(this.rightBackLegModel, x, y, z);
        this.translate(this.rightTrackModel, x, y, z);
        this.translate(this.leftTrackModel, x, y, z);
        this.translate(this.rightTrackWheelModels, x, y, z);
        this.translate(this.leftTrackWheelModels, x, y, z);
        this.translate(this.trailerModel, x, y, z);
        this.translate(this.steeringWheelModel, x, y, z);
        this.translate(this.frontWheelModel, x, y, z);
        this.translate(this.backWheelModel, x, y, z);
        this.translate(this.drillHeadModel, x, y, z);
        this.translate(this.rightAnimTrackModel1, x, y, z);
        this.translate(this.leftAnimTrackModel1, x, y, z);
        this.translate(this.rightAnimTrackModel2, x, y, z);
        this.translate(this.leftAnimTrackModel2, x, y, z);
        this.translate(this.rightAnimTrackModel3, x, y, z);
        this.translate(this.leftAnimTrackModel3, x, y, z);
        for (ModelRendererTurbo[] latm : this.leftAnimTrackModel) {
            this.translate(latm, x, y, z);
        }
        for (ModelRendererTurbo[] ratm : this.rightAnimTrackModel) {
            this.translate(ratm, x, y, z);
        }
        this.translate(this.doorAnimModel, x, y, z);
        this.translate(this.door2AnimModel, x, y, z);
        this.translate(this.drakonArmModel, x, y, z);
        this.translate(this.drakonRailModel, x, y, z);
        this.translate(this.drakonDoorModel, x, y, z);
        this.translate(this.drakonReloadModel, x, y, z);
        this.translate(this.drakonModel, x, y, z);
        this.translate(this.fancyTrackModel, x, y, z);
    }
}

