/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.tmt.ModelRendererTurbo;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.vector.Vector3f;
import org.lwjgl.opengl.GL11;

public class ModelMecha
extends ModelDriveable {
    public ModelRendererTurbo[] leftArmModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightArmModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftHandModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightHandModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] hipsModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightLegModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFootModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFootModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] headModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] barrelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimLegUpperModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimLegUpperModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimLegLowerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimLegLowerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimFootModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimFootModel = new ModelRendererTurbo[0];
    public Vector3f hipsAttachmentPoint = new Vector3f();
    public Vector3f legsOrigin = new Vector3f();
    public Vector3f leftLegUpperOrigin = new Vector3f();
    public Vector3f leftLegLowerOrigin = new Vector3f();
    public Vector3f rightLegUpperOrigin = new Vector3f();
    public Vector3f rightLegLowerOrigin = new Vector3f();
    public Vector3f rightFootOrigin = new Vector3f();
    public Vector3f leftFootOrigin = new Vector3f();

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityMecha)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        MechaType mechaType = (MechaType)type;
        this.renderPart(this.hipsModel);
        this.renderPart(this.leftLegModel);
        this.renderPart(this.rightLegModel);
        this.renderPart(this.leftFootModel);
        this.renderPart(this.rightFootModel);
        GL11.glPushMatrix();
        this.renderPart(this.leftAnimLegUpperModel);
        this.renderPart(this.rightAnimLegUpperModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.leftLegLowerOrigin.x, (float)this.leftLegLowerOrigin.y, (float)this.leftLegLowerOrigin.z);
        this.renderPart(this.leftAnimLegLowerModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.rightLegLowerOrigin.x, (float)this.rightLegLowerOrigin.y, (float)this.rightLegLowerOrigin.z);
        this.renderPart(this.rightAnimLegLowerModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.leftFootOrigin.x, (float)this.leftFootOrigin.y, (float)(-this.leftFootOrigin.z));
        this.renderPart(this.leftAnimFootModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.rightFootOrigin.x, (float)this.rightFootOrigin.y, (float)(-this.rightFootOrigin.z));
        this.renderPart(this.rightAnimFootModel);
        GL11.glPopMatrix();
        this.renderPart(this.barrelModel);
        this.renderPart(this.headModel);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(mechaType.leftArmOrigin.x / mechaType.modelScale), (float)(mechaType.leftArmOrigin.y / mechaType.modelScale), (float)(mechaType.leftArmOrigin.z / mechaType.modelScale));
        this.renderPart(this.leftArmModel);
        this.renderPart(this.leftHandModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(mechaType.rightArmOrigin.x / mechaType.modelScale), (float)(mechaType.rightArmOrigin.y / mechaType.modelScale), (float)(mechaType.rightArmOrigin.z / mechaType.modelScale));
        this.renderPart(this.rightArmModel);
        this.renderPart(this.rightHandModel);
        GL11.glPopMatrix();
    }

    public void render(float f5, EntityMecha mecha, float f) {
        if (mecha.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aBodyModel : this.bodyModel) {
                aBodyModel.func_78785_a(f5);
            }
        }
        if (mecha.isPartIntact(EnumDriveablePart.head)) {
            for (ModelRendererTurbo model : this.headModel) {
                model.func_78785_a(f5);
            }
        }
        float pitch = 0.0f;
        if (mecha.seats[0] != null && mecha.seats[0].looking != null) {
            pitch = mecha.seats[0].looking.getPitch();
        }
        if (mecha.isPartIntact(EnumDriveablePart.barrel)) {
            for (ModelRendererTurbo aBarrelModel : this.barrelModel) {
                aBarrelModel.field_78808_h = -(pitch * (float)Math.PI / 180.0f);
                aBarrelModel.render(f5, this.oldRotateOrder);
            }
        }
    }

    public void renderLeftArm(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftArmModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftHand(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftHandModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightArm(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightArmModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightHand(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightHandModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightFoot(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightFootModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftFoot(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftFootModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightLeg(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightLegModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightAnimLegUpper(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightAnimLegUpperModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightAnimLegLower(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightAnimLegLowerModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderRightAnimFoot(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.rightAnimFootModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftAnimLegUpper(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftAnimLegUpperModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftAnimLegLower(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftAnimLegLowerModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftAnimFoot(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftAnimFootModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderLeftLeg(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.leftLegModel) {
            model.func_78785_a(f5);
        }
    }

    public void renderHips(float f5, EntityMecha mecha, float f) {
        for (ModelRendererTurbo model : this.hipsModel) {
            model.func_78785_a(f5);
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.leftArmModel);
        this.flip(this.rightArmModel);
        this.flip(this.leftHandModel);
        this.flip(this.rightHandModel);
        this.flip(this.hipsModel);
        this.flip(this.leftLegModel);
        this.flip(this.rightLegModel);
        this.flip(this.leftAnimLegUpperModel);
        this.flip(this.rightAnimLegUpperModel);
        this.flip(this.leftAnimLegLowerModel);
        this.flip(this.rightAnimLegLowerModel);
        this.flip(this.leftAnimFootModel);
        this.flip(this.rightAnimFootModel);
        this.flip(this.leftFootModel);
        this.flip(this.rightFootModel);
        this.flip(this.headModel);
        this.flip(this.barrelModel);
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.leftArmModel, x, y, z);
        this.translate(this.rightArmModel, x, y, z);
        this.translate(this.leftHandModel, x, y, z);
        this.translate(this.rightHandModel, x, y, z);
        this.translate(this.hipsModel, x, y, z);
        this.translate(this.leftLegModel, x, y, z);
        this.translate(this.rightLegModel, x, y, z);
        this.translate(this.leftFootModel, x, y, z);
        this.translate(this.rightFootModel, x, y, z);
        this.translate(this.leftAnimLegUpperModel, x, y, z);
        this.translate(this.rightAnimLegUpperModel, x, y, z);
        this.translate(this.leftAnimLegLowerModel, x, y, z);
        this.translate(this.rightAnimLegLowerModel, x, y, z);
        this.translate(this.leftAnimFootModel, x, y, z);
        this.translate(this.rightAnimFootModel, x, y, z);
        this.translate(this.headModel, x, y, z);
        this.translate(this.barrelModel, x, y, z);
    }
}

