/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.coremod;

import alexiil.mods.load.ProgressDisplayer;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.launchwrapper.IClassTransformer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class BetterLoadingScreenTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (transformedName.equals("net.minecraft.client.Minecraft")) {
                return this.transformMinecraft(basicClass);
            }
            if (name.equals("com.mumfrey.liteloader.client.api.ObjectFactoryClient")) {
                return this.transformObjectFactoryClient(basicClass);
            }
            if (name.equals("lumien.resourceloader.ResourceLoader")) {
                return this.transformResourceLoader(basicClass);
            }
        }
        catch (Throwable t) {
            System.out.println("An issue occoured while transforming " + transformedName);
            t.printStackTrace();
        }
        return basicClass;
    }

    private byte[] transformObjectFactoryClient(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("preBeginGame")) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, "alexiil/mods/load/LiteLoaderProgress"));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "alexiil/mods/load/LiteLoaderProgress", "<init>", "()V", false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformMinecraft(byte[] before) {
        boolean hasFoundFMLClientHandler = false;
        boolean hasFoundGL11 = false;
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            MethodInsnNode method;
            AbstractInsnNode node;
            int i;
            if (hasFoundGL11) break;
            if (m.exceptions.size() == 1 && ((String)m.exceptions.get(0)).equals(Type.getInternalName(LWJGLException.class))) {
                for (i = 0; i < m.instructions.size(); ++i) {
                    if (hasFoundGL11 || !((node = m.instructions.get(i)) instanceof MethodInsnNode)) continue;
                    method = (MethodInsnNode)node;
                    if (!method.owner.equals(Type.getInternalName(GL11.class)) || !method.name.equals("glFlush")) continue;
                    hasFoundGL11 = true;
                    m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)new InsnNode(177));
                    break;
                }
            }
            for (i = 0; i < m.instructions.size(); ++i) {
                node = m.instructions.get(i);
                if (node instanceof MethodInsnNode) {
                    method = (MethodInsnNode)node;
                    if (method.owner.equals("com/mumfrey/liteloader/client/gui/startup/LoadingBar")) {
                        m.instructions.remove((AbstractInsnNode)method);
                        continue;
                    }
                }
                if (hasFoundFMLClientHandler || !(node instanceof MethodInsnNode)) continue;
                method = (MethodInsnNode)node;
                if (!method.owner.equals(Type.getInternalName(FMLClientHandler.class)) || !method.name.equals("instance")) continue;
                MethodInsnNode newOne = new MethodInsnNode(184, Type.getInternalName(ProgressDisplayer.class), "minecraftDisplayFirstProgress", "()V", false);
                m.instructions.insertBefore((AbstractInsnNode)method, (AbstractInsnNode)newOne);
                hasFoundFMLClientHandler = true;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        System.out.println("Transformed Minecraft");
        return cw.toByteArray();
    }

    private byte[] transformResourceLoader(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("preInit")) continue;
            m.visibleAnnotations.remove(0);
        }
        for (FieldNode f : classNode.fields) {
            if (!f.name.equals("INSTANCE")) continue;
            f.visibleAnnotations.remove(0);
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        byte[] arr = cw.toByteArray();
        System.out.println("Transformed ResourceLoader!");
        return arr;
    }
}

