/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.api.InterfaceObserver;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.Observer;
import com.mumfrey.liteloader.api.exceptions.InvalidProviderException;
import com.mumfrey.liteloader.api.manager.APIAdapter;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.interfaces.InterfaceRegistry;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LiteLoaderInterfaceManager
implements InterfaceRegistry {
    static int handlerAllocationOrder = 0;
    private final APIAdapter apiAdapter;
    private final Map<InterfaceProvider, LiteAPI> providerToAPIMap = new HashMap<InterfaceProvider, LiteAPI>();
    private final List<InterfaceProvider> allProviders = new ArrayList<InterfaceProvider>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<InterfaceHandler> interfaceHandlers = new ArrayList<InterfaceHandler>();
    protected final FastIterable<InterfaceObserver> observers = new HandlerList<InterfaceObserver>(InterfaceObserver.class);
    private boolean initDone = false;
    private boolean registrationDone = false;
    private InterfaceRegistrationDelegate activeRegistrationDelegate;

    LiteLoaderInterfaceManager(APIAdapter apiAdapter) {
        this.apiAdapter = apiAdapter;
    }

    void onPostInit() {
        this.registerQueuedListeners();
        this.initProviders();
    }

    void registerInterfaces() {
        this.apiAdapter.registerInterfaces(this);
    }

    @Override
    public void registerAPI(LiteAPI api) {
        List<? extends Observer> observers;
        List<InterfaceProvider> apiInterfaceProviders = api.getInterfaceProviders();
        if (apiInterfaceProviders != null) {
            for (InterfaceProvider provider : apiInterfaceProviders) {
                LiteLoaderLogger.info("Registering interface provider %s for API %s", provider.getClass().getName(), api.getName());
                if (!this.registerProvider(provider)) continue;
                this.providerToAPIMap.put(provider, api);
            }
        }
        if ((observers = this.apiAdapter.getObservers(api)) != null) {
            for (Observer observer : observers) {
                if (!(observer instanceof InterfaceObserver)) continue;
                this.registerObserver((InterfaceObserver)observer);
            }
        }
    }

    public boolean registerProvider(InterfaceProvider provider) {
        if (provider != null && !this.allProviders.contains(provider)) {
            try {
                InterfaceRegistrationDelegate delegate;
                if (this.activeRegistrationDelegate != null) {
                    throw new IllegalStateException("registerProvider() was called whilst a registration process was still active");
                }
                this.activeRegistrationDelegate = delegate = new InterfaceRegistrationDelegate(this, provider);
                this.activeRegistrationDelegate.registerInterfaces();
                this.activeRegistrationDelegate = null;
                if (this.initDone) {
                    provider.initProvider();
                }
                this.allProviders.add(provider);
                this.interfaceHandlers.addAll(delegate.getHandlers());
                return true;
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Error while registering interface provider %s: %s", provider.getClass().getSimpleName(), th.getClass().getSimpleName());
            }
        }
        this.activeRegistrationDelegate = null;
        return false;
    }

    public void registerObserver(InterfaceObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void registerInterface(InterfaceProvider provider, Class<? extends Listener> interfaceType) {
        this.registerInterface(provider, interfaceType, 0);
    }

    @Override
    public void registerInterface(InterfaceProvider provider, Class<? extends Listener> interfaceType, int priority) {
        this.registerInterface(provider, interfaceType, priority, false);
    }

    @Override
    public void registerInterface(InterfaceProvider provider, Class<? extends Listener> interfaceType, int priority, boolean exclusive) {
        InterfaceHandler handler = new InterfaceHandler(provider, interfaceType, exclusive, priority);
        if (handler.isValid()) {
            if (this.getProvidersFor(interfaceType).contains(provider)) {
                throw new InvalidProviderException("Attempting to register duplicate mapping for provider " + provider.getClass() + " to " + interfaceType);
            }
            if (exclusive) {
                this.removeHandlersFor(interfaceType, priority);
            }
            if (this.registrationDone) {
                this.interfaceHandlers.add(handler);
                for (Listener consumer : this.listeners) {
                    handler.registerListener(consumer);
                }
            } else if (this.activeRegistrationDelegate != null) {
                this.activeRegistrationDelegate.addHandler(handler);
            }
        } else {
            throw new InvalidProviderException("Provider " + provider.getClass() + " does not expose a registration method for " + interfaceType);
        }
    }

    public List<InterfaceProvider> getProvidersFor(Class<? extends Listener> interfaceType) {
        ArrayList<InterfaceProvider> handlers = new ArrayList<InterfaceProvider>();
        for (InterfaceHandler handler : this.interfaceHandlers) {
            if (handler.interfaceType != interfaceType) continue;
            handlers.add(handler.provider);
        }
        if (this.activeRegistrationDelegate != null) {
            for (InterfaceHandler handler : this.activeRegistrationDelegate.getHandlers()) {
                if (handler.interfaceType != interfaceType) continue;
                handlers.add(handler.provider);
            }
        }
        return handlers;
    }

    private void removeHandlersFor(Class<? extends Listener> interfaceType, int priority) {
        Iterator<InterfaceHandler> iter = this.interfaceHandlers.iterator();
        while (iter.hasNext()) {
            InterfaceHandler handler = iter.next();
            if (!handler.interfaceType.equals(interfaceType)) continue;
            if (handler.exclusive) {
                throw new RuntimeException("Attempt to register an exclusive handler when an exclusive handler already exists for " + interfaceType);
            }
            iter.remove();
        }
    }

    public LiteAPI getAPIForProvider(InterfaceProvider provider) {
        return this.providerToAPIMap.get(provider);
    }

    private void initProviders() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        for (InterfaceProvider provider : this.allProviders) {
            provider.initProvider();
        }
    }

    public void offer(Listener listener) {
        if (listener instanceof InterfaceProvider) {
            this.registerProvider((InterfaceProvider)((Object)listener));
        }
        this.listeners.add(listener);
        if (this.registrationDone) {
            this.registerListener(listener);
        }
    }

    private void registerQueuedListeners() {
        for (Listener consumer : this.listeners) {
            this.registerListener(consumer);
        }
        this.registrationDone = true;
    }

    public void registerListener(Listener listener) {
        for (InterfaceHandler handler : this.interfaceHandlers) {
            handler.registerListener(listener);
        }
    }

    class InterfaceHandler {
        public final int priority;
        public final int order;
        public final boolean exclusive;
        public final InterfaceProvider provider;
        public final Class<? extends Listener> interfaceType;
        private final List<Listener> registeredListeners = new ArrayList<Listener>();
        private final Method registrationMethod;

        public InterfaceHandler(InterfaceProvider provider, Class<? extends Listener> interfaceType, boolean exclusive, int priority) {
            this.provider = provider;
            this.interfaceType = interfaceType;
            this.exclusive = exclusive;
            this.priority = priority;
            this.order = handlerAllocationOrder++;
            this.registrationMethod = this.findRegistrationMethod(provider, interfaceType);
        }

        private Method findRegistrationMethod(InterfaceProvider provider, Class<? extends Listener> interfaceType) {
            Method registrationMethod = null;
            for (Class<?> providerClass = provider.getClass(); registrationMethod == null && providerClass != null; providerClass = providerClass.getSuperclass()) {
                registrationMethod = this.findRegistrationMethod(providerClass, interfaceType);
            }
            return registrationMethod;
        }

        private Method findRegistrationMethod(Class<? extends InterfaceProvider> providerClass, Class<? extends Listener> interfaceType) {
            for (Method method : providerClass.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(interfaceType)) continue;
                LiteLoaderLogger.debug("Found method %s for registering %s with provider %s", method.getName(), interfaceType, providerClass.getSimpleName());
                return method;
            }
            return null;
        }

        public boolean isValid() {
            return this.registrationMethod != null;
        }

        public boolean registerListener(Listener listener) {
            if (this.interfaceType.isAssignableFrom(listener.getClass()) && this.provider.getListenerBaseType().isAssignableFrom(listener.getClass())) {
                if (this.registeredListeners.contains(listener)) {
                    return false;
                }
                try {
                    LiteLoaderLogger.debug("Calling registration method %s for %s on %s with %s", this.registrationMethod.getName(), this.interfaceType.getSimpleName(), this.provider.getClass().getSimpleName(), listener.getClass().getSimpleName());
                    this.registrationMethod.invoke((Object)this.provider, listener);
                    this.registeredListeners.add(listener);
                    LiteLoaderInterfaceManager.this.observers.all().onRegisterListener(this.provider, this.interfaceType, listener);
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
    }
}

