/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.ChatRenderListener;
import com.mumfrey.liteloader.FrameBufferListener;
import com.mumfrey.liteloader.GameLoopListener;
import com.mumfrey.liteloader.HUDRenderListener;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.OutboundChatFilter;
import com.mumfrey.liteloader.OutboundChatListener;
import com.mumfrey.liteloader.PostRenderListener;
import com.mumfrey.liteloader.RenderListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.ViewportListener;
import com.mumfrey.liteloader.client.GameEngineClient;
import com.mumfrey.liteloader.client.overlays.IMinecraft;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.Events;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.transformers.event.EventInfo;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.lwjgl.input.Mouse;

public class ClientEvents
extends Events<bao, bsx> {
    private static ClientEvents instance;
    protected final GameEngineClient engineClient;
    private bbr minecraftTimer;
    private boolean lateInitDone;
    private bca currentResolution;
    private int screenWidth = 854;
    private int screenHeight = 480;
    private boolean wasFullScreen = false;
    private int worldHashCode = 0;
    private FastIterableDeque<Tickable> tickListeners = new HandlerList<Tickable>(Tickable.class);
    private FastIterableDeque<GameLoopListener> loopListeners = new HandlerList<GameLoopListener>(GameLoopListener.class);
    private FastIterableDeque<RenderListener> renderListeners = new HandlerList<RenderListener>(RenderListener.class);
    private FastIterableDeque<PostRenderListener> postRenderListeners = new HandlerList<PostRenderListener>(PostRenderListener.class);
    private FastIterableDeque<HUDRenderListener> hudRenderListeners = new HandlerList<HUDRenderListener>(HUDRenderListener.class);
    private FastIterableDeque<ChatRenderListener> chatRenderListeners = new HandlerList<ChatRenderListener>(ChatRenderListener.class);
    private FastIterableDeque<OutboundChatListener> outboundChatListeners = new HandlerList<OutboundChatListener>(OutboundChatListener.class);
    private FastIterableDeque<ViewportListener> viewportListeners = new HandlerList<ViewportListener>(ViewportListener.class);
    private FastIterableDeque<FrameBufferListener> frameBufferListeners = new HandlerList<FrameBufferListener>(FrameBufferListener.class);
    private FastIterableDeque<InitCompleteListener> initListeners = new HandlerList<InitCompleteListener>(InitCompleteListener.class);
    private FastIterableDeque<OutboundChatFilter> outboundChatFilters = new HandlerList<OutboundChatFilter>(OutboundChatFilter.class, HandlerList.ReturnLogicOp.AND);

    public ClientEvents(LiteLoader loader, GameEngineClient engine, LoaderProperties properties) {
        super(loader, engine, properties);
        instance = this;
        this.engineClient = engine;
    }

    static ClientEvents getInstance() {
        return instance;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        super.registerInterfaces(delegate);
        delegate.registerInterface(Tickable.class);
        delegate.registerInterface(GameLoopListener.class);
        delegate.registerInterface(RenderListener.class);
        delegate.registerInterface(PostRenderListener.class);
        delegate.registerInterface(HUDRenderListener.class);
        delegate.registerInterface(ChatRenderListener.class);
        delegate.registerInterface(OutboundChatListener.class);
        delegate.registerInterface(ViewportListener.class);
        delegate.registerInterface(FrameBufferListener.class);
        delegate.registerInterface(InitCompleteListener.class);
        delegate.registerInterface(OutboundChatFilter.class);
    }

    @Override
    public void initProvider() {
    }

    @Override
    @Deprecated
    public void addTickListener(Object tickListener) {
        if (tickListener instanceof Tickable) {
            this.addTickListener((Tickable)tickListener);
        }
    }

    public void addTickListener(Tickable tickable) {
        this.tickListeners.add(tickable);
    }

    public void addLoopListener(GameLoopListener loopListener) {
        this.loopListeners.add(loopListener);
    }

    public void addInitListener(InitCompleteListener initCompleteListener) {
        this.initListeners.add(initCompleteListener);
    }

    public void addRenderListener(RenderListener renderListener) {
        this.renderListeners.add(renderListener);
    }

    public void addPostRenderListener(PostRenderListener postRenderListener) {
        this.postRenderListeners.add(postRenderListener);
    }

    public void addChatRenderListener(ChatRenderListener chatRenderListener) {
        this.chatRenderListeners.add(chatRenderListener);
    }

    public void addHUDRenderListener(HUDRenderListener hudRenderListener) {
        this.hudRenderListeners.add(hudRenderListener);
    }

    public void addOutboundChatListener(OutboundChatListener outboundChatListener) {
        this.outboundChatListeners.add(outboundChatListener);
    }

    public void addOutboundChatFiler(OutboundChatFilter outboundChatFilter) {
        this.outboundChatFilters.add(outboundChatFilter);
    }

    public void addViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.add(viewportListener);
    }

    public void addFrameBufferListener(FrameBufferListener frameBufferListener) {
        this.frameBufferListeners.add(frameBufferListener);
    }

    @Override
    protected void onStartupComplete() {
        this.engine.refreshResources(false);
        if (!this.lateInitDone) {
            this.lateInitDone = true;
            for (InitCompleteListener initMod : this.initListeners) {
                try {
                    LoadingProgress.setMessage("Calling late init for mod %s...", initMod.getName());
                    LiteLoaderLogger.info("Calling late init for mod %s", initMod.getName());
                    initMod.onInitCompleted((bao)this.engine.getClient(), this.loader);
                }
                catch (Throwable th) {
                    this.mods.onLateInitFailed(initMod, th);
                    LiteLoaderLogger.warning(th, "Error calling late init for mod %s", initMod.getName());
                }
            }
        }
        this.onResize(this.engineClient.getClient());
        super.onStartupComplete();
    }

    public void onResize(bao minecraft) {
        this.currentResolution = this.engineClient.getScaledResolution();
        this.screenWidth = this.currentResolution.a();
        this.screenHeight = this.currentResolution.b();
        if (this.wasFullScreen != minecraft.L()) {
            ((ViewportListener)this.viewportListeners.all()).onFullScreenToggled(minecraft.L());
        }
        this.wasFullScreen = minecraft.L();
        ((ViewportListener)this.viewportListeners.all()).onViewportResized(this.currentResolution, minecraft.d, minecraft.e);
    }

    void onRender() {
        ((RenderListener)this.renderListeners.all()).onRender();
    }

    void postRenderEntities(float partialTicks2, long timeSlice) {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        ((PostRenderListener)this.postRenderListeners.all()).onPostRenderEntities(partialTicks);
    }

    void postRender(float partialTicks2, long timeSlice) {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        ((PostRenderListener)this.postRenderListeners.all()).onPostRender(partialTicks);
    }

    void preRenderGUI(float partialTicks) {
        ((RenderListener)this.renderListeners.all()).onRenderGui(this.engineClient.getCurrentScreen());
    }

    void onSetupCameraTransform(float partialTicks, long timeSlice) {
        ((RenderListener)this.renderListeners.all()).onSetupCameraTransform();
    }

    void onRenderChat(bcc chatGui, float partialTicks, boolean guiActive, int mouseX, int mouseY) {
        ((ChatRenderListener)this.chatRenderListeners.all()).onPreRenderChat(this.screenWidth, this.screenHeight, chatGui);
    }

    void postRenderChat(bcc chatGui, float partialTicks, boolean guiActive, int mouseX, int mouseY) {
        bcc chat = this.engineClient.getChatGUI();
        ((ChatRenderListener)this.chatRenderListeners.all()).onPostRenderChat(this.screenWidth, this.screenHeight, chat);
    }

    void onRenderHUD(float partialTicks) {
        ((HUDRenderListener)this.hudRenderListeners.all()).onPreRenderHUD(this.screenWidth, this.screenHeight);
    }

    void postRenderHUD(float partialTicks) {
        ((HUDRenderListener)this.hudRenderListeners.all()).onPostRenderHUD(this.screenWidth, this.screenHeight);
    }

    void onTimerUpdate() {
        bao minecraft = (bao)this.engine.getClient();
        ((GameLoopListener)this.loopListeners.all()).onRunGameLoop(minecraft);
    }

    void onTick(boolean clock) {
        this.profiler.a("litemods");
        float partialTicks = 0.0f;
        if (clock || this.minecraftTimer == null) {
            this.minecraftTimer = ((IMinecraft)this.engine.getClient()).getTimer();
        }
        if (this.minecraftTimer != null) {
            partialTicks = this.minecraftTimer.c;
            clock = this.minecraftTimer.b > 0;
        }
        bao minecraft = (bao)this.engine.getClient();
        boolean inGame = minecraft.i != null && minecraft.i.o != null;
        this.profiler.a("loader");
        super.onTick(clock, partialTicks, inGame);
        int mouseX = Mouse.getX() * this.screenWidth / minecraft.d;
        int mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / minecraft.e - 1;
        this.profiler.c("postrender");
        super.onPostRender(mouseX, mouseY, partialTicks);
        this.profiler.b();
        ((Tickable)this.tickListeners.all()).onTick(minecraft, partialTicks, inGame, clock);
        if (minecraft.f != null) {
            if (minecraft.f.hashCode() != this.worldHashCode) {
                this.worldHashCode = minecraft.f.hashCode();
                super.onWorldChanged((ahb)minecraft.f);
            }
        } else {
            this.worldHashCode = 0;
            super.onWorldChanged(null);
        }
        this.profiler.b();
    }

    void onSendChatMessage(ir packet, String message) {
        ((OutboundChatListener)this.outboundChatListeners.all()).onSendChatMessage(packet, message);
    }

    void onSendChatMessage(EventInfo<bjk> e, String message) {
        if (!((OutboundChatFilter)this.outboundChatFilters.all()).onSendChatMessage(message)) {
            e.cancel();
        }
    }

    void preRenderFBO(bmg framebuffer) {
        ((FrameBufferListener)this.frameBufferListeners.all()).preRenderFBO(framebuffer);
    }

    void onRenderFBO(bmg framebuffer, int width, int height) {
        ((FrameBufferListener)this.frameBufferListeners.all()).onRenderFBO(framebuffer, width, height);
    }

    void postRenderFBO(bmg framebuffer) {
        ((FrameBufferListener)this.frameBufferListeners.all()).postRenderFBO(framebuffer);
    }

    public void onRenderWorld(float partialTicks, long timeSlice) {
        ((RenderListener)this.renderListeners.all()).onRenderWorld();
    }
}

