/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;

public class ShootableType
extends InfoType {
    @SideOnly(value=Side.CLIENT)
    public ModelBase model;
    public boolean trailParticles = false;
    public String trailParticleType = "smoke";
    public int maxStackSize = 1;
    public String dropItemOnReload = null;
    public String dropItemOnShoot = null;
    public String dropItemOnHit = null;
    public int roundsPerItem = 1;
    public float fallSpeed = 1.0f;
    public float throwSpeed = 1.0f;
    public float hitBoxSize = 0.5f;
    public int damageVsLiving = 1;
    public int damageVsDriveable = 1;
    public boolean breaksGlass = false;
    public int fuse = 0;
    public int despawnTime = 0;
    public boolean explodeOnImpact = false;
    public float fireRadius = 0.0f;
    public float explosionRadius = 0.0f;
    public boolean explosionBreaksBlocks = false;
    public String dropItemOnDetonate = null;
    public String detonateSound = "";
    public static HashMap<String, ShootableType> shootables = new HashMap();

    public ShootableType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        shootables.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelBase.class);
            } else if (split[0].equals("Texture")) {
                this.texture = split[1];
            } else if (split[0].equals("StackSize") || split[0].equals("MaxStackSize")) {
                this.maxStackSize = Integer.parseInt(split[1]);
            } else if (split[0].equals("DropItemOnShoot")) {
                this.dropItemOnShoot = split[1];
            } else if (split[0].equals("DropItemOnReload")) {
                this.dropItemOnReload = split[1];
            } else if (split[0].equals("DropItemOnHit")) {
                this.dropItemOnHit = split[1];
            } else if (split[0].equals("RoundsPerItem")) {
                this.roundsPerItem = Integer.parseInt(split[1]);
            } else if (split[0].equals("FallSpeed")) {
                this.fallSpeed = Float.parseFloat(split[1]);
            } else if (split[0].equals("ThrowSpeed") || split[0].equals("ShootSpeed")) {
                this.throwSpeed = Float.parseFloat(split[1]);
            } else if (split[0].equals("HitBoxSize")) {
                this.hitBoxSize = Float.parseFloat(split[1]);
            } else if (split[0].equals("HitEntityDamage") || split[0].equals("DamageVsLiving") || split[0].equals("DamageVsPlayer")) {
                this.damageVsLiving = Integer.parseInt(split[1]);
            } else if (split[0].equals("DamageVsVehicles")) {
                this.damageVsDriveable = Integer.parseInt(split[1]);
            } else if (split[0].equals("BreaksGlass")) {
                this.breaksGlass = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("Fuse")) {
                this.fuse = Integer.parseInt(split[1]);
            } else if (split[0].equals("DespawnTime")) {
                this.despawnTime = Integer.parseInt(split[1]);
            } else if (split[0].equals("ExplodeOnImpact") || split[0].equals("DetonateOnImpact")) {
                this.explodeOnImpact = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("FireRadius") || split[0].equals("Fire")) {
                this.fireRadius = Float.parseFloat(split[1]);
            } else if (split[0].equals("ExplosionRadius") || split[0].equals("Explosion")) {
                this.explosionRadius = Float.parseFloat(split[1]);
            } else if (split[0].equals("ExplosionBreaksBlocks")) {
                this.explosionBreaksBlocks = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("DropItemOnDetonate")) {
                this.dropItemOnDetonate = split[1];
            } else if (split[0].equals("DetonateSound")) {
                this.detonateSound = split[1];
            } else if (split[0].equals("TrailParticles") || split[0].equals("SmokeTrail")) {
                this.trailParticles = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("TrailParticleType")) {
                this.trailParticleType = split[1];
            }
        }
        catch (Exception e) {
            System.out.println("Reading grenade file failed.");
            e.printStackTrace();
        }
    }

    public static ShootableType getShootableType(String string) {
        return shootables.get(string);
    }
}

