/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.potion.PotionEffect;

public class GrenadeType
extends ShootableType {
    public static ArrayList<GrenadeType> grenades = new ArrayList();
    public int meleeDamage = 1;
    public int throwDelay = 0;
    public String throwSound = "";
    public String dropItemOnThrow = null;
    public boolean canThrow = true;
    public float bounciness = 0.9f;
    public boolean penetratesEntities = false;
    public boolean penetratesBlocks = false;
    public String bounceSound = "";
    public boolean sticky = false;
    public boolean stickToThrower = false;
    public float livingProximityTrigger = -1.0f;
    public float driveableProximityTrigger = -1.0f;
    public boolean detonateWhenShot = false;
    public boolean remote = false;
    public float damageToTriggerer = 0.0f;
    public float explosionDamageVsLiving = 0.0f;
    public float explosionDamageVsDriveable = 0.0f;
    public int primeDelay = 0;
    public int explodeParticles = 0;
    public String explodeParticleType = "largesmoke";
    public boolean spinWhenThrown = true;
    public int smokeTime = 0;
    public String smokeParticleType = "explode";
    public ArrayList<PotionEffect> smokeEffects = new ArrayList();
    public float smokeRadius = 5.0f;
    public boolean isDeployableBag = false;
    public int numUses = 1;
    public float healAmount = 0.0f;
    public ArrayList<PotionEffect> potionEffects = new ArrayList();
    public int numClips = 0;

    public GrenadeType(TypeFile file) {
        super(file);
        grenades.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("MeleeDamage")) {
                this.meleeDamage = Integer.parseInt(split[1]);
            } else if (split[0].equals("ThrowDelay")) {
                this.throwDelay = Integer.parseInt(split[1]);
            } else if (split[0].equals("ThrowSound")) {
                this.throwSound = split[1];
            } else if (split[0].equals("DropItemOnThrow")) {
                this.dropItemOnThrow = split[1];
            } else if (split[0].equals("CanThrow")) {
                this.canThrow = Boolean.parseBoolean(split[1]);
            } else if (split[0].equals("Bounciness")) {
                this.bounciness = Float.parseFloat(split[1]);
            } else if (split[0].equals("PenetratesEntities")) {
                this.penetratesEntities = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("PenetratesBlocks")) {
                this.penetratesBlocks = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("BounceSound")) {
                this.bounceSound = split[1];
            } else if (split[0].equals("Sticky")) {
                this.sticky = Boolean.parseBoolean(split[1]);
            } else if (split[0].equals("LivingProximityTrigger")) {
                this.livingProximityTrigger = Float.parseFloat(split[1]);
            } else if (split[0].equals("VehicleProximityTrigger")) {
                this.driveableProximityTrigger = Float.parseFloat(split[1]);
            } else if (split[0].equals("DamageToTriggerer")) {
                this.damageToTriggerer = Float.parseFloat(split[1]);
            } else if (split[0].equals("DetonateWhenShot")) {
                this.detonateWhenShot = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("PrimeDelay") || split[0].equals("TriggerDelay")) {
                this.primeDelay = Integer.parseInt(split[1]);
            } else if (split[0].equals("StickToThrower")) {
                this.stickToThrower = Boolean.parseBoolean(split[1]);
            } else if (split[0].equals("ExplosionDamageVsLiving")) {
                this.explosionDamageVsLiving = Float.parseFloat(split[1]);
            } else if (split[0].equals("ExplosionDamageVsDrivable")) {
                this.explosionDamageVsDriveable = Float.parseFloat(split[1]);
            } else if (split[0].equals("NumExplodeParticles")) {
                this.explodeParticles = Integer.parseInt(split[1]);
            } else if (split[0].equals("ExplodeParticles")) {
                this.explodeParticleType = split[1];
            } else if (split[0].equals("SmokeTime")) {
                this.smokeTime = Integer.parseInt(split[1]);
            } else if (split[0].equals("SmokeParticles")) {
                this.smokeParticleType = split[1];
            } else if (split[0].equals("SmokeEffect")) {
                this.smokeEffects.add(GrenadeType.getPotionEffect(split));
            } else if (split[0].equals("SmokeRadius")) {
                this.smokeRadius = Float.parseFloat(split[1]);
            } else if (split[0].equals("SpinWhenThrown")) {
                this.spinWhenThrown = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("Remote")) {
                this.remote = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("DeployableBag")) {
                this.isDeployableBag = true;
            } else if (split[0].equals("NumUses")) {
                this.numUses = Integer.parseInt(split[1]);
            } else if (split[0].equals("HealAmount")) {
                this.healAmount = Float.parseFloat(split[1]);
            } else if (split[0].equals("AddPotionEffect") || split[0].equals("PotionEffect")) {
                this.potionEffects.add(GrenadeType.getPotionEffect(split));
            } else if (split[0].equals("NumClips")) {
                this.numClips = Integer.parseInt(split[1]);
            }
        }
        catch (Exception e) {
            System.out.println("Reading grenade file failed.");
            e.printStackTrace();
        }
    }

    public static GrenadeType getGrenade(String s) {
        for (GrenadeType grenade : grenades) {
            if (!grenade.shortName.equals(s)) continue;
            return grenade;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
    }
}

