/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.api.IInfoType;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public abstract class InfoType
implements IInfoType {
    public static List<InfoType> infoTypes = new ArrayList<InfoType>();
    public String contentPack;
    public Item item;
    public int colour = 0xFFFFFF;
    public String iconPath;
    public Object[] recipe;
    public String[] recipeLine;
    public int recipeOutput = 1;
    public boolean shapeless;
    public String smeltableFrom = null;
    public String name;
    public String shortName;
    public String texture;
    public String modelString;
    public String description;
    public float modelScale = 1.0f;
    public boolean canDrop = true;
    public final String packName;

    public InfoType(TypeFile file) {
        this.contentPack = file.name;
        this.packName = file.pack;
        infoTypes.add(this);
    }

    public void read(TypeFile file) {
        String line;
        this.preRead(file);
        while ((line = file.readLine()) != null) {
            String[] split;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2) continue;
            this.read(split, file);
        }
        this.postRead(file);
        if (this.shortName == null) {
            infoTypes.remove(this);
        }
    }

    protected abstract void preRead(TypeFile var1);

    protected abstract void postRead(TypeFile var1);

    protected void read(String[] split, TypeFile file) {
        try {
            if (split[0].equals("Model")) {
                this.modelString = split[1];
            } else if (split[0].equals("ModelScale")) {
                this.modelScale = Float.parseFloat(split[1]);
            } else if (split[0].equals("Name")) {
                this.name = split[1];
                for (int i = 0; i < split.length - 2; ++i) {
                    this.name = this.name + " " + split[i + 2];
                }
            } else if (split[0].equals("Description")) {
                this.description = split[1];
                for (int i = 0; i < split.length - 2; ++i) {
                    this.description = this.description + " " + split[i + 2];
                }
            } else if (split[0].equals("ShortName")) {
                this.shortName = split[1];
                if (this.iconPath == null || this.iconPath.isEmpty()) {
                    this.iconPath = "Missing-Icon-" + this.shortName;
                }
            } else if (split[0].equals("Colour") || split[0].equals("Color")) {
                this.colour = (Integer.parseInt(split[1]) << 16) + (Integer.parseInt(split[2]) << 8) + Integer.parseInt(split[3]);
            } else if (split[0].equals("Icon")) {
                this.iconPath = split[1];
            } else if (split[0].equals("RecipeOutput")) {
                this.recipeOutput = Integer.parseInt(split[1]);
            } else if (split[0].equals("Recipe")) {
                this.recipe = new Object[split.length + 2];
                for (int i = 0; i < 3; ++i) {
                    String line = file.readLine();
                    if (line == null) continue;
                    if (line.startsWith("//")) {
                        --i;
                        continue;
                    }
                    this.recipe[i] = line;
                }
                this.recipeLine = split;
                this.shapeless = false;
            } else if (split[0].equals("ShapelessRecipe")) {
                this.recipeLine = split;
                this.shapeless = true;
            } else if (split[0].equals("SmeltableFrom")) {
                this.smeltableFrom = split[1];
            } else if (split[0].equals("CanDrop")) {
                this.canDrop = Boolean.parseBoolean(split[1]);
            }
        }
        catch (Exception e) {
            FlansMod.log("Reading file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    public void addRecipe() {
        this.addRecipe(this.getItem());
    }

    public void addRecipe(Item par1Item) {
        block20: {
            if (this.smeltableFrom != null) {
                GameRegistry.addSmelting((ItemStack)InfoType.getRecipeElement(this.smeltableFrom, 0), (ItemStack)new ItemStack(this.item), (float)0.0f);
            }
            if (this.recipeLine == null) {
                return;
            }
            try {
                if (!this.shapeless) {
                    Object[] newRecipe1;
                    int last;
                    int rows = 3;
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                        if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(1);
                            }
                        }
                    }
                    if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                        }
                        if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                            }
                        }
                    }
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[1];
                        newRecipe[1] = this.recipe[2];
                        this.recipe = newRecipe;
                        --rows;
                        if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[1];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[0];
                        newRecipe[1] = this.recipe[1];
                        this.recipe = newRecipe;
                        if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[0];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                        this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                        this.recipe[i * 2 + rows + 1] = this.recipeLine[i * 2 + 2].contains(".") ? InfoType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.parseInt(this.recipeLine[i * 2 + 2].split("\\.")[1])) : InfoType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                    }
                    GameRegistry.addRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
                } else {
                    this.recipe = new Object[this.recipeLine.length - 1];
                    for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                        this.recipe[i] = this.recipeLine[i + 1].contains(".") ? InfoType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.parseInt(this.recipeLine[i + 1].split("\\.")[1])) : InfoType.getRecipeElement(this.recipeLine[i + 1], 0);
                    }
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
                }
            }
            catch (Exception e) {
                FlansMod.log("Failed to add recipe for : " + this.shortName);
                if (!FlansMod.printStackTrace) break block20;
                e.printStackTrace();
            }
        }
    }

    public static ItemStack getRecipeElement(String s, int damage) {
        return InfoType.getRecipeElement(s, 1, damage);
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage) {
        return InfoType.getRecipeElement(s, amount, damage, "nothing");
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage, String requester) {
        if (s.equals("doorIron")) {
            return new ItemStack(Items.field_151139_aw, amount);
        }
        if (s.equals("doorWood")) {
            return new ItemStack(Items.field_151135_aq, amount);
        }
        if (s.equals("clayItem")) {
            return new ItemStack(Items.field_151119_aD, amount);
        }
        for (Object object : Item.field_150901_e) {
            Item item = (Item)object;
            if (item == null || item.func_77658_a() == null || !item.func_77658_a().equals("item." + s) && !item.func_77658_a().equals("tile." + s)) continue;
            return new ItemStack(item, amount, damage);
        }
        for (InfoType type : infoTypes) {
            if (!type.shortName.equals(s)) continue;
            return new ItemStack(type.item, amount, damage);
        }
        if (s.equals("gunpowder")) {
            return new ItemStack(Items.field_151016_H, amount);
        }
        if (s.equals("iron")) {
            return new ItemStack(Items.field_151042_j, amount);
        }
        FlansMod.log("Could not find " + s + " when adding recipe for " + requester);
        return null;
    }

    protected int getDyeDamageValue(String dyeName) {
        int damage = -1;
        for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
            if (!ItemDye.field_150923_a[i].equals(dyeName)) continue;
            damage = i;
        }
        if (damage == -1) {
            FlansMod.log("Failed to find dye colour : " + dyeName + " while adding " + this.contentPack);
        }
        return damage;
    }

    public void reloadModel() {
    }

    public static InfoType getType(String s) {
        for (InfoType type : infoTypes) {
            if (!type.shortName.equals(s)) continue;
            return type;
        }
        return null;
    }

    public void onWorldLoad(World world) {
    }

    public abstract float GetRecommendedScale();

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBase GetModel();

    public static InfoType getType(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFlanItem) {
            return ((IFlanItem)item).getInfoType();
        }
        return null;
    }

    public static PotionEffect getPotionEffect(String[] split) {
        int potionID = Integer.parseInt(split[1]);
        int duration = Integer.parseInt(split[2]);
        int amplifier = Integer.parseInt(split[3]);
        return new PotionEffect(potionID, duration, amplifier, false);
    }

    public static Material getMaterial(String material) {
        return Material.field_151578_c;
    }

    @Override
    public String getContentPack() {
        return this.contentPack;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

