/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.gui.GuiTeamSelect;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.PlayerClass;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketSendPlayerClasses
extends PacketBase {
    public PlayerClass[] classes;
    public int playerLvl;

    public PacketSendPlayerClasses() {
    }

    public PacketSendPlayerClasses(PlayerClass[] classes) {
        this.classes = classes;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.playerLvl);
        data.writeByte(this.classes.length);
        for (PlayerClass playerClass : this.classes) {
            this.writeUTF(data, playerClass.shortName);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.playerLvl = data.readInt();
        int numClasses = data.readByte();
        this.classes = new PlayerClass[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            this.classes[i] = PlayerClass.getClass(this.readUTF(data));
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeamSelect(this.classes, this.playerLvl));
    }
}

