/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.network.PacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;

public class PacketSeatCheck
extends PacketBase {
    public int entityId;
    public int checkCount;

    public PacketSeatCheck() {
    }

    public PacketSeatCheck(EntitySeat seat) {
        this.entityId = seat.func_145782_y();
        this.checkCount = 3;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.entityId);
        data.writeInt(this.checkCount);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.entityId = data.readInt();
        this.checkCount = data.readInt();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        this.log("handleServerSide", (EntityPlayer)playerEntity);
        if (this.checkCount <= 0) {
            ChatComponentText cct1 = new ChatComponentText("[FlansMod] " + playerEntity.getDisplayName() + " was recovering from a fall. id=" + this.entityId);
            cct1.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            ChatComponentText cct2 = new ChatComponentText("[FlansMod]================================================");
            cct2.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        } else {
            this.entityId = playerEntity.field_70154_o instanceof EntitySeat ? playerEntity.field_70154_o.func_145782_y() : -1;
            FlansMod.getPacketHandler().sendTo(this, playerEntity);
        }
    }

    private void log(String s, EntityPlayer player) {
        Entity re = player.field_70154_o;
        FlansMod.log(s + " :" + player.getDisplayName() + " : rideEntity=" + (re != null ? re.getClass().getName() : re) + " : seatEntityId=" + this.entityId + " : check=" + this.checkCount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        if (clientPlayer.field_70154_o == null && this.entityId != -1) {
            if (this.checkCount > 1) {
                --this.checkCount;
            } else {
                --this.checkCount;
                Entity entity = clientPlayer.field_70170_p.func_73045_a(this.entityId);
                if (entity instanceof EntitySeat) {
                    clientPlayer.func_70078_a(entity);
                }
            }
            FlansMod.getPacketHandler().sendToServer(this);
        }
    }
}

