/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.sync.Sync;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PacketHashSend
extends PacketBase {
    String hash;

    public PacketHashSend() {
    }

    public PacketHashSend(String typeHash) {
        this.hash = typeHash;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.writeUTF(data, this.hash);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.hash = this.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        FlansMod.log("Received pack hash from %s (%s)", player.func_70005_c_(), this.hash);
        if (!this.hash.equals(Sync.cachedHash) && FlansMod.kickNonMatchingHashes) {
            player.field_71135_a.func_147360_c("[Sync] Client-server mismatch.");
        }
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        if (FlansMod.printDebugLog) {
            FlansMod.log("Received packet %s", this.hash);
        }
        if (!this.hash.equals(Sync.cachedHash) && FlansMod.kickNonMatchingHashes) {
            clientPlayer.func_146105_b((IChatComponent)new ChatComponentText("[Sync] Client-Server mismatch detected."));
            FlansMod.log("Kicked from server, invalid hash. Make sure your packs are the same as the server's.");
            FlansMod.log("S: " + this.hash);
            FlansMod.log("C: " + Sync.cachedHash);
        }
        FlansMod.getPacketHandler().sendToServer(new PacketHashSend(Sync.getUnifiedHash()));
    }
}

