/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.api.IEntityBullet;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.FlansModExplosion;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.BlockHit;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.guns.raytracing.EntityHit;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import com.flansmod.common.guns.raytracing.PlayerHitbox;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.network.PacketFlak;
import com.flansmod.common.network.PacketHitMarker;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBullet
extends EntityShootable
implements IEntityAdditionalSpawnData,
IEntityBullet {
    private static int bulletLife = 600;
    public Entity owner;
    private int ticksInAir = 0;
    public BulletType type;
    public InfoType firedFrom;
    public float damage;
    public boolean shotgun = false;
    public int pingOfShooter = 0;
    public boolean detonated = false;
    public Entity lockedOnTo;
    public double prevDistanceToEntity = 0.0;
    public boolean toggleLock = false;
    public double thisSpeed = 0.0;
    public int closeCount = 0;
    public int soundTime = 0;
    public float speedA;
    public int impactX;
    public int impactY;
    public int impactZ;
    public boolean isFirstPositionSetting = false;
    public boolean isPositionUpper = true;
    public boolean lastHitHeadshot = false;
    public float lastHitPenAmount = 1.0f;
    public float penetratingPower;
    public int submunitionDelay = 20;
    public boolean hasSetSubDelay = false;
    public boolean hasSetVLSDelay = false;
    public int VLSDelay = 0;
    public Vector3f lookVector;
    public Vector3f initialPos;
    public boolean hasSetLook = false;

    @Override
    public ShootableType getType() {
        return this.type;
    }

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    private EntityBullet(World world, EntityLivingBase shooter, float gunDamage, BulletType bulletType, InfoType shotFrom) {
        this(world);
        this.owner = shooter;
        if (shooter instanceof EntityPlayerMP) {
            this.pingOfShooter = ((EntityPlayerMP)shooter).field_71138_i;
        }
        this.type = bulletType;
        this.firedFrom = shotFrom;
        this.damage = gunDamage;
        this.penetratingPower = this.type.penetratingPower;
        this.func_70105_a(bulletType.hitBoxSize, bulletType.hitBoxSize);
    }

    public EntityBullet(World world, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, boolean shot, InfoType shotFrom) {
        this(world, Vec3.func_72443_a((double)shooter.field_70165_t, (double)(shooter.field_70163_u + (double)shooter.func_70047_e()), (double)shooter.field_70161_v), shooter.field_70177_z, shooter.field_70125_A, shooter, spread, gunDamage, type1, speed, shotFrom);
        this.shotgun = shot;
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, InfoType shotFrom) {
        this(world, origin, yaw, pitch, shooter, spread, gunDamage, type1, 3.0f, shotFrom);
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread / 2.0f, speed);
    }

    public EntityBullet(World world, Vector3f origin, Vector3f direction, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.damage = gunDamage;
        this.func_70107_b(origin.x, origin.y, origin.z);
        this.field_70159_w = direction.x;
        this.field_70181_x = direction.y;
        this.field_70179_y = direction.z;
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread, speed);
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, double motX, double motY, double motZ, EntityLivingBase shooter, float gunDamage, BulletType type1, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
    }

    protected void func_70088_a() {
    }

    public void setArrowHeading(double d, double d1, double d2, float spread, float speed) {
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d *= (double)speed;
        d1 *= (double)speed;
        d2 *= (double)speed;
        this.field_70159_w = d += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70181_x = d1 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70179_y = d2 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.getLockOnTarget();
    }

    private void getLockOnTarget() {
        if (this.type.lockOnToPlanes || this.type.lockOnToVehicles || this.type.lockOnToMechas || this.type.lockOnToLivings || this.type.lockOnToPlayers) {
            Vector3f motionVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Entity closestEntity = null;
            float closestAngle = this.type.maxLockOnAngle * (float)Math.PI / 180.0f;
            for (Object obj : this.field_70170_p.field_72996_f) {
                Vector3f relPosVec;
                float angle;
                Entity entity = (Entity)obj;
                String etype = entity.getEntityData().func_74779_i("EntityType");
                if (!(this.type.lockOnToMechas && entity instanceof EntityMecha || this.type.lockOnToVehicles && entity instanceof EntityVehicle || this.type.lockOnToVehicles && etype.equals("Vehicle") || this.type.lockOnToPlanes && entity instanceof EntityPlane || this.type.lockOnToPlanes && etype.equals("Plane") || this.type.lockOnToPlayers && entity instanceof EntityPlayer) && (!this.type.lockOnToLivings || !(entity instanceof EntityLivingBase)) || !((angle = Math.abs(Vector3f.angle(motionVec, relPosVec = new Vector3f(entity.field_70165_t - this.field_70165_t, entity.field_70163_u - this.field_70163_u, entity.field_70161_v - this.field_70161_v)))) < closestAngle)) continue;
                closestEntity = entity;
                closestAngle = angle;
            }
            if (closestEntity != null) {
                this.lockedOnTo = closestEntity;
            }
        }
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void func_70071_h_() {
        float speed;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.owner instanceof EntityPlayerMP) {
            this.pingOfShooter = ((EntityPlayerMP)this.owner).field_71138_i;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.type == null) {
            FlansMod.log("EntityBullet.onUpdate() Error: BulletType is null (" + this + ")");
            this.func_70106_y();
            return;
        }
        if (this.type.despawnTime > 0 && this.field_70173_aa > this.type.despawnTime) {
            this.detonated = true;
            this.func_70106_y();
            return;
        }
        if (!this.hasSetSubDelay && this.type.hasSubmunitions) {
            this.setSubmunitionDelay();
        } else if (this.type.hasSubmunitions) {
            --this.submunitionDelay;
        }
        if (!this.hasSetVLSDelay && this.type.VLS) {
            this.VLSDelay = this.type.VLSTime;
            this.hasSetVLSDelay = true;
        }
        if (this.VLSDelay > 0) {
            --this.VLSDelay;
        }
        if (!this.hasSetLook && this.owner != null) {
            this.lookVector = new Vector3f((float)this.owner.func_70040_Z().field_72450_a, (float)this.owner.func_70040_Z().field_72448_b, (float)this.owner.func_70040_Z().field_72449_c);
            this.initialPos = new Vector3f(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
            this.hasSetLook = true;
        }
        if (this.soundTime > 0) {
            --this.soundTime;
        }
        if (this.owner != null) {
            double rangeX = this.owner.field_70165_t - this.field_70165_t;
            double rangeY = this.owner.field_70163_u - this.field_70163_u;
            double rangeZ = this.owner.field_70161_v - this.field_70161_v;
            double range = Math.sqrt(rangeX * rangeX + rangeY * rangeY + rangeZ * rangeZ);
            if (this.type.maxRange != -1 && (double)this.type.maxRange < range) {
                if (this.field_70173_aa > this.type.fuse && this.type.fuse > 0) {
                    this.detonate();
                }
                this.func_70106_y();
            }
        } else {
            this.func_70106_y();
        }
        ++this.ticksInAir;
        if (this.ticksInAir > this.type.fuse && this.type.fuse > 0 && !this.field_70128_L) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > bulletLife) {
            this.func_70106_y();
        }
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > this.type.fuse && this.type.fuse > 0) {
                this.detonate();
            }
            if (this.type.livingProximityTrigger > 0.0f || this.type.driveableProximityTrigger > 0.0f) {
                float checkRadius = Math.max(this.type.livingProximityTrigger, this.type.driveableProximityTrigger);
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)checkRadius, (double)checkRadius, (double)checkRadius));
                for (Object obj : list) {
                    if (obj == this.owner && this.field_70173_aa < 10) continue;
                    if (obj instanceof EntityLivingBase && this.func_70032_d((Entity)obj) < this.type.livingProximityTrigger) {
                        if (TeamsManager.getInstance() != null && TeamsManager.getInstance().currentRound != null && obj instanceof EntityPlayerMP && this.owner instanceof EntityPlayer && !TeamsManager.getInstance().currentRound.gametype.playerAttacked((EntityPlayerMP)obj, (DamageSource)new EntityDamageSourceFlans(this.type.shortName, this, (EntityPlayer)this.owner, this.type, false, false))) continue;
                        if (this.type.damageToTriggerer > 0.0f) {
                            ((EntityLivingBase)obj).func_70097_a(this.getBulletDamage(false), this.type.damageToTriggerer);
                        }
                        FlansMod.proxy.spawnParticle("redstone", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                        this.detonate();
                        break;
                    }
                    if (!(obj instanceof EntityDriveable) || !(this.func_70032_d((Entity)obj) < this.type.driveableProximityTrigger)) continue;
                    if (this.type.damageToTriggerer > 0.0f) {
                        ((EntityDriveable)obj).func_70097_a(this.getBulletDamage(false), this.type.damageToTriggerer);
                    }
                    this.detonate();
                    break;
                }
            }
        }
        ArrayList<Object> hits = new ArrayList<Object>();
        Vector3f origin = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3f motion = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float hitBoxSize = this.type.hitBoxSize >= 0.0f ? this.type.hitBoxSize : 0.0f;
        this.speedA = speed = motion.length();
        if (this.type.hasSubmunitions && this.submunitionDelay < 0) {
            this.DeploySubmunitions();
            this.submunitionDelay = 9001;
        }
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            AxisAlignedBB bb;
            MovingObjectPosition mop;
            Object obj = this.field_70170_p.field_72996_f.get(i);
            if (obj instanceof EntityDriveable) {
                EntityDriveable driveable = (EntityDriveable)obj;
                if (driveable.isDead() || driveable.isPartOfThis(this.owner) || !(this.func_70032_d(driveable) <= driveable.getDriveableType().bulletDetectionRadius + speed)) continue;
                ArrayList<BulletHit> driveableHits = driveable.attackFromBullet(origin, motion);
                hits.addAll(driveableHits);
                continue;
            }
            if (obj instanceof EntityPlayer) {
                MovingObjectPosition mop2;
                EntityPlayer player = (EntityPlayer)obj;
                PlayerData data = PlayerHandler.getPlayerData(player);
                boolean shouldDoNormalHitDetect = false;
                if (data != null) {
                    PlayerSnapshot snapshot;
                    if (player.field_70128_L || data.team == Team.spectators || player == this.owner && this.ticksInAir < 20) continue;
                    int snapshotToTry = TeamsManager.bulletSnapshotMin;
                    float snapshotPortion = (float)this.pingOfShooter / (float)TeamsManager.bulletSnapshotDivisor;
                    if (TeamsManager.bulletSnapshotDivisor > 0) {
                        snapshotToTry = (int)((float)snapshotToTry + snapshotPortion);
                    }
                    if (snapshotToTry >= data.snapshots.length) {
                        snapshotToTry = data.snapshots.length - 1;
                    }
                    if ((snapshot = data.snapshots[snapshotToTry] != null ? data.snapshots[snapshotToTry] : data.snapshots[0]) == null) {
                        shouldDoNormalHitDetect = true;
                    } else {
                        boolean snapshotBeforeExists = snapshotToTry != 0 && data.snapshots[snapshotToTry - 1] != null;
                        boolean snapshotAfterExists = snapshotToTry + 1 < data.snapshots.length && data.snapshots[snapshotToTry + 1] != null;
                        float bias = 0.25f;
                        float offset = snapshotPortion + bias;
                        float lb = offset - 0.5f;
                        float ub = offset + 0.5f;
                        ArrayList<Object> onStepHits = new ArrayList();
                        ArrayList<Object> altStepHits = new ArrayList();
                        if ((double)offset > 0.5 && snapshotAfterExists) {
                            onStepHits = snapshot.raytrace(origin, motion, lb, 1.0f);
                            if (onStepHits.isEmpty()) {
                                altStepHits = data.snapshots[snapshotToTry + 1].raytrace(origin, motion, 0.0f, lb);
                            }
                        } else if ((double)offset < 0.5 && snapshotBeforeExists) {
                            onStepHits = snapshot.raytrace(origin, motion, 0.0f, ub);
                            if (onStepHits.isEmpty()) {
                                altStepHits = data.snapshots[snapshotToTry - 1].raytrace(origin, motion, ub, 1.0f);
                            }
                        } else {
                            onStepHits = snapshot.raytrace(origin, motion, 0.0f, 1.0f);
                        }
                        hits.addAll(onStepHits);
                        hits.addAll(altStepHits);
                    }
                }
                if (data != null && !shouldDoNormalHitDetect || (mop2 = player.field_70121_D.func_72314_b((double)hitBoxSize, (double)hitBoxSize, (double)hitBoxSize).func_72327_a(origin.toVec3(), Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y)))) == null) continue;
                Vector3f hitPoint = new Vector3f(mop2.field_72307_f.field_72450_a - this.field_70165_t, mop2.field_72307_f.field_72448_b - this.field_70163_u, mop2.field_72307_f.field_72449_c - this.field_70161_v);
                float hitLambda = 1.0f;
                if (motion.x != 0.0f) {
                    hitLambda = hitPoint.x / motion.x;
                } else if (motion.y != 0.0f) {
                    hitLambda = hitPoint.y / motion.y;
                } else if (motion.z != 0.0f) {
                    hitLambda = hitPoint.z / motion.z;
                }
                if (hitLambda < 0.0f) {
                    hitLambda = -hitLambda;
                }
                hits.add(new PlayerBulletHit(new PlayerHitbox(player, new RotatedAxes(), new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f(), EnumHitboxType.BODY), hitLambda));
                continue;
            }
            Entity entity = (Entity)obj;
            if (entity == this || entity == this.owner || entity.field_70128_L || entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity.getClass().toString().contains("flansmod.") && !(entity instanceof EntityAAGun) && !(entity instanceof EntityGrenade) || entity.getClass().toString().contains("holographicdisplays") || (mop = (bb = entity.field_70121_D.func_72321_a(-(entity.field_70165_t - entity.field_70169_q) * 2.0, -(entity.field_70163_u - entity.field_70167_r) * 2.0, -(entity.field_70161_v - entity.field_70166_s) * 2.0)).func_72314_b((double)hitBoxSize, (double)hitBoxSize, (double)hitBoxSize).func_72327_a(origin.toVec3(), Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y)))) == null) continue;
            Vector3f hitPoint = new Vector3f(mop.field_72307_f.field_72450_a - this.field_70165_t, mop.field_72307_f.field_72448_b - this.field_70163_u, mop.field_72307_f.field_72449_c - this.field_70161_v);
            float hitLambda = 1.0f;
            if (motion.x != 0.0f) {
                hitLambda = hitPoint.x / motion.x;
            } else if (motion.y != 0.0f) {
                hitLambda = hitPoint.y / motion.y;
            } else if (motion.z != 0.0f) {
                hitLambda = hitPoint.z / motion.z;
            }
            if (hitLambda < 0.0f) {
                hitLambda = -hitLambda;
            }
            hits.add(new EntityHit(entity, hitLambda));
        }
        Vec3 posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 nextPosVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition hit = this.field_70170_p.func_147447_a(posVec, nextPosVec, false, true, true);
        posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        if (hit != null) {
            Vec3 hitVec = posVec.func_72444_a(hit.field_72307_f);
            float lambda = 1.0f;
            if (this.field_70159_w != 0.0) {
                lambda = (float)(hitVec.field_72450_a / this.field_70159_w);
            } else if (this.field_70181_x != 0.0) {
                lambda = (float)(hitVec.field_72448_b / this.field_70181_x);
            } else if (this.field_70179_y != 0.0) {
                lambda = (float)(hitVec.field_72449_c / this.field_70179_y);
            }
            if (lambda < 0.0f) {
                lambda = -lambda;
            }
            hits.add(new BlockHit(hit, lambda));
        }
        if (!hits.isEmpty()) {
            Collections.sort(hits);
            boolean showCrosshair = false;
            this.lastHitPenAmount = 0.0f;
            this.lastHitHeadshot = false;
            for (BulletHit bulletHit : hits) {
                if (bulletHit instanceof DriveableHit) {
                    if (this.type.entityHitSoundEnable) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.hitSoundRange, this.field_71093_bK, this.type.hitSound, true);
                    }
                    boolean isFriendly = false;
                    DriveableHit driveableHit = (DriveableHit)bulletHit;
                    driveableHit.driveable.lastAtkEntity = this.owner;
                    if (TeamsManager.getInstance().currentRound != null) {
                        for (EntitySeat seat : driveableHit.driveable.seats) {
                            if (seat.field_70153_n == null || !(seat.field_70153_n instanceof EntityPlayerMP)) continue;
                            PlayerData dataDriver = PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayerMP)seat.field_70153_n));
                            PlayerData dataAttacker = PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayerMP)this.owner));
                            if (!dataDriver.team.shortName.equals(dataAttacker.team.shortName)) continue;
                            isFriendly = true;
                        }
                    }
                    this.penetratingPower = isFriendly ? 0.0f : driveableHit.driveable.bulletHit(this, driveableHit, this.penetratingPower);
                    if (!this.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer) {
                        showCrosshair = true;
                    }
                    if (this.type.canSpotEntityDriveable) {
                        driveableHit.driveable.setEntityMarker(200);
                    }
                    if (FlansMod.DEBUG) {
                        this.field_70170_p.func_72838_d((Entity)new EntityDebugDot(this.field_70170_p, new Vector3f(this.field_70165_t + this.field_70159_w * (double)driveableHit.intersectTime, this.field_70163_u + this.field_70181_x * (double)driveableHit.intersectTime, this.field_70161_v + this.field_70179_y * (double)driveableHit.intersectTime), 1000, 0.0f, 0.0f, 1.0f));
                    }
                } else if (bulletHit instanceof PlayerBulletHit) {
                    if (this.type.entityHitSoundEnable) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.hitSoundRange, this.field_71093_bK, this.type.hitSound, true);
                    }
                    if (!this.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer) {
                        showCrosshair = true;
                    }
                    PlayerBulletHit playerHit = (PlayerBulletHit)bulletHit;
                    this.penetratingPower = playerHit.hitbox.hitByBullet(this, this.penetratingPower);
                    if (FlansMod.DEBUG) {
                        this.field_70170_p.func_72838_d((Entity)new EntityDebugDot(this.field_70170_p, new Vector3f(this.field_70165_t + this.field_70159_w * (double)playerHit.intersectTime, this.field_70163_u + this.field_70181_x * (double)playerHit.intersectTime, this.field_70161_v + this.field_70179_y * (double)playerHit.intersectTime), 1000, 1.0f, 0.0f, 0.0f));
                    }
                } else if (bulletHit instanceof EntityHit) {
                    if (this.type.entityHitSoundEnable) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.hitSoundRange, this.field_71093_bK, this.type.hitSound, true);
                    }
                    if (!this.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer) {
                        showCrosshair = true;
                        this.lastHitPenAmount = 1.0f;
                    }
                    EntityHit entityHit = (EntityHit)bulletHit;
                    float d = this.damage;
                    if (entityHit.entity instanceof EntityLivingBase) {
                        d *= this.type.damageVsLiving;
                        if (entityHit.entity != this.owner) {
                            FlansMod.proxy.spawnParticle("reddust", entityHit.entity.field_70165_t, entityHit.entity.field_70163_u, entityHit.entity.field_70161_v, 0.0, 0.0, 0.0);
                        }
                    } else {
                        d *= this.type.damageVsEntity;
                    }
                    if (entityHit.entity.func_70097_a(this.getBulletDamage(false), d) && entityHit.entity instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)entityHit.entity;
                        for (PotionEffect effect : this.type.hitEffects) {
                            living.func_70690_d(new PotionEffect(effect));
                        }
                        ++living.field_70720_be;
                        living.field_70172_ad = living.field_70771_an / 2;
                    }
                    if (this.type.setEntitiesOnFire) {
                        entityHit.entity.func_70015_d(20);
                    }
                    this.penetratingPower -= 1.0f;
                    if (FlansMod.DEBUG) {
                        this.field_70170_p.func_72838_d((Entity)new EntityDebugDot(this.field_70170_p, new Vector3f(this.field_70165_t + this.field_70159_w * (double)entityHit.intersectTime, this.field_70163_u + this.field_70181_x * (double)entityHit.intersectTime, this.field_70161_v + this.field_70179_y * (double)entityHit.intersectTime), 1000, 1.0f, 1.0f, 0.0f));
                        FlansMod.log(entityHit.entity.toString() + ": d=" + d + ": damage=" + this.damage + ": type.damageVsEntity=" + this.type.damageVsEntity);
                    }
                } else if (bulletHit instanceof BlockHit) {
                    BlockHit blockHit = (BlockHit)bulletHit;
                    MovingObjectPosition raytraceResult = blockHit.raytraceResult;
                    int xTile = raytraceResult.field_72311_b;
                    int yTile = raytraceResult.field_72312_c;
                    int zTile = raytraceResult.field_72309_d;
                    if (FlansMod.DEBUG) {
                        this.field_70170_p.func_72838_d((Entity)new EntityDebugDot(this.field_70170_p, new Vector3f(raytraceResult.field_72307_f.field_72450_a, raytraceResult.field_72307_f.field_72448_b, raytraceResult.field_72307_f.field_72449_c), 1000, 0.0f, 1.0f, 0.0f));
                    }
                    Block block = this.field_70170_p.func_147439_a(xTile, yTile, zTile);
                    Material mat = block.func_149688_o();
                    if (this.type.breaksGlass && mat == Material.field_151592_s && TeamsManager.canBreakGlass) {
                        this.field_70170_p.func_147468_f(xTile, yTile, zTile);
                        FlansMod.proxy.playBlockBreakSound(xTile, yTile, zTile, block, this.field_71093_bK);
                    }
                    if (this.field_70170_p.field_72995_K && block.func_149688_o() != Material.field_151579_a && this.type.explosionRadius <= 0.0f) {
                        int num = 2 + this.field_70146_Z.nextInt(3);
                        for (int i = 0; i < num; ++i) {
                            FlansMod.proxy.spawnParticle("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(xTile, yTile, zTile), raytraceResult.field_72307_f.field_72450_a + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, raytraceResult.field_72307_f.field_72448_b + 0.1, raytraceResult.field_72307_f.field_72449_c + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, -this.field_70159_w * 4.0, 1.5, -this.field_70179_y * 4.0);
                            FlansMod.proxy.spawnParticle("explode", raytraceResult.field_72307_f.field_72450_a, raytraceResult.field_72307_f.field_72448_b, raytraceResult.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
                        }
                    }
                    this.func_70107_b(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
                    if (this.type.hitSoundEnable) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.hitSoundRange, this.field_71093_bK, this.type.hitSound, true);
                    }
                    this.func_70106_y();
                    break;
                }
                if (!(this.penetratingPower <= 0.0f) && (!this.type.explodeOnImpact || this.ticksInAir <= 1)) continue;
                this.func_70107_b(this.field_70165_t + this.field_70159_w * (double)bulletHit.intersectTime, this.field_70163_u + this.field_70181_x * (double)bulletHit.intersectTime, this.field_70161_v + this.field_70179_y * (double)bulletHit.intersectTime);
                this.func_70106_y();
                break;
            }
            if (showCrosshair && this.owner instanceof EntityPlayerMP) {
                FlansMod.getPacketHandler().sendTo(new PacketHitMarker(this.lastHitHeadshot, this.lastHitPenAmount, false), (EntityPlayerMP)this.owner);
            }
        }
        float drag = this.type.dragInAir;
        float gravity = 0.02f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float bubbleMotion = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)bubbleMotion, this.field_70163_u - this.field_70181_x * (double)bubbleMotion, this.field_70161_v - this.field_70179_y * (double)bubbleMotion, this.field_70159_w, this.field_70181_x + (double)0.1f, this.field_70179_y);
            }
            drag = this.type.dragInWater;
        }
        if (!this.type.torpedo) {
            this.field_70159_w *= (double)drag;
            this.field_70181_x *= (double)drag;
            this.field_70179_y *= (double)drag;
            this.field_70181_x -= (double)(gravity * this.type.fallSpeed);
        }
        if (this.lockedOnTo != null) {
            if (this.lockedOnTo instanceof EntityDriveable) {
                EntityDriveable entDriveable = (EntityDriveable)this.lockedOnTo;
                if (entDriveable.getDriveableType().lockedOnSound != null && this.soundTime <= 0 && !this.field_70170_p.field_72995_K) {
                    PacketPlaySound.sendSoundPacket(this.lockedOnTo.field_70165_t, this.lockedOnTo.field_70163_u, this.lockedOnTo.field_70161_v, entDriveable.getDriveableType().lockedOnSoundRange, this.field_71093_bK, entDriveable.getDriveableType().lockedOnSound, false);
                    this.soundTime = entDriveable.getDriveableType().soundTime;
                }
            } else {
                this.lockedOnTo.getEntityData().func_74757_a("Tracking", true);
            }
            if (this.field_70173_aa > this.type.tickStartHoming) {
                double dmotion;
                Vector3f motionVector;
                double angle;
                double dX = this.lockedOnTo.field_70165_t - this.field_70165_t;
                double dY = this.type.isDoTopAttack && Math.abs(this.lockedOnTo.field_70165_t - this.field_70165_t) > 2.0 && Math.abs(this.lockedOnTo.field_70161_v - this.field_70161_v) > 2.0 ? this.lockedOnTo.field_70163_u + 30.0 - this.field_70163_u : this.lockedOnTo.field_70163_u - this.field_70163_u;
                double dZ = this.lockedOnTo.field_70161_v - this.field_70161_v;
                double dXYZ = !this.type.isDoTopAttack ? (double)this.func_70032_d(this.lockedOnTo) : Math.sqrt(dX * dX + dY * dY + dZ * dZ);
                if (this.owner != null && this.type.enableSACLOS) {
                    double dXp = this.lockedOnTo.field_70165_t - this.owner.field_70165_t;
                    double dYp = this.lockedOnTo.field_70163_u - this.owner.field_70163_u;
                    double dZp = this.lockedOnTo.field_70161_v - this.owner.field_70161_v;
                    Vec3 playerVec = this.owner.func_70040_Z();
                    Vector3f playerVec3f = new Vector3f(playerVec.field_72450_a, playerVec.field_72448_b, playerVec.field_72449_c);
                    double angles = Math.abs(Vector3f.angle(playerVec3f, new Vector3f(dXp, dYp, dZp)));
                    if (angles > Math.toRadians(this.type.maxDegreeOfSACLOS)) {
                        this.lockedOnTo = null;
                    }
                }
                if (this.toggleLock) {
                    if (dXYZ > (double)this.type.maxRangeOfMissile) {
                        this.lockedOnTo = null;
                    }
                    this.toggleLock = false;
                }
                if ((angle = (double)Math.abs(Vector3f.angle(motion, motionVector = new Vector3f(dX * (dmotion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) / dXYZ, dY * dmotion / dXYZ, dZ * dmotion / dXYZ)))) > Math.toRadians(this.type.maxDegreeOfMissile)) {
                    this.lockedOnTo = null;
                } else {
                    this.field_70159_w = motionVector.x;
                    this.field_70181_x = motionVector.y;
                    this.field_70179_y = motionVector.z;
                }
                if (this.field_70173_aa > 4 && dXYZ > this.prevDistanceToEntity) {
                    ++this.closeCount;
                    if (this.closeCount > 15) {
                        this.lockedOnTo = null;
                    }
                } else if (this.closeCount > 0) {
                    --this.closeCount;
                }
                this.prevDistanceToEntity = dXYZ;
            }
            if (this.lockedOnTo instanceof EntityDriveable) {
                EntityDriveable plane = (EntityDriveable)this.lockedOnTo;
                if (plane.varFlare || plane.ticksFlareUsing > 0) {
                    this.lockedOnTo = null;
                }
            } else if (this.lockedOnTo != null && this.lockedOnTo.getEntityData().func_74767_n("FlareUsing")) {
                this.lockedOnTo = null;
            }
        }
        if (this.owner != null && this.type.shootForSettingPos && !this.isFirstPositionSetting) {
            EntityPlayer entP;
            if (this.owner instanceof EntityPlayer && (entP = (EntityPlayer)this.owner).func_71045_bC() != null && entP.func_71045_bC().func_77973_b() instanceof ItemGun) {
                ItemGun itemGun = (ItemGun)entP.func_71045_bC().func_77973_b();
                this.impactX = itemGun.impactX;
                this.impactY = itemGun.impactY;
                this.impactZ = itemGun.impactZ;
            }
            this.isFirstPositionSetting = true;
        }
        if (this.type.shootForSettingPos && this.isFirstPositionSetting && this.isPositionUpper) {
            double motionXa = this.field_70159_w;
            double motionYa = this.field_70181_x;
            double motionZa = this.field_70179_y;
            double motiona = Math.sqrt(motionXa * motionXa + motionYa * motionYa + motionZa * motionZa);
            this.field_70159_w = 0.0;
            this.field_70181_x = motiona;
            this.field_70179_y = 0.0;
            if (this.field_70163_u - (double)this.type.shootForSettingPosHeight > this.owner.field_70163_u) {
                this.isPositionUpper = false;
            }
        }
        if (this.type.shootForSettingPos && this.isFirstPositionSetting && !this.isPositionUpper) {
            double rootx = (double)this.impactX - this.field_70165_t;
            double rootz = (double)this.impactZ - this.field_70161_v;
            double roota = Math.sqrt(rootx * rootx + rootz * rootz);
            double motionXa = this.field_70159_w;
            double motionYa = this.field_70181_x;
            double motionZa = this.field_70179_y;
            double motiona = Math.sqrt(motionXa * motionXa + motionYa * motionYa + motionZa * motionZa);
            this.field_70159_w = rootx * motiona / roota;
            this.field_70179_y = rootz * motiona / roota;
            if (Math.abs((double)this.impactX - this.field_70165_t) < 1.0 && Math.abs((double)this.impactZ - this.field_70161_v) < 1.0) {
                double motionXab = this.field_70159_w;
                double motionYab = this.field_70181_x;
                double motionZab = this.field_70179_y;
                double motionab = Math.sqrt(motionXa * motionXa + motionYa * motionYa + motionZa * motionZa);
                this.field_70159_w = 0.0;
                this.field_70181_x = -motionab;
                this.field_70179_y = 0.0;
            }
        }
        this.field_70155_l = 256.0;
        if (this.owner != null && this.type.manualGuidance && this.VLSDelay <= 0 && this.lockedOnTo == null) {
            this.field_70155_l = 256.0;
            Vector3f lookVec = new Vector3f((float)this.owner.func_70040_Z().field_72450_a, (float)this.owner.func_70040_Z().field_72448_b, (float)this.owner.func_70040_Z().field_72449_c);
            Vector3f origin2 = new Vector3f(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
            if (this.type.fixedDirection) {
                lookVec = this.lookVector;
                origin2 = this.initialPos;
            }
            float x = (float)(this.field_70165_t - (double)origin2.x);
            float y = (float)(this.field_70163_u - (double)origin2.y);
            float z = (float)(this.field_70161_v - (double)origin2.z);
            float d = (float)Math.sqrt(x * x + y * y + z * z);
            lookVec.normalise();
            Vector3f targetPoint = new Vector3f(origin2.x + lookVec.x * (d += this.type.turnRadius), origin2.y + lookVec.y * d, origin2.z + lookVec.z * d);
            Vector3f diff = Vector3f.sub(targetPoint, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), null);
            float speed2 = this.type.trackPhaseSpeed;
            float turnSpeed = this.type.trackPhaseTurn;
            diff.normalise();
            turnSpeed = 0.1f;
            Vector3f targetSpeed = new Vector3f(diff.x * speed2, diff.y * speed2, diff.z * speed2);
            this.field_70159_w += ((double)targetSpeed.x - this.field_70159_w) * (double)turnSpeed;
            this.field_70181_x += ((double)targetSpeed.y - this.field_70181_x) * (double)turnSpeed;
            this.field_70179_y += ((double)targetSpeed.z - this.field_70179_y) * (double)turnSpeed;
        }
        if (this.type.torpedo) {
            if (this.func_70090_H()) {
                Vector3f motion2 = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                float length = motion.length();
                motion.normalise();
                this.field_70181_x *= (double)0.3f;
                this.field_70159_w = motion.x * 1.0f;
                this.field_70179_y = motion.z * 1.0f;
            } else {
                this.field_70181_x -= (double)(gravity * this.type.fallSpeed);
            }
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        float motionXZ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionXZ) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.type.trailParticles && this.field_70170_p.field_72995_K && this.ticksInAir > 1) {
            this.spawnParticles();
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        block3: {
            float spread;
            double dZ;
            double dY;
            double dX;
            block2: {
                dX = (this.field_70165_t - this.field_70169_q) / 10.0;
                dY = (this.field_70163_u - this.field_70167_r) / 10.0;
                dZ = (this.field_70161_v - this.field_70166_s) / 10.0;
                spread = 0.1f;
                if (this.VLSDelay <= 0 || this.type.boostPhaseParticle == null) break block2;
                for (int i = 0; i < 10; ++i) {
                    FlansMod.proxy.spawnParticle(this.type.boostPhaseParticle, this.field_70169_q + dX * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70167_r + dY * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70166_s + dZ * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, 0.0, 0.0, 0.0);
                }
                break block3;
            }
            if (this.type.VLS && this.VLSDelay > 0) break block3;
            for (int i = 0; i < 10; ++i) {
                FlansMod.proxy.spawnParticle(this.type.trailParticleType, this.field_70169_q + dX * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70167_r + dY * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70166_s + dZ * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnHitParticles(double x, double y, double z) {
        FlansMod.proxy.spawnParticle("explode", x, y, z, 0.0, 0.0, 0.0);
    }

    public DamageSource getBulletDamage(boolean headshot) {
        if (this.owner instanceof EntityPlayer) {
            return new EntityDamageSourceFlans(this.type.shortName, this, (EntityPlayer)this.owner, this.firedFrom, headshot, false).func_76349_b();
        }
        return new EntityDamageSourceIndirect(this.type.shortName, (Entity)this, this.owner).func_76349_b();
    }

    private boolean isPartOfOwner(Entity entity) {
        if (this.owner == null) {
            return false;
        }
        if (entity == this.owner || entity == this.owner.field_70153_n || entity == this.owner.field_70154_o) {
            return true;
        }
        if (this.owner instanceof EntityPlayer) {
            if (PlayerHandler.getPlayerData((EntityPlayer)this.owner, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER) == null) {
                return false;
            }
            EntityMG mg = PlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)this.owner), (Side)(this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)).mountingGun;
            if (mg != null && mg == entity) {
                return true;
            }
        }
        return this.owner.field_70154_o instanceof EntitySeat && (((EntitySeat)this.owner.field_70154_o).driveable == null || ((EntitySeat)this.owner.field_70154_o).driveable.isPartOfThis(entity));
    }

    public void func_70106_y() {
        block14: {
            try {
                if (this.field_70128_L) {
                    return;
                }
                super.func_70106_y();
                if (this.field_70170_p.field_72995_K) {
                    return;
                }
                if (this.type.explosionRadius > 0.0f) {
                    if (this.owner instanceof EntityPlayer) {
                        new FlansModExplosion(this.field_70170_p, this, (EntityPlayer)this.owner, this.type, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, this.type.explosionPower, TeamsManager.explosions && this.type.explosionBreaksBlocks, this.type.explosionDamageVsLiving, this.type.explosionDamageVsPlayer, this.type.explosionDamageVsPlane, this.type.explosionDamageVsVehicle, this.type.smokeParticleCount, this.type.debrisParticleCount);
                    } else {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, TeamsManager.explosions);
                    }
                }
                if (this.type.fireRadius > 0.0f) {
                    for (float i = -this.type.fireRadius; i < this.type.fireRadius; i += 1.0f) {
                        for (float k = -this.type.fireRadius; k < this.type.fireRadius; k += 1.0f) {
                            for (int j = -1; j < 1; ++j) {
                                if (this.field_70170_p.func_147439_a((int)(this.field_70165_t + (double)i), (int)(this.field_70163_u + (double)j), (int)(this.field_70161_v + (double)k)).func_149688_o() != Material.field_151579_a) continue;
                                this.field_70170_p.func_147449_b((int)(this.field_70165_t + (double)i), (int)(this.field_70163_u + (double)j), (int)(this.field_70161_v + (double)k), (Block)Blocks.field_150480_ab);
                            }
                        }
                    }
                }
                if (this.type.flak > 0) {
                    FlansMod.getPacketHandler().sendToAllAround(new PacketFlak(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.flak, this.type.flakParticles), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
                }
                if (this.type.dropItemOnHit != null) {
                    String itemName = this.type.dropItemOnHit;
                    int damage = 0;
                    if (itemName.contains(".")) {
                        damage = Integer.parseInt(itemName.split("\\.")[1]);
                        itemName = itemName.split("\\.")[0];
                    }
                    ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
                    this.func_70099_a(dropStack, 1.0f);
                }
            }
            catch (Exception e) {
                if (!FlansMod.printStackTrace) break block14;
                e.printStackTrace();
            }
        }
    }

    public float moveToTarget(float current, float target, float speed) {
        float pitchToMove;
        for (pitchToMove = (float)(Math.sqrt(target * target) - Math.sqrt(current * current)); pitchToMove > 180.0f; pitchToMove -= 360.0f) {
        }
        while (pitchToMove <= -180.0f) {
            pitchToMove += 360.0f;
        }
        float signDeltaY = 0.0f;
        if (pitchToMove > speed) {
            signDeltaY = 1.0f;
        } else if (pitchToMove < -speed) {
            signDeltaY = -1.0f;
        } else {
            signDeltaY = 0.0f;
            return target;
        }
        if (current > target) {
            current -= speed;
        } else if (current < target) {
            current += speed;
        }
        return current;
    }

    public void detonate() {
        if (this.field_70173_aa < this.type.primeDelay) {
            return;
        }
        if (this.detonated) {
            return;
        }
        this.detonated = true;
        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.type.detonateSound, true);
        if (!this.field_70170_p.field_72995_K && this.type.explosionRadius > 0.1f) {
            if (this.owner instanceof EntityPlayer) {
                new FlansModExplosion(this.field_70170_p, this, (EntityPlayer)this.owner, this.type, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, this.type.explosionPower, TeamsManager.explosions && this.type.explosionBreaksBlocks, this.type.explosionDamageVsLiving, this.type.explosionDamageVsPlayer, this.type.explosionDamageVsPlane, this.type.explosionDamageVsVehicle, this.type.smokeParticleCount, this.type.debrisParticleCount);
                this.field_70128_L = true;
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, TeamsManager.explosions && this.type.explosionBreaksBlocks);
                this.field_70128_L = true;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.type.fireRadius > 0.1f) {
            for (float i = -this.type.fireRadius; i < this.type.fireRadius; i += 1.0f) {
                for (float j = -this.type.fireRadius; j < this.type.fireRadius; j += 1.0f) {
                    for (float k = -this.type.fireRadius; k < this.type.fireRadius; k += 1.0f) {
                        int x = MathHelper.func_76128_c((double)((double)i + this.field_70165_t));
                        int y = MathHelper.func_76128_c((double)((double)j + this.field_70163_u));
                        int z = MathHelper.func_76128_c((double)((double)k + this.field_70161_v));
                        if (!(i * i + j * j + k * k <= this.type.fireRadius * this.type.fireRadius) || this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150350_a || !this.field_70146_Z.nextBoolean()) continue;
                        this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 3);
                    }
                }
            }
        }
        for (int i = 0; i < this.type.explodeParticles; ++i) {
            this.field_70170_p.func_72869_a(this.type.explodeParticleType, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian());
        }
        if (!this.field_70170_p.field_72995_K && this.type.dropItemOnDetonate != null) {
            String itemName = this.type.dropItemOnDetonate;
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            this.func_70099_a(dropStack, 1.0f);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        if (this.type == null) {
            FlansMod.log("EntityBullet.writeEntityToNBT() Error: BulletType is null (" + this + ")");
            this.func_70106_y();
            return;
        }
        tag.func_74778_a("type", this.type.shortName);
        if (this.owner == null) {
            tag.func_74778_a("owner", "null");
        } else {
            tag.func_74778_a("owner", this.owner.func_70005_c_());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        String typeString = tag.func_74779_i("type");
        String ownerName = tag.func_74779_i("owner");
        if (typeString != null) {
            this.type = BulletType.getBullet(typeString);
        }
        if (this.type == null) {
            this.field_70128_L = true;
            return;
        }
        if (this.type.despawnTime <= 0) {
            this.field_70128_L = true;
        }
        if (ownerName != null && !ownerName.equals("null")) {
            this.owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(ownerName);
        }
    }

    public float func_70053_R() {
        return this.type.hitBoxSize;
    }

    public void setSubmunitionDelay() {
        this.submunitionDelay = this.type.subMunitionTimer;
        this.hasSetSubDelay = true;
    }

    public void DeploySubmunitions() {
        ItemShootable itemShootable = (ItemShootable)GameRegistry.findItem((String)"flansmod", (String)this.type.submunition);
        ShootableType shootType = itemShootable.type;
        World world = this.field_70170_p;
        EntityLivingBase entityplayer = (EntityLivingBase)this.owner;
        for (int sm = 0; sm < this.type.numSubmunitions; ++sm) {
            world.func_72838_d((Entity)itemShootable.getEntity(world, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y), entityplayer, this.type.submunitionSpread, this.damage, this.speedA, 0, this.firedFrom));
        }
        if (this.type.destroyOnDeploySubmunition) {
            this.detonate();
        }
    }

    public int func_70070_b(float par1) {
        int j;
        if (this.type.hasLight) {
            return 0xF000F0;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v))) {
            double d0 = (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M + d0));
            return this.field_70170_p.func_72802_i(i, k, j, 0);
        }
        return 0;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
        data.writeInt(this.impactX);
        data.writeInt(this.impactY);
        data.writeInt(this.impactZ);
        data.writeInt(this.lockedOnTo == null ? -1 : this.lockedOnTo.func_145782_y());
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type.shortName);
        if (this.owner == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)"null");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.owner.func_70005_c_());
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.field_70159_w = data.readDouble();
            this.field_70181_x = data.readDouble();
            this.field_70179_y = data.readDouble();
            this.impactX = data.readInt();
            this.impactY = data.readInt();
            this.impactZ = data.readInt();
            int lockedOnToID = data.readInt();
            if (lockedOnToID != -1) {
                this.lockedOnTo = this.field_70170_p.func_73045_a(lockedOnToID);
            }
            this.type = BulletType.getBullet(ByteBufUtils.readUTF8String((ByteBuf)data));
            this.penetratingPower = this.type.penetratingPower;
            String name = ByteBufUtils.readUTF8String((ByteBuf)data);
            for (Object obj : this.field_70170_p.field_72996_f) {
                if (!((Entity)obj).func_70005_c_().equals(name)) continue;
                this.owner = (EntityPlayer)obj;
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to read bullet owner from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    public boolean func_70027_ad() {
        return false;
    }
}

