/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketRequestDebug;
import com.flansmod.common.teams.PlayerStats;
import com.flansmod.common.teams.TeamsManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PlayerHandler {
    private static final Random rand = new Random();
    private boolean statsSynced = false;
    public static Map<String, PlayerData> serverSideData = new HashMap<String, PlayerData>();
    public static Map<String, PlayerData> clientSideData = new HashMap<String, PlayerData>();
    public static Map<String, PlayerStats> serverSidePlayerStats = new HashMap<String, PlayerStats>();
    public static Map<String, PlayerStats> clientSidePlayerStats = new HashMap<String, PlayerStats>();
    public static ArrayList<String> clientsToRemoveAfterThisRound = new ArrayList();

    public PlayerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70154_o instanceof EntityDriveable || entity.field_70154_o instanceof EntitySeat) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        float damage = event.ammount;
        if (damage > 0.0f && event.source instanceof EntityDamageSourceFlans) {
            EntityDamageSourceFlans source = (EntityDamageSourceFlans)event.source;
            ShootableType shootableType = null;
            Entity damageSouceEntity = source.getDamageSourceEntity();
            if (damageSouceEntity instanceof EntityBullet) {
                shootableType = ((EntityBullet)damageSouceEntity).type;
            }
            if (damageSouceEntity instanceof EntityGrenade) {
                shootableType = ((EntityGrenade)damageSouceEntity).type;
            }
            if (shootableType != null && shootableType.ignoreArmorProbability > 0.0f && rand.nextFloat() < shootableType.ignoreArmorProbability) {
                EntityLivingBase entity = event.entityLiving;
                float f1 = damage;
                damage = Math.max(damage - entity.func_110139_bj(), 0.0f);
                entity.func_110149_m(entity.func_110139_bj() - (f1 - damage));
                if ((damage *= shootableType.ignoreArmorDamageFactor) != 0.0f) {
                    float health = entity.func_110143_aJ();
                    entity.func_70606_j(health - damage);
                    entity.func_110142_aN().func_94547_a((DamageSource)source, health, damage);
                    entity.func_110149_m(entity.func_110139_bj() - damage);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            PlayerHandler.getPlayerData((EntityPlayer)entity).playerKilled();
        }
    }

    public void serverTick() {
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object player : world.field_73010_i) {
                PlayerHandler.getPlayerData((EntityPlayer)player).tick((EntityPlayer)player);
            }
        }
        if (TeamsManager.getInstance().currentRound != null && !this.statsSynced) {
            if (PlayerStats.getAllPlayersStats() == null) {
                this.statsSynced = true;
            }
            for (PlayerStats stats : PlayerStats.getAllPlayersStats()) {
                serverSidePlayerStats.put(stats.nickname, stats);
                this.statsSynced = true;
            }
        }
    }

    public void clientTick() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            for (Object player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                PlayerHandler.getPlayerData((EntityPlayer)player).tick((EntityPlayer)player);
            }
        }
    }

    public static PlayerData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    public static PlayerData getPlayerData(String username) {
        return PlayerHandler.getPlayerData(username, Side.SERVER);
    }

    public static PlayerData getPlayerData(EntityPlayer player, Side side) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), side);
    }

    public static PlayerData getPlayerData(String username, Side side) {
        if (side.isClient()) {
            if (!clientSideData.containsKey(username)) {
                clientSideData.put(username, new PlayerData(username));
            }
        } else if (!serverSideData.containsKey(username)) {
            serverSideData.put(username, new PlayerData(username));
        }
        return side.isClient() ? clientSideData.get(username) : serverSideData.get(username);
    }

    public static PlayerStats getPlayerStats(EntityPlayerMP player) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerStats(player, player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    public static PlayerStats getPlayerStats(EntityPlayerMP player, Side side) {
        String username = player.func_70005_c_();
        if (side.isClient()) {
            if (!clientSidePlayerStats.containsKey(username)) {
                clientSidePlayerStats.put(username, new PlayerStats(player.field_70170_p, player));
            }
        } else if (!serverSidePlayerStats.containsKey(username)) {
            serverSidePlayerStats.put(username, new PlayerStats(player.field_70170_p, player));
        }
        return side.isClient() ? clientSidePlayerStats.get(username) : serverSidePlayerStats.get(username);
    }

    @SubscribeEvent
    public void onPlayerEvent(PlayerEvent event) {
        if (event instanceof PlayerEvent.PlayerLoggedInEvent) {
            EntityPlayer player;
            String username;
            if (event.player instanceof EntityPlayerMP) {
                FlansMod.packetHandler.sendTo(new PacketRequestDebug(false), (EntityPlayerMP)event.player);
            }
            if (!serverSideData.containsKey(username = (player = event.player).func_70005_c_())) {
                serverSideData.put(username, new PlayerData(username));
            }
            clientsToRemoveAfterThisRound.remove(username);
            if (!serverSidePlayerStats.containsKey(username)) {
                serverSidePlayerStats.put(username, new PlayerStats(player.field_70170_p, (EntityPlayerMP)player));
            }
        } else if (event instanceof PlayerEvent.PlayerLoggedOutEvent) {
            EntityPlayer player = event.player;
            String username = player.func_70005_c_();
            if (TeamsManager.getInstance().currentRound == null) {
                serverSideData.remove(username);
            } else {
                clientsToRemoveAfterThisRound.add(username);
            }
        } else if (event instanceof PlayerEvent.PlayerRespawnEvent) {
            EntityPlayer player = event.player;
            String username = player.func_70005_c_();
            if (!serverSideData.containsKey(username)) {
                serverSideData.put(username, new PlayerData(username));
            }
            if (!serverSidePlayerStats.containsKey(username)) {
                serverSidePlayerStats.put(username, new PlayerStats(player.field_70170_p, (EntityPlayerMP)player));
            }
        }
    }

    public static void roundEnded() {
        for (String username : clientsToRemoveAfterThisRound) {
            serverSideData.remove(username);
        }
    }
}

