/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMecha;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderMecha
extends Render
implements IItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ItemRenderer renderer = new ItemRenderer(Minecraft.func_71410_x());

    public RenderMecha() {
        this.field_76989_e = 1.5f;
    }

    public void render(EntityMecha mecha, double d, double d1, double d2, float f, float f1) {
        ItemStack holdingStack;
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_110777_b(mecha);
        float scale = 0.0625f;
        MechaType type = mecha.getMechaType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = mecha.axes.getYaw() - mecha.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = mecha.axes.getPitch() - mecha.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = mecha.axes.getRoll() - mecha.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(-mecha.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = mecha.getMechaType().modelScale;
        ModelMecha model = (ModelMecha)type.model;
        if (model == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        model.render(mecha, f1);
        ItemStack hipsSlot = mecha.inventory.getStackInSlot(EnumMechaSlotType.hips);
        if (hipsSlot != null && hipsSlot.func_77973_b() instanceof ItemMechaAddon) {
            MechaItemType hipsAddon = ((ItemMechaAddon)hipsSlot.func_77973_b()).type;
            if (hipsAddon.model != null) {
                GL11.glTranslatef((float)model.hipsAttachmentPoint.x, (float)model.hipsAttachmentPoint.y, (float)model.hipsAttachmentPoint.z);
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                if (hipsAddon.texture != null) {
                    this.func_110776_a(FlansModResourceHandler.getTexture(hipsAddon));
                }
                hipsAddon.model.render(mecha, f1);
            }
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.leftArm)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            float smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.leftArmOrigin.x, (float)mecha.getMechaType().leftArmOrigin.y, (float)mecha.getMechaType().leftArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderLeftArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.leftHandModifierY), (float)(-type.armLength - type.leftHandModifierX), (float)(0.0f + type.leftHandModifierZ));
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            if (holdingStack == null) {
                model.renderLeftHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, true, f1);
            }
            GL11.glPopMatrix();
        }
        if (mecha.isPartIntact(EnumDriveablePart.rightArm)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            float smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.rightArmOrigin.x, (float)mecha.getMechaType().rightArmOrigin.y, (float)mecha.getMechaType().rightArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderRightArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.rightHandModifierY), (float)(-type.armLength - type.rightHandModifierX), (float)(0.0f + type.rightHandModifierZ));
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (holdingStack == null) {
                model.renderRightHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, false, f1);
            }
            GL11.glPopMatrix();
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            for (DriveablePart part : mecha.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                RenderMecha.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(part.box.x / 16.0f), (double)(part.box.y / 16.0f), (double)(part.box.z / 16.0f), (double)((part.box.x + part.box.w) / 16.0f), (double)((part.box.y + part.box.h) / 16.0f), (double)((part.box.z + part.box.d) / 16.0f)));
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsPrimary) {
                RenderMecha.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.rootPos.position.x - 0.25f), (double)(point.rootPos.position.y - 0.25f), (double)(point.rootPos.position.z - 0.25f), (double)(point.rootPos.position.x + 0.25f), (double)(point.rootPos.position.y + 0.25f), (double)(point.rootPos.position.z + 0.25f)));
            }
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsSecondary) {
                RenderMecha.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(point.rootPos.position.x - 0.25f), (double)(point.rootPos.position.y - 0.25f), (double)(point.rootPos.position.z - 0.25f), (double)(point.rootPos.position.x + 0.25f), (double)(point.rootPos.position.y + 0.25f), (double)(point.rootPos.position.z + 0.25f)));
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.hips)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
            for (dYaw = mecha.legAxes.getYaw() - mecha.prevLegsYaw; dYaw > 180.0f; dYaw -= 360.0f) {
            }
            while (dYaw <= -180.0f) {
                dYaw += 360.0f;
            }
            GL11.glRotatef((float)(-dYaw * f1 - mecha.prevLegsYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            float legLength = type.legLength;
            float dLLUR = mecha.leftLegUpperAngle - mecha.prevLeftLegUpperAngle;
            float dLLLR = mecha.leftLegLowerAngle - mecha.prevLeftLegLowerAngle;
            float dLFR = mecha.leftFootAngle - mecha.prevLeftFootAngle;
            float dRLUR = mecha.rightLegUpperAngle - mecha.prevRightLegUpperAngle;
            float dRLLR = mecha.rightLegLowerAngle - mecha.prevRightLegLowerAngle;
            float dRFR = mecha.rightFootAngle - mecha.prevRightFootAngle;
            float leftLegUpperRot = (float)Math.toRadians(mecha.prevLeftLegUpperAngle + dLLUR * f1);
            float rightLegUpperRot = (float)Math.toRadians(mecha.prevRightLegUpperAngle + dRLUR * f1);
            float leftLegLowerRot = (float)Math.toRadians(mecha.prevLeftLegLowerAngle + dLLLR * f1);
            float rightLegLowerRot = (float)Math.toRadians(mecha.prevRightLegLowerAngle + dRLLR * f1);
            float leftFootRot = (float)Math.toRadians(mecha.prevLeftFootAngle + dLFR * f1);
            float rightFootRot = (float)Math.toRadians(mecha.rightFootAngle + dRFR * f1);
            float legsYaw = (float)Math.sin(((float)mecha.field_70173_aa + f1) / type.legSwingTime) * mecha.legSwing;
            float footH = (float)Math.sin(legsYaw) * legLength;
            float footV = (float)Math.cos(legsYaw) * legLength;
            model.renderHips(scale, mecha, f1);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)legLength, (float)0.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)footH, (float)(-footV), (float)0.0f);
            model.renderLeftFoot(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-footH), (float)(-footV), (float)0.0f);
            model.renderRightFoot(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
            model.renderLeftLeg(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
            model.renderRightLeg(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)(leftLegUpperRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
            model.renderLeftAnimLegUpper(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)(rightLegUpperRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
            model.renderRightAnimLegUpper(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            Vector3f leftLegLowerPos = this.rotatedChildPosition(model.leftLegUpperOrigin, model.leftLegLowerOrigin, leftLegUpperRot);
            GL11.glTranslatef((float)model.leftLegUpperOrigin.x, (float)model.leftLegUpperOrigin.y, (float)model.leftLegUpperOrigin.z);
            GL11.glTranslatef((float)leftLegLowerPos.x, (float)(-leftLegLowerPos.y), (float)0.0f);
            GL11.glRotatef((float)(leftLegLowerRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderLeftAnimLegLower(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            Vector3f rightLegLowerPos = this.rotatedChildPosition(model.rightLegUpperOrigin, model.rightLegLowerOrigin, rightLegUpperRot);
            GL11.glTranslatef((float)model.rightLegUpperOrigin.x, (float)model.rightLegUpperOrigin.y, (float)model.rightLegUpperOrigin.z);
            GL11.glTranslatef((float)rightLegLowerPos.x, (float)(-rightLegLowerPos.y), (float)0.0f);
            GL11.glRotatef((float)(rightLegLowerRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderRightAnimLegLower(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            Vector3f leftFootPos = this.rotatedChildPosition(model.leftLegLowerOrigin, model.leftFootOrigin, leftLegLowerRot);
            GL11.glTranslatef((float)(-model.leftFootOrigin.x), (float)legLength, (float)(-model.leftFootOrigin.z));
            GL11.glTranslatef((float)(leftFootPos.x + leftLegLowerPos.x), (float)(-leftFootPos.y - leftLegLowerPos.y), (float)0.0f);
            GL11.glRotatef((float)(leftFootRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderLeftAnimFoot(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            Vector3f rightFootPos = this.rotatedChildPosition(model.rightLegLowerOrigin, model.rightFootOrigin, rightLegLowerRot);
            GL11.glTranslatef((float)(-model.rightFootOrigin.x), (float)legLength, (float)(-model.rightFootOrigin.z));
            GL11.glTranslatef((float)(rightFootPos.x + rightLegLowerPos.x), (float)(-rightFootPos.y - rightLegLowerPos.y), (float)0.0f);
            GL11.glRotatef((float)(rightFootRot * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderRightAnimFoot(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        this.render((EntityMecha)entity, d0, d1, d2, f, f1);
    }

    public Vector3f rotatedChildPosition(Vector3f parentJoint, Vector3f childJoint, float rotation) {
        float yDiff = parentJoint.y - childJoint.y;
        float xDiff = parentJoint.x - childJoint.x;
        float length = (float)Math.sqrt(yDiff * yDiff + xDiff * xDiff);
        float initialRot = (float)Math.atan(xDiff / yDiff);
        float xPos = (float)Math.sin(rotation - initialRot) * length;
        float yPos = (float)Math.cos(rotation - initialRot) * length;
        Vector3f position = new Vector3f(xPos, yPos, 0.0f);
        return position;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        DriveableType type = ((EntityDriveable)entity).getDriveableType();
        Paintjob paintjob = type.getPaintjob(((EntityDriveable)entity).getDriveableData().paintjobID);
        return FlansModResourceHandler.getPaintjobTexture(paintjob);
    }

    private void renderItem(EntityMecha mecha, ItemStack stack, int par3, boolean leftHand, float dT) {
        GL11.glPushMatrix();
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Item item = stack.func_77973_b();
        if (item instanceof ItemMechaAddon) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            ItemMechaAddon toolItem = (ItemMechaAddon)item;
            MechaItemType toolType = toolItem.type;
            this.func_110776_a(FlansModResourceHandler.getTexture(toolType));
            if (toolType.model != null) {
                toolType.model.render(mecha, dT);
                GL11.glPushMatrix();
                if (leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld) {
                    GL11.glRotatef((float)(25.0f * (float)mecha.field_70173_aa), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                toolType.model.renderDrill(mecha, dT);
                GL11.glPopMatrix();
                toolType.model.renderSaw(mecha, dT, leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld);
            }
        } else if (item instanceof ItemGun && ((ItemGun)item).type.model != null) {
            GunType gunType = ((ItemGun)item).type;
            ModelGun model = gunType.model;
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            texturemanager.func_110577_a(FlansModResourceHandler.getTexture(gunType));
            IItemRenderer.ItemRenderType type = IItemRenderer.ItemRenderType.ENTITY;
            ClientProxy.gunRenderer.renderGun(stack, gunType, 0.0625f, model, leftHand ? mecha.leftAnimations : mecha.rightAnimations, 0.0f, type);
        } else {
            IIcon icon = stack.func_77954_c();
            if (icon == null) {
                GL11.glPopMatrix();
                return;
            }
            texturemanager.func_110577_a(texturemanager.func_130087_a(stack.func_94608_d()));
            Tessellator tessellator = Tessellator.field_78398_a;
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            float f4 = 0.0f;
            float f5 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
            float f6 = 1.5f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.2f, (float)0.7f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-133.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            if (stack.hasEffect(par3)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                texturemanager.func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                return Minecraft.func_71410_x().field_71474_y.field_74347_j && item != null && item.func_77973_b() instanceof ItemMecha && ((ItemMecha)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (item != null && item.func_77973_b() instanceof ItemMecha) {
            MechaType mechaType = ((ItemMecha)item.func_77973_b()).type;
            if (mechaType.model != null) {
                float scale = 0.5f;
                switch (type) {
                    case ENTITY: {
                        scale = 1.5f;
                        GL11.glRotatef((float)((EntityItem)data[1]).field_70173_aa, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.1f, (float)-0.4f);
                        scale = 1.0f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        GL11.glRotatef((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.15f, (float)0.35f, (float)-0.6f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
                GL11.glScalef((float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(mechaType));
                ModelDriveable model = mechaType.model;
                model.render(mechaType);
            }
        }
        GL11.glPopMatrix();
    }
}

