/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.tmt.ModelRendererTurbo;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.vector.Vector3f;
import org.lwjgl.opengl.GL11;

public class ModelPlane
extends ModelDriveable {
    public ModelRendererTurbo[] noseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] topWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bayModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] propellerModels = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] yawFlapModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapLeftModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapRightModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapLeftWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapRightWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimWingModel = new ModelRendererTurbo[0];
    public Vector3f leftWingAttach = new Vector3f();
    public Vector3f rightWingAttach = new Vector3f();
    public ModelRendererTurbo[] bodyAnimWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailAnimWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftAnimWingWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightAnimWingWheelModel = new ModelRendererTurbo[0];
    public Vector3f bodyWheelAttach = new Vector3f();
    public Vector3f tailWheelAttach = new Vector3f();
    public Vector3f leftWingWheelAttach = new Vector3f();
    public Vector3f rightWingWheelAttach = new Vector3f();
    public ModelRendererTurbo[] doorAnimModel = new ModelRendererTurbo[0];
    public Vector3f doorAttach = new Vector3f();
    public ModelRendererTurbo[][] heliMainRotorModels = new ModelRendererTurbo[0][0];
    public Vector3f[] heliMainRotorOrigins = new Vector3f[0];
    public float[] heliRotorSpeeds = new float[0];
    public ModelRendererTurbo[][] heliTailRotorModels = new ModelRendererTurbo[0][0];
    public Vector3f[] heliTailRotorOrigins = new Vector3f[0];
    public ModelRendererTurbo[] skidsModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] helicopterModeParts = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] planeModeParts = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingPos1Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingPos2Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingPos1Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingPos2Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] hudModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] valkyrie = new ModelRendererTurbo[0][0];

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityPlane)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.noseModel);
        this.renderPart(this.leftWingModel);
        this.renderPart(this.rightWingModel);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.leftWingAttach.x, (float)this.leftWingAttach.y, (float)(-this.leftWingAttach.z));
        this.renderPart(this.leftAnimWingModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.rightWingAttach.x, (float)this.rightWingAttach.y, (float)(-this.rightWingAttach.z));
        this.renderPart(this.rightAnimWingModel);
        GL11.glPopMatrix();
        this.renderPart(this.topWingModel);
        this.renderPart(this.bayModel);
        this.renderPart(this.tailModel);
        for (ModelRendererTurbo[] prop : this.propellerModels) {
            for (int j = 0; j < prop.length; ++j) {
                prop[j].field_78795_f = (float)j * 2.0f * (float)Math.PI / (float)prop.length;
                prop[j].func_78785_a(0.0625f);
            }
        }
        for (ModelRendererTurbo[] heliMainRotorModel : this.heliMainRotorModels) {
            this.renderPart(heliMainRotorModel);
        }
        for (ModelRendererTurbo[] heliTailRotorModel : this.heliTailRotorModels) {
            this.renderPart(heliTailRotorModel);
        }
        for (ModelRendererTurbo[] partModel : this.valkyrie) {
            this.renderPart(partModel);
        }
        this.renderPart(this.helicopterModeParts);
        this.renderPart(this.skidsModel);
        this.renderPart(this.yawFlapModel);
        this.renderPart(this.pitchFlapLeftModel);
        this.renderPart(this.pitchFlapRightModel);
        this.renderPart(this.pitchFlapLeftWingModel);
        this.renderPart(this.pitchFlapRightWingModel);
        this.renderPart(this.bodyWheelModel);
        this.renderPart(this.tailWheelModel);
        this.renderPart(this.leftWingWheelModel);
        this.renderPart(this.rightWingWheelModel);
        this.renderPart(this.tailDoorCloseModel);
        this.renderPart(this.rightWingPos1Model);
        this.renderPart(this.leftWingPos1Model);
        this.renderPart(this.hudModel);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.bodyWheelAttach.x, (float)this.bodyWheelAttach.y, (float)(-this.bodyWheelAttach.z));
        this.renderPart(this.bodyAnimWheelModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.tailWheelAttach.x, (float)this.tailWheelAttach.y, (float)(-this.tailWheelAttach.z));
        this.renderPart(this.tailAnimWheelModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.leftWingWheelAttach.x, (float)this.leftWingWheelAttach.y, (float)(-this.leftWingWheelAttach.z));
        this.renderPart(this.leftAnimWingWheelModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.rightWingWheelAttach.x, (float)this.rightWingWheelAttach.y, (float)(-this.rightWingWheelAttach.z));
        this.renderPart(this.rightAnimWingWheelModel);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.doorAttach.x, (float)this.doorAttach.y, (float)(-this.doorAttach.z));
        this.renderPart(this.doorAnimModel);
        GL11.glPopMatrix();
    }

    public void render(float f5, EntityPlane plane, float f) {
        int n;
        float dAngle;
        PlaneType type = plane.getPlaneType();
        for (dAngle = plane.propAngle - plane.prevPropAngle; dAngle > 180.0f; dAngle -= 360.0f) {
        }
        while (dAngle <= -180.0f) {
            dAngle += 360.0f;
        }
        float angle = plane.prevPropAngle + dAngle * f;
        for (Propeller propeller : plane.getPlaneType().propellers) {
            if (!plane.isPartIntact(propeller.planePart) || this.propellerModels.length <= propeller.ID) continue;
            int numParts = this.propellerModels[propeller.ID].length;
            for (int i = 0; i < numParts; ++i) {
                this.propellerModels[propeller.ID][i].field_78795_f = angle + (float)i * 2.0f * (float)Math.PI / (float)numParts;
                this.propellerModels[propeller.ID][i].func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.nose)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.noseModel;
            int n2 = modelRendererTurboArray.length;
            for (n = 0; n < n2; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.bay)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.bayModel;
            int n3 = modelRendererTurboArray.length;
            for (n = 0; n < n3; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.tail)) {
            for (ModelRendererTurbo modelRendererTurbo : this.tailModel) {
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.tailDoorOpenModel) {
                if (!plane.varDoor) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.tailDoorCloseModel) {
                if (plane.varDoor) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.yawFlapModel) {
                modelRendererTurbo.field_78796_g = plane.flapsYaw * (float)Math.PI / 180.0f;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.pitchFlapLeftModel) {
                modelRendererTurbo.field_78808_h = plane.flapsPitchLeft * (float)Math.PI / 180.0f;
                modelRendererTurbo.func_78785_a(f5);
            }
            ModelRendererTurbo[] modelRendererTurboArray = this.pitchFlapRightModel;
            int n4 = modelRendererTurboArray.length;
            for (n = 0; n < n4; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.field_78808_h = plane.flapsPitchRight * (float)Math.PI / 180.0f;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.skids)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.skidsModel;
            int n5 = modelRendererTurboArray.length;
            for (n = 0; n < n5; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                if (!plane.varGear) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.tailWheel)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.tailWheelModel;
            int n6 = modelRendererTurboArray.length;
            for (n = 0; n < n6; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                if (!plane.varGear) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWing)) {
            for (ModelRendererTurbo modelRendererTurbo : this.leftWingModel) {
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.leftWingPos1Model) {
                if (!plane.varWing) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.leftWingPos2Model) {
                if (plane.varWing) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            ModelRendererTurbo[] modelRendererTurboArray = this.pitchFlapLeftWingModel;
            int n7 = modelRendererTurboArray.length;
            for (n = 0; n < n7; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.field_78808_h = plane.flapsPitchLeft * (float)Math.PI / 180.0f;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.rightWing)) {
            for (ModelRendererTurbo modelRendererTurbo : this.rightWingModel) {
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.rightWingPos1Model) {
                if (!plane.varWing) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.rightWingPos2Model) {
                if (plane.varWing) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            ModelRendererTurbo[] modelRendererTurboArray = this.pitchFlapRightWingModel;
            int n8 = modelRendererTurboArray.length;
            for (n = 0; n < n8; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.field_78808_h = plane.flapsPitchRight * (float)Math.PI / 180.0f;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWingWheel)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.leftWingWheelModel;
            int n9 = modelRendererTurboArray.length;
            for (n = 0; n < n9; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                if (!plane.varGear) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.rightWingWheel)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.rightWingWheelModel;
            int n10 = modelRendererTurboArray.length;
            for (n = 0; n < n10; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                if (!plane.varGear) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo modelRendererTurbo : this.bodyModel) {
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.bodyDoorOpenModel) {
                if (!plane.varDoor) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.bodyDoorCloseModel) {
                if (plane.varDoor) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
            ModelRendererTurbo[] modelRendererTurboArray = this.hudModel;
            int n11 = modelRendererTurboArray.length;
            for (n = 0; n < n11; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.field_78795_f = -(plane.axes.getRoll() * (float)Math.PI / 180.0f);
                modelRendererTurbo.func_78785_a(f5);
            }
            if (plane.mode == EnumPlaneMode.HELI) {
                this.renderPart(this.helicopterModeParts);
            } else {
                this.renderPart(this.planeModeParts);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.coreWheel)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.bodyWheelModel;
            int n12 = modelRendererTurboArray.length;
            for (n = 0; n < n12; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                if (!plane.varGear) continue;
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.topWing)) {
            ModelRendererTurbo[] modelRendererTurboArray = this.topWingModel;
            int n13 = modelRendererTurboArray.length;
            for (n = 0; n < n13; ++n) {
                ModelRendererTurbo modelRendererTurbo = modelRendererTurboArray[n];
                modelRendererTurbo.func_78785_a(f5);
            }
        }
        for (EntitySeat entitySeat : plane.seats) {
            if (entitySeat == null || entitySeat.seatInfo == null || entitySeat.seatInfo.gunName == null || this.gunModels.get(entitySeat.seatInfo.gunName) == null || !plane.isPartIntact(entitySeat.seatInfo.part)) continue;
            float yaw = entitySeat.prevLooking.getYaw() + (entitySeat.looking.getYaw() - entitySeat.prevLooking.getYaw()) * f;
            float pitch = entitySeat.prevLooking.getPitch() + (entitySeat.looking.getPitch() - entitySeat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(entitySeat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            if (gunModel.length <= 3) continue;
            float minigunSpeed = entitySeat.getMinigunSpeed();
            for (ModelRendererTurbo gunModelPart : gunModel[3]) {
                gunModelPart.field_78796_g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.field_78795_f = entitySeat.minigunAngle * 0.5f;
                gunModelPart.func_78785_a(f5);
            }
        }
    }

    public void renderValk(EntityPlane plane, float f5, int id) {
        for (ModelRendererTurbo aModel : this.valkyrie[id]) {
            aModel.func_78785_a(f5);
        }
    }

    public void renderLeftWing(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.leftWing)) {
            for (ModelRendererTurbo aAnimLeftWingModel : this.leftAnimWingModel) {
                aAnimLeftWingModel.func_78785_a(f5);
            }
        }
    }

    public void renderRightWing(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.rightWing)) {
            for (ModelRendererTurbo aAnimRightWingModel : this.rightAnimWingModel) {
                aAnimRightWingModel.func_78785_a(f5);
            }
        }
    }

    public void renderLeftWingWheel(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.leftWingWheel)) {
            for (ModelRendererTurbo aAnimLeftWingWheelModel : this.leftAnimWingWheelModel) {
                aAnimLeftWingWheelModel.func_78785_a(f5);
            }
        }
    }

    public void renderRightWingWheel(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.rightWingWheel)) {
            for (ModelRendererTurbo aAnimRightWingWheelModel : this.rightAnimWingWheelModel) {
                aAnimRightWingWheelModel.func_78785_a(f5);
            }
        }
    }

    public void renderCoreWheel(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.coreWheel)) {
            for (ModelRendererTurbo aAnimBodyWheelModel : this.bodyAnimWheelModel) {
                aAnimBodyWheelModel.func_78785_a(f5);
            }
        }
    }

    public void renderTailWheel(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.tailWheel)) {
            for (ModelRendererTurbo aAnimTailWheelModel : this.tailAnimWheelModel) {
                aAnimTailWheelModel.func_78785_a(f5);
            }
        }
    }

    public void renderDoor(EntityPlane plane, float f5) {
        if (plane.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo aDoorAnimModel : this.doorAnimModel) {
                aDoorAnimModel.func_78785_a(f5);
            }
        }
    }

    public void renderRotor(EntityPlane plane, float f5, int i) {
        PlaneType type = plane.getPlaneType();
        if (i >= type.heliPropellers.size() || plane.isPartIntact(type.heliPropellers.get((int)i).planePart)) {
            for (int j = 0; j < this.heliMainRotorModels[i].length; ++j) {
                this.heliMainRotorModels[i][j].func_78785_a(f5);
            }
        }
    }

    public void renderTailRotor(EntityPlane plane, float f5, int i) {
        PlaneType type = plane.getPlaneType();
        if (i >= type.heliTailPropellers.size() || plane.isPartIntact(type.heliTailPropellers.get((int)i).planePart)) {
            for (int j = 0; j < this.heliTailRotorModels[i].length; ++j) {
                this.heliTailRotorModels[i][j].func_78785_a(f5);
            }
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.noseModel);
        this.flip(this.leftWingModel);
        this.flip(this.rightWingModel);
        this.flip(this.topWingModel);
        this.flip(this.bayModel);
        this.flip(this.tailModel);
        this.flip(this.yawFlapModel);
        this.flip(this.skidsModel);
        this.flip(this.helicopterModeParts);
        this.flip(this.planeModeParts);
        this.flip(this.pitchFlapLeftModel);
        this.flip(this.pitchFlapRightModel);
        this.flip(this.pitchFlapLeftWingModel);
        this.flip(this.pitchFlapRightWingModel);
        this.flip(this.bodyWheelModel);
        this.flip(this.tailWheelModel);
        this.flip(this.leftWingWheelModel);
        this.flip(this.rightWingWheelModel);
        this.flip(this.tailDoorOpenModel);
        this.flip(this.tailDoorCloseModel);
        this.flip(this.rightWingPos1Model);
        this.flip(this.rightWingPos2Model);
        this.flip(this.leftWingPos1Model);
        this.flip(this.leftWingPos2Model);
        this.flip(this.hudModel);
        this.flip(this.leftAnimWingModel);
        this.flip(this.rightAnimWingModel);
        this.flip(this.bodyAnimWheelModel);
        this.flip(this.tailAnimWheelModel);
        this.flip(this.leftAnimWingWheelModel);
        this.flip(this.rightAnimWingWheelModel);
        this.flip(this.doorAnimModel);
        for (ModelRendererTurbo[] valkModel : this.valkyrie) {
            this.flip(valkModel);
        }
        for (ModelRendererTurbo[] propellerModel : this.propellerModels) {
            this.flip(propellerModel);
        }
        for (ModelRendererTurbo[] propellerModel : this.heliMainRotorModels) {
            this.flip(propellerModel);
        }
        for (ModelRendererTurbo[] propellerModel : this.heliTailRotorModels) {
            this.flip(propellerModel);
        }
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.noseModel, x, y, z);
        this.translate(this.leftWingModel, x, y, z);
        this.translate(this.rightWingModel, x, y, z);
        this.translate(this.topWingModel, x, y, z);
        this.translate(this.bayModel, x, y, z);
        this.translate(this.tailModel, x, y, z);
        this.translate(this.yawFlapModel, x, y, z);
        this.translate(this.skidsModel, x, y, z);
        this.translate(this.helicopterModeParts, x, y, z);
        this.translate(this.planeModeParts, x, y, z);
        this.translate(this.pitchFlapLeftModel, x, y, z);
        this.translate(this.pitchFlapRightModel, x, y, z);
        this.translate(this.pitchFlapLeftWingModel, x, y, z);
        this.translate(this.pitchFlapRightWingModel, x, y, z);
        this.translate(this.bodyWheelModel, x, y, z);
        this.translate(this.tailWheelModel, x, y, z);
        this.translate(this.leftWingWheelModel, x, y, z);
        this.translate(this.rightWingWheelModel, x, y, z);
        this.translate(this.tailDoorOpenModel, x, y, z);
        this.translate(this.tailDoorCloseModel, x, y, z);
        this.translate(this.rightWingPos1Model, x, y, z);
        this.translate(this.rightWingPos2Model, x, y, z);
        this.translate(this.leftWingPos1Model, x, y, z);
        this.translate(this.leftWingPos2Model, x, y, z);
        this.translate(this.hudModel, x, y, z);
        this.translate(this.leftAnimWingModel, x, y, z);
        this.translate(this.rightAnimWingModel, x, y, z);
        this.translate(this.bodyAnimWheelModel, x, y, z);
        this.translate(this.tailAnimWheelModel, x, y, z);
        this.translate(this.leftAnimWingWheelModel, x, y, z);
        this.translate(this.rightAnimWingWheelModel, x, y, z);
        this.translate(this.doorAnimModel, x, y, z);
        for (ModelRendererTurbo[] modelRendererTurboArray : this.valkyrie) {
            this.translate(modelRendererTurboArray, x, y, z);
        }
        for (ModelRendererTurbo[] modelRendererTurboArray : this.propellerModels) {
            this.translate(modelRendererTurboArray, x, y, z);
        }
        for (ModelRendererTurbo[] modelRendererTurboArray : this.heliMainRotorModels) {
            this.translate(modelRendererTurboArray, x, y, z);
        }
        for (ModelRendererTurbo[] modelRendererTurboArray : this.heliTailRotorModels) {
            this.translate(modelRendererTurboArray, x, y, z);
        }
        for (ModelRendererTurbo[] modelRendererTurboArray : this.heliMainRotorOrigins) {
            Vector3f.add((Vector3f)modelRendererTurboArray, new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f), (Vector3f)modelRendererTurboArray);
        }
        for (ModelRendererTurbo[] modelRendererTurboArray : this.heliTailRotorOrigins) {
            Vector3f.add((Vector3f)modelRendererTurboArray, new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f), (Vector3f)modelRendererTurboArray);
        }
    }
}

