/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public abstract class GuiTooltipScreen
extends GuiScreen {
    public static boolean ShowTooltipButtonEffect = true;
    public static boolean ShowTooltipButtonMouseoverEffect = true;
    public String tooltipNewlineDelimeter = "_p";
    public long tooltipDelay = 900L;
    public int tooltipMaxWidth = 150;
    protected int tooltipXOffset = 0;
    protected int tooltipYOffset = 10;
    private static final int LINE_HEIGHT = 11;
    private long mouseoverTime = 0L;
    private long prevSystemTime = -1L;

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.DrawTooltipScreen(mouseX, mouseY);
    }

    protected abstract String GetButtonTooltip(int var1);

    protected void DrawTooltipScreen(int mouseX, int mouseY) {
        String tooltip;
        if (ShowTooltipButtonEffect) {
            this.RenderTooltipButtonEffect();
        }
        int mousedOverButtonId = -1;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!this.IsButtonMouseovered(mouseX, mouseY, button)) continue;
            mousedOverButtonId = button.field_146127_k;
            if (!ShowTooltipButtonMouseoverEffect || this.GetButtonTooltip(mousedOverButtonId) == null) break;
            this.RenderTooltipButtonMouseoverEffect(button);
            break;
        }
        if (mousedOverButtonId > -1) {
            long systemTime = System.currentTimeMillis();
            if (this.prevSystemTime > 0L) {
                this.mouseoverTime += systemTime - this.prevSystemTime;
            }
            this.prevSystemTime = systemTime;
        } else {
            this.mouseoverTime = 0L;
        }
        if (this.mouseoverTime > this.tooltipDelay && (tooltip = this.GetButtonTooltip(mousedOverButtonId)) != null) {
            this.RenderTooltip(mouseX, mouseY, tooltip);
        }
    }

    protected boolean IsButtonMouseovered(int mouseX, int mouseY, GuiButton button) {
        int buttonHeight;
        return mouseX >= button.field_146128_h && mouseX <= button.field_146128_h + button.func_146117_b() && mouseY >= button.field_146129_i && mouseY <= button.field_146129_i + (buttonHeight = ((Integer)GuiTooltipScreen.GetFieldByReflection(GuiButton.class, button, "height", "field_146121_g")).intValue());
    }

    protected void RenderTooltipButtonEffect() {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (this.GetButtonTooltip(button.field_146127_k) == null) continue;
            boolean flag = this.field_146297_k.field_71466_p.func_82883_a();
            this.field_146297_k.field_71466_p.func_78264_a(true);
            this.field_146297_k.field_71466_p.func_78261_a("?", button.field_146128_h + button.func_146117_b() - 5, button.field_146129_i, -1711276033);
            this.field_146297_k.field_71466_p.func_78264_a(flag);
        }
    }

    protected void RenderTooltipButtonMouseoverEffect(GuiButton button) {
        boolean flag = this.field_146297_k.field_71466_p.func_82883_a();
        this.field_146297_k.field_71466_p.func_78264_a(true);
        this.field_146297_k.field_71466_p.func_78261_a("\u00a7b?", button.field_146128_h + button.func_146117_b() - 5, button.field_146129_i, 0xFFFFFF);
        this.field_146297_k.field_71466_p.func_78264_a(flag);
    }

    protected void RenderTooltip(int x, int y, String tooltip) {
        String[] tooltipArray = this.ParseTooltipArrayFromString(tooltip);
        int tooltipWidth = this.GetTooltipWidth(tooltipArray);
        int tooltipHeight = this.GetTooltipHeight(tooltipArray);
        int tooltipX = x + this.tooltipXOffset;
        int tooltipY = y + this.tooltipYOffset;
        if (tooltipX > this.field_146294_l - tooltipWidth - 7) {
            tooltipX = this.field_146294_l - tooltipWidth - 7;
        }
        if (tooltipY > this.field_146295_m - tooltipHeight - 8) {
            tooltipY = this.field_146295_m - tooltipHeight - 8;
        }
        int innerAlpha = -267386864;
        this.func_73733_a(tooltipX, tooltipY - 1, tooltipX + tooltipWidth + 6, tooltipY, innerAlpha, innerAlpha);
        this.func_73733_a(tooltipX, tooltipY + tooltipHeight + 6, tooltipX + tooltipWidth + 6, tooltipY + tooltipHeight + 7, innerAlpha, innerAlpha);
        this.func_73733_a(tooltipX, tooltipY, tooltipX + tooltipWidth + 6, tooltipY + tooltipHeight + 6, innerAlpha, innerAlpha);
        this.func_73733_a(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight + 6, innerAlpha, innerAlpha);
        this.func_73733_a(tooltipX + tooltipWidth + 6, tooltipY, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6, innerAlpha, innerAlpha);
        int outerAlpha1 = 0x505000FF;
        int outerAlpha2 = (outerAlpha1 & 0xFEFEFE) >> 1 | outerAlpha1 & 0xFF000000;
        this.func_73733_a(tooltipX, tooltipY + 1, tooltipX + 1, tooltipY + tooltipHeight + 6 - 1, outerAlpha1, outerAlpha2);
        this.func_73733_a(tooltipX + tooltipWidth + 5, tooltipY + 1, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6 - 1, outerAlpha1, outerAlpha2);
        this.func_73733_a(tooltipX, tooltipY, tooltipX + tooltipWidth + 3, tooltipY + 1, outerAlpha1, outerAlpha1);
        this.func_73733_a(tooltipX, tooltipY + tooltipHeight + 5, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6, outerAlpha2, outerAlpha2);
        int lineCount = 0;
        for (String s : tooltipArray) {
            this.field_146297_k.field_71466_p.func_78261_a(s, tooltipX + 2, tooltipY + 2 + lineCount * 11, 0xFFFFFF);
            ++lineCount;
        }
    }

    protected String[] ParseTooltipArrayFromString(String s) {
        s = this.DecodeStringCodes(s);
        String[] tooltipSections = s.split(this.tooltipNewlineDelimeter);
        ArrayList<String> tooltipArrayList = new ArrayList<String>();
        for (String section : tooltipSections) {
            String tooltip = "";
            String[] tooltipWords = section.split(" ");
            for (int i = 0; i < tooltipWords.length; ++i) {
                int lineWidthWithNextWord = this.field_146297_k.field_71466_p.func_78256_a(tooltip + tooltipWords[i]);
                if (lineWidthWithNextWord > this.tooltipMaxWidth) {
                    tooltipArrayList.add(tooltip.trim());
                    tooltip = tooltipWords[i] + " ";
                    continue;
                }
                tooltip = tooltip + tooltipWords[i] + " ";
            }
            tooltipArrayList.add(tooltip.trim());
        }
        String[] tooltipArray = new String[tooltipArrayList.size()];
        tooltipArrayList.toArray(tooltipArray);
        return tooltipArray;
    }

    private String DecodeStringCodes(String s) {
        return s.replace("_0", "\u00a70").replace("_1", "\u00a71").replace("_2", "\u00a72").replace("_3", "\u00a73").replace("_4", "\u00a74").replace("_5", "\u00a75").replace("_6", "\u00a76").replace("_7", "\u00a77").replace("_8", "\u00a78").replace("_9", "\u00a79").replace("_a", "\u00a7a").replace("_b", "\u00a7b").replace("_c", "\u00a7c").replace("_d", "\u00a7d").replace("_e", "\u00a7e").replace("_f", "\u00a7f").replace("_k", "\u00a7k").replace("_l", "\u00a7l").replace("_m", "\u00a7m").replace("_n", "\u00a7n").replace("_o", "\u00a7o").replace("_r", "\u00a7r");
    }

    private int GetTooltipWidth(String[] tooltipArray) {
        int longestWidth = 0;
        for (String s : tooltipArray) {
            int width = this.field_146297_k.field_71466_p.func_78256_a(s);
            if (width <= longestWidth) continue;
            longestWidth = width;
        }
        return longestWidth;
    }

    private int GetTooltipHeight(String[] tooltipArray) {
        int tooltipHeight = this.field_146297_k.field_71466_p.field_78288_b - 2;
        if (tooltipArray.length > 1) {
            tooltipHeight += (tooltipArray.length - 1) * 11;
        }
        return tooltipHeight;
    }

    public static <T, E> T GetFieldByReflection(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        Field field = null;
        for (String fieldName : fieldNames) {
            try {
                field = classToAccess.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field != null) break;
        }
        if (field != null) {
            field.setAccessible(true);
            Object fieldT = null;
            try {
                fieldT = field.get(instance);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return (T)fieldT;
        }
        return null;
    }

    public class FontCodes {
        public static final String BLACK = "\u00a70";
        public static final String DARK_BLUE = "\u00a71";
        public static final String DARK_GREEN = "\u00a72";
        public static final String DARK_AQUA = "\u00a73";
        public static final String DARK_RED = "\u00a74";
        public static final String DARK_PURPLE = "\u00a75";
        public static final String GOLD = "\u00a76";
        public static final String GRAY = "\u00a77";
        public static final String DARK_GREY = "\u00a78";
        public static final String BLUE = "\u00a79";
        public static final String GREEN = "\u00a7a";
        public static final String AQUA = "\u00a7b";
        public static final String RED = "\u00a7c";
        public static final String LIGHT_PURPLE = "\u00a7d";
        public static final String YELLOW = "\u00a7e";
        public static final String WHITE = "\u00a7f";
        public static final String OBFUSCATED = "\u00a7k";
        public static final String BOLD = "\u00a7l";
        public static final String STRIKETHROUGH = "\u00a7m";
        public static final String UNDERLINE = "\u00a7n";
        public static final String ITALICS = "\u00a7o";
        public static final String RESET = "\u00a7r";
    }
}

