/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.features;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.text.WordUtils;

public enum FeatureFlags {
    SEPARATE_HARDWARE_SAMPLERS(() -> true, () -> true),
    PER_BUFFER_BLENDING(() -> true, RenderSystem::supportsBufferBlending),
    COMPUTE_SHADERS(() -> true, RenderSystem::supportsCompute),
    ENTITY_TRANSLUCENT(() -> true, () -> true),
    UNKNOWN(() -> false, () -> false);

    private final BooleanSupplier irisRequirement;
    private final BooleanSupplier hardwareRequirement;

    private FeatureFlags(BooleanSupplier irisRequirement, BooleanSupplier hardwareRequirement) {
        this.irisRequirement = irisRequirement;
        this.hardwareRequirement = hardwareRequirement;
    }

    public static String getInvalidStatus(List<FeatureFlags> invalidFeatureFlags) {
        FeatureFlags[] flags;
        boolean unsupportedHardware = false;
        boolean unsupportedIris = false;
        for (FeatureFlags flag : flags = invalidFeatureFlags.toArray(new FeatureFlags[0])) {
            unsupportedIris |= !flag.irisRequirement.getAsBoolean();
            unsupportedHardware |= !flag.hardwareRequirement.getAsBoolean();
        }
        if (unsupportedIris) {
            if (unsupportedHardware) {
                return I18n.func_135052_a((String)"iris.unsupported.irisorpc", (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)"iris.unsupported.iris", (Object[])new Object[0]);
        }
        if (unsupportedHardware) {
            return I18n.func_135052_a((String)"iris.unsupported.pc", (Object[])new Object[0]);
        }
        return null;
    }

    public String getHumanReadableName() {
        return WordUtils.capitalize((String)this.name().replace("_", " ").toLowerCase());
    }

    public boolean isUsable() {
        return this.irisRequirement.getAsBoolean() && this.hardwareRequirement.getAsBoolean();
    }

    public static boolean isInvalid(String name) {
        try {
            return !FeatureFlags.valueOf(name).isUsable();
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public static FeatureFlags getValue(String value) {
        try {
            return FeatureFlags.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}

