/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.taumc.glsl;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum BuiltinFunction {
    BOOL(3, "false"),
    BVEC2(6, "bvec2(false)"),
    BVEC3(7, "bvec3(false)"),
    BVEC4(8, "bvec4(false)"),
    DOUBLE(29, "0.0d"),
    DVEC2(30, "dvec2(0.0d)"),
    DVEC3(31, "dvec3(0.0d)"),
    DVEC4(32, "dvec4(0.0d)"),
    DMAT2(16, "dmat2(0.0d)"),
    DMAT2X2(17, "dmat2x2(0.0d)"),
    DMAT2X3(18, "dmat2x3(0.0d)"),
    DMAT2X4(19, "dmat2x4(0.0d)"),
    DMAT3(20, "dmat3(0.0d)"),
    DMAT3X2(21, "dmat3x2(0.0d)"),
    DMAT3X3(22, "dmat3x3(0.0d)"),
    DMAT3X4(23, "dmat3x4(0.0d)"),
    DMAT4(24, "dmat4(0.0d)"),
    DMAT4X2(25, "dmat4x2(0.0d)"),
    DMAT4X3(26, "dmat4x3(0.0d)"),
    DMAT4X4(27, "dmat4x4(0.0d)"),
    FLOAT(36, "0.0f"),
    VEC2(196, "vec2(0.0f)"),
    VEC3(197, "vec3(0.0f)"),
    VEC4(198, "vec4(0.0f)"),
    MAT2(95, "mat2(0.0f)"),
    MAT2X2(96, "mat2x2(0.0f)"),
    MAT2X3(97, "mat2x3(0.0f)"),
    MAT2X4(98, "mat2x4(0.0f)"),
    MAT3(99, "mat3(0.0f)"),
    MAT3X2(100, "mat3x2(0.0f)"),
    MAT3X3(101, "mat3x3(0.0f)"),
    MAT3X4(102, "mat3x4(0.0f)"),
    MAT4(103, "mat4(0.0f)"),
    MAT4X2(104, "mat4x2(0.0f)"),
    MAT4X3(105, "mat4x3(0.0f)"),
    MAT4X4(106, "mat4x4(0.0f)"),
    INT(64, "0"),
    IVEC2(90, "ivec2(0)"),
    IVEC3(91, "ivec3(0)"),
    IVEC4(92, "ivec4(0)"),
    UINT(166, "0u"),
    UVEC2(192, "uvec2(0u)"),
    UVEC3(193, "uvec3(0u)"),
    UVEC4(194, "uvec4(0u)");

    private final String initializer;
    private final int type;
    private static final Map<Integer, BuiltinFunction> BY_TYPE;

    private BuiltinFunction(int type, String initializer) {
        this.type = type;
        this.initializer = initializer;
    }

    public int getType() {
        return this.type;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public static BuiltinFunction getByType(int type) {
        return BY_TYPE.get(type);
    }

    static {
        BY_TYPE = Arrays.stream(BuiltinFunction.values()).collect(Collectors.toMap(BuiltinFunction::getType, b -> b));
    }
}

