/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.api.IControllable;
import com.flansmod.client.ClientProxy;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.gui.GuiDriveableController;
import com.flansmod.client.gui.GuiTeamScores;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.Team;
import com.flansmod.common.types.InfoType;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityAuraFX;
import net.minecraft.client.particle.EntityBlockDustFX;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityBubbleFX;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityCritFX;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.client.particle.EntityEnchantmentTableParticleFX;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityFishWakeFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityFootStepFX;
import net.minecraft.client.particle.EntityHeartFX;
import net.minecraft.client.particle.EntityHugeExplodeFX;
import net.minecraft.client.particle.EntityLargeExplodeFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.client.particle.EntityNoteFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySnowShovelFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.particle.EntitySplashFX;
import net.minecraft.client.particle.EntitySuspendFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class FlansModClient
extends FlansMod {
    public static boolean doneTutorial = false;
    public static boolean controlModeMouse = true;
    public static int controlModeSwitchTimer = 20;
    public static int shootTimeLeft;
    public static int shootTimeRight;
    public static float playerRecoil;
    public static float antiRecoil;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsRight;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsLeft;
    public static int scopeTime;
    public static IScope currentScope;
    public static float zoomProgress;
    public static float lastZoomProgress;
    public static float lastZoomLevel;
    public static float lastFOVZoomLevel;
    public static float originalMouseSensitivity;
    public static float originalFOV;
    public static int originalThirdPerson;
    public static boolean inPlane;
    public static PacketTeamInfo teamInfo;
    public static int teamsScoreGUILock;
    public static Minecraft minecraft;

    public void load() {
        FlansModClient.log("Loading Flan's mod client side.");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderOffHandGun(RenderPlayerEvent.Specials.Post event) {
        RenderPlayer renderer = event.renderer;
        EntityPlayer player = event.entityPlayer;
        float dt = event.partialRenderTick;
        PlayerData data = PlayerHandler.getPlayerData(player, Side.CLIENT);
        ItemStack gunStack = null;
        if (player instanceof EntityOtherPlayerMP) {
            gunStack = data.offHandGunStack;
        } else {
            ItemStack currentStack = player.func_71045_bC();
            if (currentStack == null || !(currentStack.func_77973_b() instanceof ItemGun) || !((ItemGun)currentStack.func_77973_b()).type.oneHanded || data.offHandGunSlot == 0) {
                return;
            }
            gunStack = player.field_71071_by.func_70301_a(data.offHandGunSlot - 1);
        }
        if (gunStack == null || !(gunStack.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)gunStack.func_77973_b()).type;
        GL11.glPushMatrix();
        renderer.field_77109_a.field_78113_g.func_78794_c(0.0625f);
        GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
        float f2 = 1.0f;
        GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
        GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
        int k = gunStack.func_77973_b().func_82790_a(gunStack, 0);
        float f11 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f12 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f11, (float)f12, (float)f3, (float)1.0f);
        ClientProxy.gunRenderer.renderOffHandGun(player, gunStack);
        GL11.glPopMatrix();
    }

    private float interpolateRotation(float x, float y, float dT) {
        float f3;
        for (f3 = y - x; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return x + dT * f3;
    }

    @SubscribeEvent
    public void renderLiving(RenderPlayerEvent.Pre event) {
        PlayerData data = PlayerHandler.getPlayerData(event.entityPlayer, Side.CLIENT);
        if (FlansMod.DEBUG && data != null && data.snapshots[0] != null) {
            data.snapshots[0].renderSnapshot();
        }
        RendererLivingEntity.NAME_TAG_RANGE = 64.0f;
        RendererLivingEntity.NAME_TAG_RANGE_SNEAK = 32.0f;
        if (event.entity instanceof EntityPlayer && teamInfo != null) {
            if (PacketTeamInfo.gametype != null) {
                if (!"No Gametype".equals(PacketTeamInfo.gametype)) {
                    Team thePlayerTeam;
                    PacketTeamInfo.PlayerScoreData rendering = PacketTeamInfo.getPlayerScoreData(event.entity.func_70005_c_());
                    PacketTeamInfo.PlayerScoreData thePlayer = PacketTeamInfo.getPlayerScoreData(FlansModClient.minecraft.field_71439_g.func_70005_c_());
                    Team renderingTeam = rendering == null ? Team.spectators : rendering.team.team;
                    Team team = thePlayerTeam = thePlayer == null ? Team.spectators : thePlayer.team.team;
                    if (data.skin == null) {
                        data.skin = ((AbstractClientPlayer)event.entityPlayer).func_110306_p();
                    }
                    if (data.skin != null) {
                        ResourceLocation skin = rendering == null || rendering.playerClass == null ? null : FlansModResourceHandler.getTexture(rendering.playerClass);
                        ((AbstractClientPlayer)event.entityPlayer).func_152121_a(MinecraftProfileTexture.Type.SKIN, skin == null ? data.skin : skin);
                    }
                    if (thePlayerTeam == Team.spectators) {
                        return;
                    }
                    if (renderingTeam == Team.spectators) {
                        event.setCanceled(true);
                        return;
                    }
                    if (renderingTeam != thePlayerTeam) {
                        RendererLivingEntity.NAME_TAG_RANGE = 0.0f;
                        RendererLivingEntity.NAME_TAG_RANGE_SNEAK = 0.0f;
                        return;
                    }
                    if (!PacketTeamInfo.sortedByTeam) {
                        RendererLivingEntity.NAME_TAG_RANGE = 0.0f;
                        RendererLivingEntity.NAME_TAG_RANGE_SNEAK = 0.0f;
                    }
                }
            }
        }
    }

    public static int shootTime(boolean left) {
        return left ? shootTimeLeft : shootTimeRight;
    }

    public static void tick() {
        if (FlansModClient.minecraft.field_71439_g == null || FlansModClient.minecraft.field_71441_e == null) {
            return;
        }
        if (FlansModClient.minecraft.field_71439_g.field_70154_o instanceof IControllable && FlansModClient.minecraft.field_71462_r == null) {
            minecraft.func_147108_a((GuiScreen)new GuiDriveableController((IControllable)FlansModClient.minecraft.field_71439_g.field_70154_o));
        }
        if (teamInfo != null) {
            if (PacketTeamInfo.timeLeft > 0) {
                --PacketTeamInfo.timeLeft;
            }
        }
        if (teamsScoreGUILock > 0) {
            --teamsScoreGUILock;
            if (FlansModClient.minecraft.field_71462_r == null) {
                minecraft.func_147108_a((GuiScreen)new GuiTeamScores());
            }
        }
        if (shootTimeLeft > 0) {
            --shootTimeLeft;
        }
        if (shootTimeRight > 0) {
            --shootTimeRight;
        }
        if (scopeTime > 0) {
            --scopeTime;
        }
        if (playerRecoil > 0.0f) {
            playerRecoil *= 0.8f;
        }
        FlansModClient.minecraft.field_71439_g.field_70125_A -= playerRecoil;
        FlansModClient.minecraft.field_71439_g.field_70125_A += (antiRecoil += playerRecoil) * 0.2f;
        antiRecoil *= 0.8f;
        for (GunAnimations g : gunAnimationsRight.values()) {
            g.update();
        }
        for (GunAnimations g : gunAnimationsLeft.values()) {
            g.update();
        }
        for (GunAnimations obj : FlansModClient.minecraft.field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)obj;
            ItemStack currentItem = player.func_71045_bC();
            if (currentItem == null || !(currentItem.func_77973_b() instanceof ItemGun)) continue;
            if (player == FlansModClient.minecraft.field_71439_g && FlansModClient.minecraft.field_71474_y.field_74320_O == 0) {
                player.func_71041_bz();
                continue;
            }
            player.func_71008_a(currentItem, 100);
        }
        Item itemInHand = null;
        ItemStack itemstackInHand = FlansModClient.minecraft.field_71439_g.field_71071_by.func_70448_g();
        if (itemstackInHand != null) {
            itemInHand = itemstackInHand.func_77973_b();
        }
        if (!(currentScope == null || itemInHand != null && itemInHand instanceof ItemGun && ((ItemGun)itemInHand).type.getCurrentScope(itemstackInHand) == currentScope)) {
            currentScope = null;
            FlansModClient.minecraft.field_71474_y.field_74334_X = originalFOV;
            FlansModClient.minecraft.field_71474_y.field_74341_c = originalMouseSensitivity;
            FlansModClient.minecraft.field_71474_y.field_74320_O = originalThirdPerson;
        }
        lastZoomProgress = zoomProgress;
        zoomProgress = currentScope == null ? (zoomProgress *= 0.66f) : 1.0f - (1.0f - zoomProgress) * 0.66f;
        if (FlansModClient.minecraft.field_71439_g.field_70154_o instanceof IControllable) {
            inPlane = true;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(((IControllable)FlansModClient.minecraft.field_71439_g.field_70154_o).getPlayerRoll()), (String[])new String[]{"camRoll", "R", "field_78495_O"});
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
            if (FlansModClient.minecraft.field_71439_g.field_70154_o instanceof IControllable) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(((IControllable)FlansModClient.minecraft.field_71439_g.field_70154_o).getCameraDistance()), (String[])new String[]{"thirdPersonDistance", "E", "field_78490_B"});
                }
                catch (Exception e) {
                    FlansModClient.log("I forgot to update obfuscated reflection D:");
                    throw new RuntimeException(e);
                }
            }
        } else if (inPlane) {
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(0.0f), (String[])new String[]{"camRoll", "R", "field_78495_O"});
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(4.0f), (String[])new String[]{"thirdPersonDistance", "E", "field_78490_B"});
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
            inPlane = false;
        }
        if (controlModeSwitchTimer > 0) {
            --controlModeSwitchTimer;
        }
    }

    public static void renderTick(float smoothing) {
        if (Math.abs(zoomProgress - lastZoomProgress) > 1.0E-4f) {
            float actualZoomProgress = lastZoomProgress + (zoomProgress - lastZoomProgress) * smoothing;
            float botchedZoomProgress = zoomProgress > 0.8f ? 1.0f : 0.0f;
            double zoomLevel = botchedZoomProgress * lastZoomLevel + (1.0f - botchedZoomProgress);
            float FOVZoomLevel = actualZoomProgress * lastFOVZoomLevel + (1.0f - actualZoomProgress);
            if (Math.abs(zoomLevel - 1.0) < (double)0.01f) {
                zoomLevel = 1.0;
            }
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)zoomLevel, (String[])new String[]{"cameraZoom", "af", "field_78503_V"});
                FlansModClient.minecraft.field_71474_y.field_74334_X = ((originalFOV * 40.0f + 70.0f) / FOVZoomLevel - 70.0f) / 40.0f;
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void chatMessage(ClientChatReceivedEvent event) {
        if (event.message.func_150260_c().equals("#flansmod")) {
            event.setCanceled(true);
        }
    }

    private boolean checkFileExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                FlansMod.log("Failed to create file");
                FlansMod.log(file.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public static boolean flipControlMode() {
        if (controlModeSwitchTimer > 0) {
            return false;
        }
        controlModeMouse = !controlModeMouse;
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)(controlModeMouse ? new GuiDriveableController((IControllable)FMLClientHandler.instance().getClient().field_71439_g.field_70154_o) : null));
        controlModeSwitchTimer = 40;
        return true;
    }

    public static void reloadModels(boolean reloadSkins) {
        for (InfoType type : InfoType.infoTypes) {
            type.reloadModel();
        }
        if (reloadSkins) {
            proxy.forceReload();
        }
    }

    public static Team getTeam(int spawnerTeamID) {
        if (teamInfo == null) {
            return null;
        }
        return teamInfo.getTeam(spawnerTeamID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCurrentMap(String map) {
        if (teamInfo == null) return false;
        if (PacketTeamInfo.mapShortName == null) return false;
        if (!PacketTeamInfo.mapShortName.equals(map)) return false;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityFX getParticle(String s, World w, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityHugeExplodeFX fx = null;
        if (s.equals("hugeexplosion")) {
            fx = new EntityHugeExplodeFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("largeexplode")) {
            fx = new EntityLargeExplodeFX(mc.field_71446_o, w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("fireworksSpark")) {
            fx = new EntityFireworkSparkFX(w, x, y, z, 0.0, 0.0, 0.0, mc.field_71452_i);
        } else if (s.equals("bubble")) {
            fx = new EntityBubbleFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("suspended")) {
            fx = new EntitySuspendFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("depthsuspend")) {
            fx = new EntityAuraFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("townaura")) {
            fx = new EntityAuraFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("crit")) {
            fx = new EntityCritFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("magicCrit")) {
            fx = new EntityCritFX(w, x, y, z, 0.0, 0.0, 0.0);
            fx.func_70538_b(fx.func_70534_d() * 0.3f, fx.func_70542_f() * 0.8f, fx.func_70535_g());
            fx.func_94053_h();
        } else if (s.equals("smoke")) {
            fx = new EntitySmokeFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("mobSpell")) {
            fx = new EntitySpellParticleFX(w, x, y, z, 0.0, 0.0, 0.0);
            fx.func_70538_b(0.0f, 0.0f, 0.0f);
        } else if (s.equals("mobSpellAmbient")) {
            fx = new EntitySpellParticleFX(w, x, y, z, 0.0, 0.0, 0.0);
            fx.func_82338_g(0.15f);
            fx.func_70538_b(0.0f, 0.0f, 0.0f);
        } else if (s.equals("spell")) {
            fx = new EntitySpellParticleFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("instantSpell")) {
            fx = new EntitySpellParticleFX(w, x, y, z, 0.0, 0.0, 0.0);
            ((EntitySpellParticleFX)fx).func_70589_b(144);
        } else if (s.equals("witchMagic")) {
            fx = new EntitySmokeFX(w, x, y, z, 0.0, 0.0, 0.0);
            ((EntitySpellParticleFX)fx).func_70589_b(144);
            float f = w.field_73012_v.nextFloat() * 0.5f + 0.35f;
            fx.func_70538_b(1.0f * f, 0.0f * f, 1.0f * f);
        } else if (s.equals("note")) {
            fx = new EntityNoteFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("portal")) {
            fx = new EntityPortalFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("enchantmenttable")) {
            fx = new EntityEnchantmentTableParticleFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("explode")) {
            fx = new EntityExplodeFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("flame")) {
            fx = new EntityFlameFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("lava")) {
            fx = new EntityLavaFX(w, x, y, z);
        } else if (s.equals("footstep")) {
            fx = new EntityFootStepFX(mc.field_71446_o, w, x, y, z);
        } else if (s.equals("splash")) {
            fx = new EntitySplashFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("wake")) {
            fx = new EntityFishWakeFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("largesmoke")) {
            fx = new EntitySmokeFX(w, x, y, z, 0.0, 0.0, 0.0, 2.5f);
        } else if (s.equals("cloud")) {
            fx = new EntityCloudFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("reddust")) {
            fx = new EntityReddustFX(w, x, y, z, 0.0f, 0.0f, 0.0f);
        } else if (s.equals("snowballpoof")) {
            fx = new EntityBreakingFX(w, x, y, z, Items.field_151126_ay);
        } else if (s.equals("dripWater")) {
            fx = new EntityDropParticleFX(w, x, y, z, Material.field_151586_h);
        } else if (s.equals("dripLava")) {
            fx = new EntityDropParticleFX(w, x, y, z, Material.field_151587_i);
        } else if (s.equals("snowshovel")) {
            fx = new EntitySnowShovelFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("slime")) {
            fx = new EntityBreakingFX(w, x, y, z, Items.field_151123_aH);
        } else if (s.equals("heart")) {
            fx = new EntityHeartFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("angryVillager")) {
            fx = new EntityHeartFX(w, x, y, z, 0.0, 0.0, 0.0);
            fx.func_70536_a(81);
            fx.func_70538_b(1.0f, 1.0f, 1.0f);
        } else if (s.equals("happyVillager")) {
            fx = new EntityAuraFX(w, x, y, z, 0.0, 0.0, 0.0);
            fx.func_70536_a(82);
            fx.func_70538_b(1.0f, 1.0f, 1.0f);
        } else if (s.equals("snowshovel")) {
            fx = new EntitySnowShovelFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("snowshovel")) {
            fx = new EntitySnowShovelFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.equals("snowshovel")) {
            fx = new EntitySnowShovelFX(w, x, y, z, 0.0, 0.0, 0.0);
        } else if (s.startsWith("iconcrack_")) {
            String[] astring = s.split("_", 3);
            int j = Integer.parseInt(astring[1]);
            if (astring.length > 2) {
                int k = Integer.parseInt(astring[2]);
                fx = new EntityBreakingFX(w, x, y, z, 0.0, 0.0, 0.0, Item.func_150899_d((int)j), k);
            } else {
                fx = new EntityBreakingFX(w, x, y, z, 0.0, 0.0, 0.0, Item.func_150899_d((int)j), 0);
            }
        } else if (s.startsWith("blockcrack_")) {
            String[] astring = s.split("_", 3);
            Block block = Block.func_149729_e((int)Integer.parseInt(astring[1]));
            int k = Integer.parseInt(astring[2]);
            fx = new EntityDiggingFX(w, x, y, z, 0.0, 0.0, 0.0, block, k).func_90019_g(k);
        } else if (s.startsWith("blockdust_")) {
            String[] astring = s.split("_", 3);
            Block block = Block.func_149729_e((int)Integer.parseInt(astring[1]));
            int k = Integer.parseInt(astring[2]);
            fx = new EntityBlockDustFX(w, x, y, z, 0.0, 0.0, 0.0, block, k).func_90019_g(k);
        }
        if (mc.field_71474_y.field_74347_j) {
            fx.field_70155_l = 200.0;
        }
        if (fx != null) {
            mc.field_71452_i.func_78873_a((EntityFX)fx);
        }
        return fx;
    }

    public static GunAnimations getGunAnimations(EntityLivingBase living, boolean offHand) {
        GunAnimations animations = null;
        if (offHand) {
            if (gunAnimationsLeft.containsKey(living)) {
                animations = gunAnimationsLeft.get(living);
            } else {
                animations = new GunAnimations();
                gunAnimationsLeft.put(living, animations);
            }
        } else if (gunAnimationsRight.containsKey(living)) {
            animations = gunAnimationsRight.get(living);
        } else {
            animations = new GunAnimations();
            gunAnimationsRight.put(living, animations);
        }
        return animations;
    }

    static {
        gunAnimationsRight = new HashMap();
        gunAnimationsLeft = new HashMap();
        currentScope = null;
        zoomProgress = 0.0f;
        lastZoomProgress = 0.0f;
        lastZoomLevel = 1.0f;
        lastFOVZoomLevel = 1.0f;
        originalMouseSensitivity = 0.5f;
        originalFOV = 90.0f;
        originalThirdPerson = 0;
        inPlane = false;
        teamsScoreGUILock = 0;
        minecraft = FMLClientHandler.instance().getClient();
    }
}

