/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Sign;
import gollorum.signpost.util.code.MinecraftIndependent;
import gollorum.signpost.util.collections.Lurchsauna;
import gollorum.signpost.worldGen.villages.LibraryHelper;
import gollorum.signpost.worldGen.villages.VillagePost;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@MinecraftIndependent
class LibraryWaystoneHelper
extends LibraryHelper {
    private MyBlockPos waystoneLocation;
    private Map<MyBlockPos, Set<VillagePost>> villagePosts;

    LibraryWaystoneHelper(MyBlockPos villageLocation, Map<MyBlockPos, Set<VillagePost>> villagePosts, MyBlockPos waystoneLocation) {
        super(villageLocation);
        this.villagePosts = villagePosts;
        this.waystoneLocation = waystoneLocation;
    }

    void enscribeEmptySign() {
        SPEventHandler.scheduleTask(new BoolRun(){
            boolean go = false;

            @Override
            public boolean run() {
                if (!this.go) {
                    this.go = true;
                    return false;
                }
                try {
                    Set posts = LibraryWaystoneHelper.this.fetchOtherVillagesPosts();
                    SignChooser.SingeEmptySign emptySign = new SignChooser(posts).getBestSign();
                    if (emptySign != null) {
                        MyBlockPos pos = emptySign.post.getTopSignPosition();
                        Sign sign = SuperPostPost.getSuperTile(pos).getEmptySigns().get(0);
                        if (pos.getTile() instanceof SuperPostPostTile && ((SuperPostPostTile)pos.getTile()).isLoading()) {
                            return false;
                        }
                        sign.base = LibraryWaystoneHelper.this.getBaseInfo(LibraryWaystoneHelper.this.waystoneLocation);
                        sign.point = true;
                        if (LibraryWaystoneHelper.this.angleTooLarge(LibraryWaystoneHelper.this.calcRot(pos, LibraryWaystoneHelper.this.waystoneLocation), emptySign.post.desiredRotation)) {
                            emptySign.sign.flip = true;
                        }
                        SuperPostPost.updateServer(pos);
                        return true;
                    }
                    return true;
                }
                catch (Exception e) {
                    return true;
                }
            }
        });
    }

    private Set<VillagePost> fetchOtherVillagesPosts() {
        Lurchsauna<VillagePost> posts = new Lurchsauna<VillagePost>();
        for (Map.Entry<MyBlockPos, Set<VillagePost>> entry : this.villagePosts.entrySet()) {
            if (entry.getKey().equals(this.villageLocation) || this.containsMeAsTarget(entry.getValue())) continue;
            posts.addAll(entry.getValue());
        }
        return posts;
    }

    private boolean containsMeAsTarget(Set<VillagePost> posts) {
        for (VillagePost post : posts) {
            for (Sign sign : post.getSigns()) {
                if (sign == null || !sign.isValid() || sign.base == null || sign.base.blockPos == null || !sign.base.blockPos.equals(this.waystoneLocation)) continue;
                return true;
            }
        }
        return false;
    }

    private class SignChooser {
        private List<VillageSign> signs = new LinkedList<VillageSign>();

        public SignChooser(Set<VillagePost> posts) {
            this.fetchSigns(posts);
        }

        public SingeEmptySign getBestSign() {
            this.sort();
            if (this.signs.size() > 0) {
                for (VillageSign sign : this.signs) {
                    MyBlockPos pos;
                    List<Sign> postSigns;
                    if (sign == null || sign.post == null || (postSigns = sign.signs).size() == 0 || (pos = sign.post.getTopSignPosition()) == null || SuperPostPost.getSuperTile(pos) == null) continue;
                    try {
                        SuperPostPost.getSuperTile(pos).getEmptySigns().get(0);
                        return new SingeEmptySign(postSigns.get(0), sign.post);
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return null;
        }

        private void fetchSigns(Set<VillagePost> posts) {
            for (VillagePost post : posts) {
                List<Sign> signs = this.getEmptySigns(post);
                if (signs.isEmpty()) continue;
                this.signs.add(new VillageSign(new VillagePost(post.getTopSignPosition(), post.desiredRotation), signs));
            }
        }

        private void sort() {
            this.sortDistance();
            this.sortSignCount();
        }

        private void sortDistance() {
            this.signs.sort(new Comparator<VillageSign>(){

                @Override
                public int compare(VillageSign sign1, VillageSign sign2) {
                    return LibraryWaystoneHelper.this.compareClosest(sign1.post.getTopSignPosition(), sign2.post.getTopSignPosition(), LibraryWaystoneHelper.this.villageLocation);
                }
            });
        }

        private void sortSignCount() {
            this.signs.sort(new Comparator<VillageSign>(){

                @Override
                public int compare(VillageSign sign1, VillageSign sign2) {
                    return new Integer(sign2.signs.size()).compareTo(sign1.signs.size());
                }
            });
        }

        private List<Sign> getEmptySigns(VillagePost post) {
            List<Sign> signs = post.getSigns();
            LinkedList<Sign> ret = new LinkedList<Sign>();
            for (Sign now : signs) {
                if (now.base != null && now.base.hasName()) continue;
                ret.add(now);
            }
            return ret;
        }

        public class SingeEmptySign {
            public Sign sign;
            public VillagePost post;

            public SingeEmptySign(Sign sign, VillagePost post) {
                this.sign = sign;
                this.post = post;
            }
        }

        private class VillageSign {
            public VillagePost post;
            public List<Sign> signs;

            public VillageSign(VillagePost post, List<Sign> signs) {
                this.post = post;
                this.signs = signs;
            }
        }
    }
}

