/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util.math.tracking;

import gollorum.signpost.util.math.tracking.Body;
import gollorum.signpost.util.math.tracking.DDDVector;
import gollorum.signpost.util.math.tracking.Rectangle;

public class Cuboid
extends Body {
    public Cuboid(DDDVector pos, DDDVector edges, DDDVector rotation) {
        super(6);
        DDDVector xEdge = edges.xVec().rotate(rotation);
        DDDVector yEdge = edges.yVec().rotate(rotation);
        DDDVector zEdge = edges.zVec().rotate(rotation);
        this.add(new Rectangle(pos, xEdge, yEdge));
        this.add(new Rectangle(pos, xEdge, zEdge));
        this.add(new Rectangle(pos, yEdge, zEdge));
        pos = pos.add(xEdge).add(yEdge).add(zEdge);
        xEdge = xEdge.neg();
        yEdge = yEdge.neg();
        zEdge = zEdge.neg();
        this.add(new Rectangle(pos, xEdge, yEdge));
        this.add(new Rectangle(pos, xEdge, zEdge));
        this.add(new Rectangle(pos, yEdge, zEdge));
    }

    public Cuboid(DDDVector pos, DDDVector edges, double rotation) {
        this(pos, edges, new DDDVector(0.0, rotation, 0.0));
    }

    public Cuboid(DDDVector pos, DDDVector edges, double rotation, DDDVector rotationOffset) {
        this(rotationOffset.add(pos.substract(rotationOffset).rotY(rotation + Math.PI)), edges, rotation);
    }
}

