/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.gui.SignInput;
import gollorum.signpost.gui.SignInputBox;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendPostBasesMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.awt.Color;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class SignGuiPost
extends GuiScreen
implements SignInput {
    private SignInputBox base1InputBox;
    private SignInputBox base2InputBox;
    private String std1 = "";
    private int col1 = Color.black.getRGB();
    private boolean go1;
    private String std2 = "";
    private int col2 = Color.black.getRGB();
    private boolean go2;
    private PostPostTile tile;
    private boolean resetMouse;

    public SignGuiPost(PostPostTile tile) {
        this.tile = tile;
        this.func_73866_w_();
    }

    public void func_73866_w_() {
        this.setupInputBox1();
        this.setupInputBox2();
        this.resetMouse = true;
        this.base1InputBox.setFocused(true);
    }

    private void setupInputBox1() {
        DoubleBaseInfo tilebases = this.tile.getBases();
        this.base1InputBox = new SignInputBox(this.field_146289_q, this.field_146294_l / 2 - 68, this.field_146295_m / 2 - 46, 137, this);
        this.base1InputBox.setText(tilebases.sign1.base == null ? "" : tilebases.sign1.base.toString());
        this.go1 = true;
    }

    private void setupInputBox2() {
        DoubleBaseInfo tilebases = this.tile.getBases();
        this.base2InputBox = new SignInputBox(this.field_146289_q, this.field_146294_l / 2 - 68, this.field_146295_m / 2 + 40, 137, this);
        this.base2InputBox.setText(tilebases.sign2.base == null ? "" : tilebases.sign2.base.toString());
        this.go2 = true;
    }

    protected void func_73864_a(int x, int y, int bla) {
        super.func_73864_a(x, y, bla);
        this.base1InputBox.mouseClicked(x, y, bla);
        this.base2InputBox.mouseClicked(x, y, bla);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        try {
            if (this.field_146297_k == null) {
                this.field_146297_k = FMLClientHandler.instance().getClient();
            }
            if (this.base1InputBox == null) {
                this.setupInputBox1();
            }
            if (this.base2InputBox == null) {
                this.setupInputBox2();
            }
            this.func_146276_q_();
            this.base1InputBox.drawSignBox(this.field_146289_q);
            this.func_73732_a(this.field_146289_q, this.std2, this.field_146294_l / 2, this.base1InputBox.y + this.base1InputBox.height + 10, this.col2);
            this.base2InputBox.drawSignBox(this.field_146289_q);
            this.func_73732_a(this.field_146289_q, this.std1, this.field_146294_l / 2, this.base2InputBox.y + this.base2InputBox.height + 10, this.col1);
            if (this.resetMouse) {
                this.resetMouse = false;
                Mouse.setGrabbed((boolean)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        if (par1 == '\r') {
            if (this.base1InputBox.isFocused()) {
                if (!this.go2) {
                    this.go2 = true;
                    this.base1InputBox.textColor = Color.orange.getRGB();
                }
                this.base1InputBox.setFocused(false);
                this.base2InputBox.setFocused(true);
            } else if (this.base2InputBox.isFocused()) {
                if (!this.go1) {
                    this.go1 = true;
                    this.base2InputBox.textColor = Color.orange.getRGB();
                }
                this.field_146297_k.func_147108_a(null);
            } else {
                this.base1InputBox.setFocused(true);
            }
            return;
        }
        if (par1 == '\t') {
            if (this.base1InputBox.isFocused()) {
                this.base1InputBox.setFocused(false);
                this.base2InputBox.setFocused(true);
            } else if (this.base2InputBox.isFocused()) {
                this.base2InputBox.setFocused(false);
                this.base1InputBox.setFocused(true);
            } else {
                this.base1InputBox.setFocused(true);
            }
            return;
        }
        this.baseType(par1, par2, false);
        this.baseType(par1, par2, true);
    }

    private void baseType(char par1, int par2, boolean base2) {
        SignInputBox tf = base2 ? this.base2InputBox : this.base1InputBox;
        String before = tf.getText();
        if (tf.textboxKeyTyped(par1, par2) && !tf.getText().equals(before)) {
            if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                return;
            }
            this.onTextChange(tf);
        }
    }

    @Override
    public void onTextChange(SignInputBox box) {
        boolean base2 = box == this.base2InputBox;
        BaseInfo inf = PostHandler.getWSbyName(box.getText());
        MyBlockPos.Connection connect = this.tile.toPos().canConnectTo(inf);
        if (inf == null || !connect.equals((Object)MyBlockPos.Connection.VALID)) {
            box.textColor = Color.red.getRGB();
            if (connect.equals((Object)MyBlockPos.Connection.DIST)) {
                String out = LanguageRegistry.instance().getStringLocalization("signpost.guiTooFar");
                if (out.equals("")) {
                    out = LanguageRegistry.instance().getStringLocalization("signpost.guiTooFar", "en_US");
                }
                out = out.replaceAll("<distance>", "" + (int)this.tile.toPos().distance(inf.pos) + 1);
                out = out.replaceAll("<maxDist>", "" + ClientConfigStorage.INSTANCE.getMaxDist());
                if (base2) {
                    this.std1 = out;
                    this.col1 = Color.red.getRGB();
                    this.go1 = false;
                } else {
                    this.std2 = out;
                    this.col2 = Color.red.getRGB();
                    this.go2 = false;
                }
            } else if (connect.equals((Object)MyBlockPos.Connection.WORLD)) {
                String out = LanguageRegistry.instance().getStringLocalization("signpost.guiWorldDim");
                if (out.equals("")) {
                    out = LanguageRegistry.instance().getStringLocalization("signpost.guiWorldDim", "en_US");
                }
                if (base2) {
                    this.std1 = out;
                    this.col1 = Color.red.getRGB();
                    this.go1 = false;
                } else {
                    this.std2 = out;
                    this.col2 = Color.red.getRGB();
                    this.go2 = false;
                }
            } else if (base2) {
                this.std1 = "";
                this.col1 = Color.red.getRGB();
                this.go1 = false;
            } else {
                this.std2 = "";
                this.col2 = Color.red.getRGB();
                this.go2 = false;
            }
        } else {
            box.textColor = Color.black.getRGB();
            if (base2) {
                this.col1 = Color.white.getRGB();
                this.go1 = true;
            } else {
                this.col2 = Color.white.getRGB();
                this.go2 = true;
            }
            if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getCost() != null) {
                String out = LanguageRegistry.instance().getStringLocalization("signpost.guiPrev");
                if (out.equals("")) {
                    out = LanguageRegistry.instance().getStringLocalization("signpost.guiPrev", "en_US");
                }
                int distance = (int)this.tile.toPos().distance(inf.pos) + 1;
                out = out.replaceAll("<distance>", "" + distance);
                out = out.replaceAll("<amount>", Integer.toString(PostHandler.getStackSize(this.tile.toPos(), inf.pos)));
                out = out.replaceAll("<itemName>", ConfigHandler.costName());
                if (base2) {
                    this.col1 = Color.white.getRGB();
                    this.std1 = out;
                } else {
                    this.col2 = Color.white.getRGB();
                    this.std2 = out;
                }
            }
        }
    }

    public void func_146281_b() {
        DoubleBaseInfo tilebases = this.tile.getBases();
        tilebases.sign1.base = ClientConfigStorage.INSTANCE.deactivateTeleportation() || this.go2 ? PostHandler.getForceWSbyName(this.base1InputBox.getText()) : null;
        tilebases.sign2.base = ClientConfigStorage.INSTANCE.deactivateTeleportation() || this.go1 ? PostHandler.getForceWSbyName(this.base2InputBox.getText()) : null;
        NetworkHandler.netWrap.sendToServer((IMessage)new SendPostBasesMessage(this.tile, tilebases));
    }
}

