/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gollorum.signpost.BlockHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.WaystoneContainer;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.BaseUpdateServerMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.Sign;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public abstract class SuperPostPostTile
extends TileEntity
implements WaystoneContainer {
    public boolean isItem = false;
    public boolean isCanceled = false;
    public UUID owner;
    @Deprecated
    public boolean isWaystone = false;

    public SuperPostPostTile() {
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (SuperPostPostTile.this.func_145831_w() == null) {
                    return false;
                }
                SuperPostPostTile.this.isWaystone();
                return true;
            }
        });
    }

    public final MyBlockPos toPos() {
        return new MyBlockPos(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.dim());
    }

    public final int dim() {
        if (this.func_145831_w() == null || this.func_145831_w().field_73011_w == null) {
            return Integer.MIN_VALUE;
        }
        return this.func_145831_w().field_73011_w.field_76574_g;
    }

    public static final ResourceLocation stringToLoc(String str) {
        return str == null || str.equals("null") || str.equals("") ? null : new ResourceLocation(str);
    }

    public static final String locToString(ResourceLocation loc) {
        return loc == null ? "null" : loc.func_110624_b() + ":" + loc.func_110623_a();
    }

    public void onBlockDestroy(MyBlockPos pos) {
        if (this.isWaystone()) {
            this.destroyWaystone();
        }
    }

    public boolean isWaystone() {
        this.isWaystone = this.getBaseInfo() != null;
        return this.isWaystone;
    }

    public void destroyWaystone() {
        MyBlockPos pos = this.toPos();
        this.isWaystone = false;
        EntityItem item = new EntityItem(this.func_145831_w(), (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack((Block)BlockHandler.base, 1));
        this.func_145831_w().func_72838_d((Entity)item);
        BaseInfo base = PostHandler.getNativeWaystones().getByPos(pos);
        SPEventHandler.INSTANCE.updateWaystoneCount(this);
        if (PostHandler.getNativeWaystones().removeByPos(pos)) {
            MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.DESTROYED, this.func_145831_w(), base.pos.x, base.pos.y, base.pos.z, base == null ? "" : base.getName()));
            NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("signpostNBTVersion", 1);
        NBTTagCompound tagComp = new NBTTagCompound();
        if (this.owner != null) {
            tagComp.func_74778_a("PostOwner", this.owner.toString());
        }
        this.save(tagComp);
        tagCompound.func_74782_a("signpostDataTag", (NBTBase)tagComp);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74762_e("signpostNBTVersion") == 1) {
            NBTTagCompound tagComp = (NBTTagCompound)tagCompound.func_74781_a("signpostDataTag");
            String owner = tagComp.func_74779_i("PostOwner");
            try {
                this.owner = owner == null ? null : UUID.fromString(owner);
            }
            catch (Exception e) {
                this.owner = null;
            }
            this.load(tagComp);
        } else {
            this.load(tagCompound);
        }
    }

    public abstract void save(NBTTagCompound var1);

    public abstract void load(NBTTagCompound var1);

    public abstract Sign getSign(EntityPlayer var1);

    public abstract Paintable getPaintable(EntityPlayer var1);

    public abstract ResourceLocation getPostPaint();

    public abstract void setPostPaint(ResourceLocation var1);

    public abstract boolean isAwaitingPaint();

    public abstract Paintable getPaintObject();

    public abstract void setAwaitingPaint(boolean var1);

    public abstract void setPaintObject(Paintable var1);

    public abstract boolean isLoading();

    public abstract List<Sign> getEmptySigns();

    public SuperPostPost getSuperBlock() {
        return (SuperPostPost)this.func_145838_q();
    }

    @Override
    public BaseInfo getBaseInfo() {
        return PostHandler.getNativeWaystones().getByPos(this.toPos());
    }

    @Override
    public void setName(String name) {
        BaseInfo ws = this.getBaseInfo();
        ws.setName(name);
        NetworkHandler.netWrap.sendToServer((IMessage)new BaseUpdateServerMessage(ws, false));
    }

    @Override
    public String getName() {
        BaseInfo ws = this.getBaseInfo();
        return ws == null ? "null" : this.getBaseInfo().toString();
    }

    public int func_145832_p() {
        try {
            return super.func_145832_p();
        }
        catch (NullPointerException e) {
            System.out.println(this.getClass());
            return 0;
        }
    }
}

