/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.tiles.BaseModelPostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import java.util.UUID;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.MinecraftForge;

public class BaseModelPost
extends BlockContainer {
    public static final String[] allTypeNames = new String[]{"simple0", "simple1", "simple2", "detailed0", "detailed1", "aer", "dwarf", "ygnar"};
    public static final String[] allDefaultVillageTypeNames = new String[]{"simple0", "simple1", "simple2", "detailed0", "detailed1"};
    public static final int[] allTypeIds = new int[]{5, 6, 7, 0, 1, 2, 3, 4};
    public final ModelType type;

    public BaseModelPost(int typ) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149663_c("SignpostBase");
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149658_d("signpost:base");
        this.type = ModelType.values()[typ];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, l, 2);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer playerIn, int side, float hitX, float hitY, float hitZ) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            BaseInfo ws = BaseModelPost.getWaystoneRootTile(worldIn, x, y, z).getBaseInfo();
            if (ws == null) {
                ws = new BaseInfo(BasePost.generateName(), new MyBlockPos(worldIn, x, y, z, playerIn.field_71093_bK), playerIn.func_110124_au());
                PostHandler.addWaystone(ws);
            }
            if (!playerIn.func_70093_af()) {
                if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)playerIn, ws)) {
                    if (!ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)playerIn);
                    }
                    PostHandler.addDiscovered(playerIn.func_110124_au(), ws);
                }
            } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)playerIn, "" + ws.owner)) {
                NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, x, y, z), (EntityPlayerMP)playerIn);
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new BaseModelPostTile(this.type).setup();
    }

    public static BaseModelPostTile getWaystoneRootTile(World world, int x, int y, int z) {
        TileEntity ret = world.func_147438_o(x, y, z);
        if (ret instanceof BaseModelPostTile) {
            return (BaseModelPostTile)ret;
        }
        return null;
    }

    public static void placeServer(World world, MyBlockPos blockPos, EntityPlayerMP player) {
        MyBlockPos telePos = new MyBlockPos((Entity)player);
        BaseModelPostTile tile = BaseModelPost.getWaystoneRootTile(world, blockPos.x, blockPos.y, blockPos.z);
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            ws = new BaseInfo(name, blockPos, telePos, owner);
            PostHandler.addWaystone(ws);
        } else {
            ws.setAll(new BaseInfo(name, blockPos, telePos, owner));
        }
        PostHandler.addDiscovered(player.func_110124_au(), ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, blockPos.x, blockPos.y, blockPos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, blockPos.x, blockPos.y, blockPos.z), player);
    }

    public static void placeClient(World world, MyBlockPos blockPos, EntityPlayer player) {
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public static BaseModelPost[] createAll() {
        BaseModelPost[] ret = new BaseModelPost[ModelType.values().length];
        for (int i = 0; i < ModelType.values().length; ++i) {
            ret[i] = new BaseModelPost(i);
        }
        return ret;
    }

    public static enum ModelType {
        MODEL0(0),
        MODEL1(1),
        MODEL2(2),
        MODEL3(3),
        MODEL4(4),
        MODEL5(5),
        MODEL6(6),
        MODEL7(7);

        private int ID;
        public final String name;
        public IModelCustom MODEL;
        public final ResourceLocation TEXTURE;

        private ModelType(int i) {
            this(allTypeIds[i], allTypeNames[i]);
        }

        private ModelType(int ID, String name) {
            this(ID, name, new ResourceLocation("signpost:models/block/" + name + ".obj"), new ResourceLocation("signpost:textures/blocks/waystone.png"));
        }

        private ModelType(int ID, String name, final ResourceLocation model, ResourceLocation texture) {
            this.ID = ID;
            this.name = name;
            this.MODEL = null;
            if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT) || FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()) {
                SPEventHandler.scheduleTask(new BoolRun(){

                    @Override
                    public boolean run() {
                        try {
                            ModelType.this.MODEL = AdvancedModelLoader.loadModel((ResourceLocation)model);
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                });
            }
            this.TEXTURE = texture;
        }

        public String toString() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public static ModelType getByID(int ID) {
            for (ModelType now : ModelType.values()) {
                if (ID != now.ID) continue;
                return now;
            }
            return MODEL1;
        }

        public static ModelType getByName(String name) {
            for (ModelType now : ModelType.values()) {
                if (!name.equals(now.name)) continue;
                return now;
            }
            return MODEL1;
        }
    }
}

