/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import cpw.mods.fml.common.registry.GameRegistry;
import gollorum.signpost.blocks.BaseModelPost;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.BigPostPost;
import gollorum.signpost.blocks.ItemBlockWithMetaFacing;
import gollorum.signpost.blocks.PostPost;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.util.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class BlockHandler {
    public static BasePost base = new BasePost();
    public static BaseModelPost[] basemodels = BaseModelPost.createAll();
    public PostPost post_oak = new PostPost(PostPost.PostType.OAK);
    public PostPost post_spruce = new PostPost(PostPost.PostType.SPRUCE);
    public PostPost post_birch = new PostPost(PostPost.PostType.BIRCH);
    public PostPost post_jungle = new PostPost(PostPost.PostType.JUNGLE);
    public PostPost post_acacia = new PostPost(PostPost.PostType.ACACIA);
    public PostPost post_big_oak = new PostPost(PostPost.PostType.BIGOAK);
    public PostPost post_iron = new PostPost(PostPost.PostType.IRON);
    public PostPost post_stone = new PostPost(PostPost.PostType.STONE);
    public PostPost[] posts = new PostPost[]{this.post_oak, this.post_spruce, this.post_birch, this.post_jungle, this.post_acacia, this.post_big_oak, this.post_iron, this.post_stone};
    public BigPostPost bigpost_oak = new BigPostPost(BigPostPost.BigPostType.OAK);
    public BigPostPost bigpost_spruce = new BigPostPost(BigPostPost.BigPostType.SPRUCE);
    public BigPostPost bigpost_birch = new BigPostPost(BigPostPost.BigPostType.BIRCH);
    public BigPostPost bigpost_jungle = new BigPostPost(BigPostPost.BigPostType.JUNGLE);
    public BigPostPost bigpost_acacia = new BigPostPost(BigPostPost.BigPostType.ACACIA);
    public BigPostPost bigpost_big_oak = new BigPostPost(BigPostPost.BigPostType.BIGOAK);
    public BigPostPost bigpost_iron = new BigPostPost(BigPostPost.BigPostType.IRON);
    public BigPostPost bigpost_stone = new BigPostPost(BigPostPost.BigPostType.STONE);
    public BigPostPost[] bigposts = new BigPostPost[]{this.bigpost_oak, this.bigpost_spruce, this.bigpost_birch, this.bigpost_jungle, this.bigpost_acacia, this.bigpost_big_oak, this.bigpost_iron, this.bigpost_stone};

    public List<BaseModelPost> baseModelsForCrafting() {
        List<BaseModelPost> allModels = Arrays.asList(basemodels);
        ArrayList<BaseModelPost> allowedModels = new ArrayList<BaseModelPost>();
        for (final String model : ClientConfigStorage.INSTANCE.getAllowedCraftingModels()) {
            BaseModelPost block = CollectionUtils.find(allModels, new Predicate<BaseModelPost>(){

                @Override
                public boolean test(BaseModelPost m) {
                    return m.type.name.equals(model);
                }
            });
            if (block == null) continue;
            allowedModels.add(block);
        }
        return allowedModels;
    }

    public List<BaseModelPost> baseModelsForVillages() {
        List<BaseModelPost> allModels = Arrays.asList(basemodels);
        ArrayList<BaseModelPost> allowedModels = new ArrayList<BaseModelPost>();
        for (final String model : ClientConfigStorage.INSTANCE.getAllowedVillageModels()) {
            BaseModelPost block = CollectionUtils.find(allModels, new Predicate<BaseModelPost>(){

                @Override
                public boolean test(BaseModelPost m) {
                    return m.type.name.equals(model);
                }
            });
            if (block == null) continue;
            allowedModels.add(block);
        }
        return allowedModels;
    }

    public void registerBlocks() {
        GameRegistry.registerBlock((Block)base, (String)"SignpostBase");
        for (BaseModelPost baseModelPost : basemodels) {
            GameRegistry.registerBlock((Block)baseModelPost, ItemBlockWithMetaFacing.class, (String)("blockbasemodel" + baseModelPost.type.getID()));
        }
        for (BlockContainer blockContainer : this.posts) {
            GameRegistry.registerBlock((Block)blockContainer, (String)("SignpostPost" + blockContainer.type.name()));
        }
        for (BlockContainer blockContainer : this.bigposts) {
            GameRegistry.registerBlock((Block)blockContainer, (String)("BigSignpostPost" + blockContainer.type.name()));
        }
    }

    public void registerRecipes() {
        this.waystoneRecipe();
        for (PostPost postPost : this.posts) {
            this.postRecipe(postPost);
        }
        for (SuperPostPost superPostPost : this.bigposts) {
            this.bigPostRecipe((BigPostPost)superPostPost);
        }
    }

    private void waystoneRecipe() {
        HashSet toDelete = new HashSet();
        Item[] outputsToRemove = new Item[basemodels.length + 1];
        for (int i = 0; i < basemodels.length; ++i) {
            outputsToRemove[i] = Item.func_150898_a((Block)basemodels[i]);
        }
        outputsToRemove[outputsToRemove.length - 1] = Item.func_150898_a((Block)base);
        block6: for (Object now : CraftingManager.func_77594_a().func_77592_b()) {
            Item item;
            ItemStack output;
            if (!(now instanceof IRecipe) || (output = ((IRecipe)now).func_77571_b()) == null || (item = output.func_77973_b()) == null) continue;
            for (Item item2 : outputsToRemove) {
                if (!item.equals(item2)) continue;
                toDelete.add(now);
                continue block6;
            }
        }
        CraftingManager.func_77594_a().func_77592_b().removeAll(toDelete);
        if (ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canCraft && !ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            switch (ClientConfigStorage.INSTANCE.getWaysRec()) {
                case EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", "PPP", "SSS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", " P ", "SSS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{"SSS", " P ", "SSS", Character.valueOf('S'), Blocks.field_150347_e, Character.valueOf('P'), Items.field_151079_bi});
                }
            }
            List<BaseModelPost> allowedModels = this.baseModelsForCrafting();
            if (allowedModels.size() > 0) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)allowedModels.get(0), 1), (Object[])new Object[]{base});
                for (int i = 1; i < allowedModels.size(); ++i) {
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)allowedModels.get(i), 1), (Object[])new Object[]{allowedModels.get(i - 1)});
                }
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)base, 1), (Object[])new Object[]{allowedModels.get(allowedModels.size() - 1)});
            }
        }
    }

    private void postRecipe(PostPost post) {
        Object toDelete = null;
        for (Object now : CraftingManager.func_77594_a().func_77592_b()) {
            if (now == null || !(now instanceof IRecipe) || ((IRecipe)now).func_77571_b() == null || ((IRecipe)now).func_77571_b().func_77973_b() == null || !((IRecipe)now).func_77571_b().func_77973_b().equals(Item.func_150898_a((Block)post))) continue;
            toDelete = now;
            break;
        }
        CraftingManager.func_77594_a().func_77592_b().remove(toDelete);
        if (ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canCraft) {
            switch (ClientConfigStorage.INSTANCE.getSignRec()) {
                case EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"A", "P", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"A", "P", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 4), (Object[])new Object[]{"A", "A", "B", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata)});
                }
            }
        }
    }

    private void bigPostRecipe(BigPostPost post) {
        Object toDelete = null;
        for (Object now : CraftingManager.func_77594_a().func_77592_b()) {
            if (now == null || !(now instanceof IRecipe) || ((IRecipe)now).func_77571_b() == null || ((IRecipe)now).func_77571_b().func_77973_b() == null || !((IRecipe)now).func_77571_b().func_77973_b().equals(Item.func_150898_a((Block)post))) continue;
            toDelete = now;
            break;
        }
        CraftingManager.func_77594_a().func_77592_b().remove(toDelete);
        if (ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canCraft) {
            switch (ClientConfigStorage.INSTANCE.getSignRec()) {
                case EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"AAA", "APA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151079_bi});
                    break;
                }
                case VERY_EXPENSIVE: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 1), (Object[])new Object[]{"AAA", "APA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata), Character.valueOf('P'), Items.field_151156_bN});
                    break;
                }
                case DEACTIVATED: {
                    break;
                }
                default: {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)post, 4), (Object[])new Object[]{"AAA", "AAA", " B ", Character.valueOf('A'), Items.field_151155_ap, Character.valueOf('B'), new ItemStack(post.type.baseItem, 1, post.type.metadata)});
                }
            }
        }
    }
}

