/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task.multi;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.MapSaver;
import net.techbrew.journeymap.task.multi.ITask;
import net.techbrew.journeymap.task.multi.ITaskManager;
import org.apache.logging.log4j.Logger;

public class SaveMapTask
implements ITask {
    private static final Logger logger = JourneyMap.getLogger();
    MapSaver mapSaver;

    private SaveMapTask(MapSaver mapSaver) {
        this.mapSaver = mapSaver;
    }

    @Override
    public int getMaxRuntime() {
        return 120000;
    }

    @Override
    public void performTask(Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) {
        this.mapSaver.saveMap();
    }

    public static class Manager
    implements ITaskManager {
        MapSaver mapSaver;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return SaveMapTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            if (params != null && params instanceof MapSaver) {
                this.mapSaver = (MapSaver)params;
            }
            return this.isEnabled(minecraft);
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.mapSaver != null;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            this.mapSaver = null;
        }

        @Override
        public SaveMapTask getTask(Minecraft minecraft) {
            if (this.mapSaver == null) {
                return null;
            }
            return new SaveMapTask(this.mapSaver);
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
            this.mapSaver = null;
        }
    }
}

