/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.texture;

import com.google.common.base.Objects;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.IResourceManager;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.task.main.ExpireTextureTask;
import org.lwjgl.opengl.GL11;

public class TextureImpl
extends AbstractTexture {
    private final ReentrantLock bufferLock = new ReentrantLock();
    protected BufferedImage image;
    protected boolean retainImage;
    protected int width;
    protected int height;
    protected float alpha;
    protected long lastImageUpdate;
    protected long lastBound;
    protected String description;
    protected ByteBuffer buffer;
    protected boolean bindNeeded;

    public TextureImpl(BufferedImage image) {
        this(null, image, false, true);
    }

    public TextureImpl(BufferedImage image, boolean retainImage) {
        this(null, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage) {
        this(glId, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage, boolean bindImmediately) {
        if (glId != null) {
            this.field_110553_a = glId;
        }
        if (image != null) {
            this.setImage(image, retainImage);
        }
        if (bindImmediately) {
            this.bindTexture();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage bufferedImage, boolean retainImage) {
        if (bufferedImage == null) {
            return;
        }
        try {
            this.bufferLock.lock();
            this.retainImage = retainImage;
            if (retainImage) {
                this.image = bufferedImage;
            }
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            int bufferSize = this.width * this.height * 4;
            if (this.buffer == null || this.buffer.capacity() != bufferSize) {
                this.buffer = ByteBuffer.allocateDirect(bufferSize);
            }
            this.buffer.clear();
            int[] pixels = new int[this.width * this.height];
            bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int pixel = pixels[y * this.width + x];
                    this.buffer.put((byte)(pixel >> 16 & 0xFF));
                    this.buffer.put((byte)(pixel >> 8 & 0xFF));
                    this.buffer.put((byte)(pixel & 0xFF));
                    this.buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            this.buffer.flip();
            this.buffer.rewind();
            this.bindNeeded = true;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.lastImageUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTexture() {
        if (!this.bindNeeded) {
            return;
        }
        if (this.bufferLock.tryLock()) {
            try {
                GL11.glBindTexture((int)3553, (int)super.func_110552_b());
                GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                int glErr = GL11.glGetError();
                if (glErr != 0) {
                    JourneyMap.getLogger().warn("GL Error in TextureImpl after glTexImage2D: " + glErr);
                } else {
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                JourneyMap.getLogger().warn("Can't bind texture: " + t);
                this.buffer = null;
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public boolean isBindNeeded() {
        return this.bindNeeded;
    }

    public boolean isBound() {
        return this.field_110553_a != -1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void updateAndBind(BufferedImage image) {
        this.updateAndBind(image, this.retainImage);
    }

    public void updateAndBind(BufferedImage image, boolean retainImage) {
        this.setImage(image, retainImage);
        this.bindTexture();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public boolean isDefunct() {
        return this.field_110553_a == -1 && this.image == null && this.buffer == null;
    }

    public int func_110552_b() {
        if (this.bindNeeded) {
            this.bindTexture();
        }
        return super.func_110552_b();
    }

    public int getGlTextureId(boolean forceBind) {
        if (forceBind || this.field_110553_a == -1) {
            return this.func_110552_b();
        }
        return this.field_110553_a;
    }

    public void clear() {
        this.bufferLock.lock();
        this.buffer = null;
        this.bufferLock.unlock();
        this.image = null;
        this.bindNeeded = false;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.field_110553_a = -1;
    }

    public void queueForDeletion() {
        ExpireTextureTask.queue(this);
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public long getLastBound() {
        return this.lastBound;
    }

    public void func_110551_a(IResourceManager par1ResourceManager) {
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("glid", this.field_110553_a).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).add("lastBound", this.lastBound).toString();
    }

    public void finalize() {
        if (this.isBound()) {
            JourneyMap.getLogger().warn("TextureImpl disposed without deleting texture glID: " + (Object)((Object)this));
            ExpireTextureTask.queue(this.field_110553_a);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

