/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.techbrew.journeymap.render.texture.TextureImpl;
import org.lwjgl.opengl.GL11;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(String text, double x, double y, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale) {
        DrawUtil.drawLabel(text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true, 0.0);
    }

    public static void drawCenteredLabel(String text, double x, double y, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawCenteredLabel(String text, double x, double y, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale, double rotation) {
        DrawUtil.drawLabel(text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true, rotation);
    }

    public static void drawLabel(String text, double x, double y, HAlign hAlign, VAlign vAlign, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(String text, double x, double y, HAlign hAlign, VAlign vAlign, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        FontRenderer fontRenderer = mc.field_71466_p;
        boolean drawRect = bgColor != null && alpha > 0;
        int width = fontRenderer.func_78256_a(text);
        int n = height = drawRect ? DrawUtil.getLabelHeight(fontRenderer, fontShadow) : fontRenderer.field_78288_b;
        if (!drawRect && fontRenderer.func_82883_a()) {
            --height;
        }
        GL11.glPushMatrix();
        try {
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                GL11.glScaled((double)fontScale, (double)fontScale, (double)0.0);
            }
            double textX = x;
            double textY = y;
            double rectX = x;
            double rectY = y;
            switch (hAlign) {
                case Left: {
                    textX = x - (double)width;
                    break;
                }
                case Center: {
                    textX = x - (double)(width / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    break;
                }
                case Right: {
                    textX = x;
                }
            }
            double vpad = drawRect ? (double)(height - fontRenderer.field_78288_b) / 2.0 : 0.0;
            switch (vAlign) {
                case Above: {
                    rectY = y - (double)height;
                    textY = rectY + vpad + (double)(!fontRenderer.func_82883_a() ? 1 : 0);
                    break;
                }
                case Middle: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = rectY + vpad;
                    break;
                }
                case Below: {
                    rectY = y;
                    textY = rectY + vpad;
                }
            }
            if (rotation != 0.0) {
                GL11.glTranslated((double)x, (double)y, (double)0.0);
                GL11.glRotated((double)(-rotation), (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
            }
            if (bgColor != null && bgAlpha > 0) {
                int hpad = 2;
                double rectHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
                DrawUtil.drawRectangle(textX - 2.0 - 0.5, rectY, width + 4, rectHeight, bgColor, bgAlpha);
            }
            int intTextX = (int)Math.floor(textX);
            int intTextY = (int)Math.floor(textY);
            double dTextX = textX - (double)intTextX;
            double dTextY = textY - (double)intTextY;
            GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
            if (color.getTransparency() != alpha) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
            if (fontShadow) {
                fontRenderer.func_78261_a(text, intTextX, intTextY, color.getRGB());
            } else {
                fontRenderer.func_78276_b(text, intTextX, intTextY, color.getRGB());
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public static int getLabelHeight(FontRenderer fr, boolean fontShadow) {
        int vpad = fr.func_82883_a() ? 0 : (fontShadow ? 3 : 2);
        return fr.field_78288_b + 2 * vpad;
    }

    private static void drawQuad(TextureImpl texture, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(texture, x, y, width, height, rotation, null, alpha, flip, true, 770, 771, false);
    }

    private static void drawQuad(TextureImpl texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(texture, x, y, width, height, rotation, null, 1.0f, flip, true, 770, 771, false);
    }

    public static void drawQuad(TextureImpl texture, double x, double y, double width, double height, double rotation, Color color, float alpha, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        GL11.glPushMatrix();
        if (blend) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)glBlendSfactor, (int)glBlendDFactor, (int)1, (int)0);
        }
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)texture.func_110552_b());
        if (blend) {
            if (color != null) {
                float[] c = color.getColorComponents(null);
                GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        int texEdgeBehavior = clampTexture ? 33071 : 10497;
        GL11.glTexParameteri((int)3553, (int)10242, (int)texEdgeBehavior);
        GL11.glTexParameteri((int)3553, (int)10243, (int)texEdgeBehavior);
        if (rotation != 0.0) {
            double transX = x + width / 2.0;
            double transY = y + height / 2.0;
            GL11.glTranslated((double)transX, (double)transY, (double)0.0);
            GL11.glRotated((double)rotation, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-transX), (double)(-transY), (double)0.0);
        }
        int direction = flip ? -1 : 1;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, height + y, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, height + y, zLevel, (double)direction, 1.0);
        tessellator.func_78374_a(x + width, y, zLevel, (double)direction, 0.0);
        tessellator.func_78374_a(x, y, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        if (blend && (glBlendSfactor != 770 || glBlendDFactor != 771)) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
        GL11.glPopMatrix();
    }

    public static void drawRectangle(double x, double y, double width, double height, Color color, int alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        tessellator.func_78374_a(x, height + y, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, height + y, zLevel, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(x, y, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public static void drawGradientRect(double x, double y, double width, double height, Color startColor, int startAlpha, Color endColor, int endAlpha) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(endColor.getRGB(), endAlpha);
        tessellator.func_78374_a(x, height + y, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, height + y, zLevel, 1.0, 1.0);
        tessellator.func_78384_a(startColor.getRGB(), startAlpha);
        tessellator.func_78374_a(x + width, y, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(x, y, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public static void drawBoundTexture(double startU, double startV, double startX, double startY, double z, double endU, double endV, double endX, double endY) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(startX, endY, z, startU, endV);
        tessellator.func_78374_a(endX, endY, z, endU, endV);
        tessellator.func_78374_a(endX, startY, z, endU, startV);
        tessellator.func_78374_a(startX, startY, z, startU, startV);
        tessellator.func_78381_a();
    }

    public static void drawImage(TextureImpl texture, double x, double y, boolean flip, float alpha, float scale, double rotation) {
        DrawUtil.drawQuad(texture, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, flip, rotation);
    }

    public static void drawImage(TextureImpl texture, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, flip, rotation);
    }

    public static void drawClampedImage(TextureImpl texture, double x, double y, float scale, double rotation) {
        DrawUtil.drawClampedImage(texture, null, x, y, scale, 1.0f, rotation);
    }

    public static void drawClampedImage(TextureImpl texture, Color color, double x, double y, float scale, float alpha, double rotation) {
        DrawUtil.drawQuad(texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, rotation, color, alpha, false, true, 770, 771, true);
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, rotation, color, alpha, false, true, 770, 771, false);
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x, double y, double rotation) {
        DrawUtil.drawQuad(texture, x, y, texture.getWidth(), texture.getHeight(), rotation, color, alpha, false, true, 770, 771, false);
    }

    public static void drawEntity(double x, double y, double heading, boolean flipInsteadOfRotate, TextureImpl texture, float scale, double rotation) {
        DrawUtil.drawEntity(x, y, heading, flipInsteadOfRotate, texture, 1.0f, scale, rotation);
    }

    public static void drawEntity(double x, double y, double heading, boolean flipInsteadOfRotate, TextureImpl texture, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        if (flipInsteadOfRotate) {
            boolean flip = heading % 180.0 < 90.0;
            DrawUtil.drawImage(texture, drawX, drawY, flip, alpha, scale, -rotation);
        } else {
            DrawUtil.drawImage(texture, drawX, drawY, false, alpha, scale, heading);
        }
    }

    public static void sizeDisplay(double width, double height) {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }
}

