/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.properties;

import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.techbrew.journeymap.io.IconSetFileHandler;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.properties.config.Config;

public abstract class MapProperties
extends PropertiesBase
implements Comparable<MapProperties> {
    @Config(category=Config.Category.Inherit, key="jm.common.show_mobs")
    public final AtomicBoolean showMobs = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_animals")
    public final AtomicBoolean showAnimals = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_villagers")
    public final AtomicBoolean showVillagers = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_pets")
    public final AtomicBoolean showPets = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_players")
    public final AtomicBoolean showPlayers = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_waypoints")
    public final AtomicBoolean showWaypoints = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_self")
    public final AtomicBoolean showSelf = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.show_grid")
    public final AtomicBoolean showGrid = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.mob_icon_set", stringListProvider=IconSetFileHandler.IconSetStringListProvider.class)
    public final AtomicReference<String> entityIconSetName = new AtomicReference<String>("2D");
    public final AtomicInteger zoomLevel = new AtomicInteger(0);

    protected MapProperties() {
    }

    public abstract AtomicReference<String> getEntityIconSetName();

    public abstract AtomicReference<MapType.Name> getPreferredMapType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapProperties that = (MapProperties)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = 31 * this.showMobs.hashCode();
        result = 31 * result + this.showAnimals.hashCode();
        result = 31 * result + this.showVillagers.hashCode();
        result = 31 * result + this.showPets.hashCode();
        result = 31 * result + this.showPlayers.hashCode();
        result = 31 * result + this.showWaypoints.hashCode();
        result = 31 * result + this.showSelf.hashCode();
        result = 31 * result + this.getEntityIconSetName().hashCode();
        return result;
    }

    @Override
    public int compareTo(MapProperties other) {
        return Integer.valueOf(this.hashCode()).compareTo(other.hashCode());
    }

    protected Objects.ToStringHelper toStringHelper(MapProperties me) {
        return Objects.toStringHelper((Object)me).add("entityIconSetName", this.entityIconSetName).add("showAnimals", (Object)this.showAnimals).add("showMobs", (Object)this.showMobs).add("showPets", (Object)this.showPets).add("showPlayers", (Object)this.showPlayers).add("showSelf", (Object)this.showSelf).add("showVillagers", (Object)this.showVillagers).add("showWaypoints", (Object)this.showWaypoints).add("zoomLevel", (Object)this.zoomLevel);
    }
}

