/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.mod.ModBlockDelegate;

public class BlockMDCache
extends CacheLoader<Block, HashMap<Integer, BlockMD>> {
    public final BlockMD AIRBLOCK;
    public final BlockMD VOIDBLOCK;
    private final HashMap<Block, EnumSet<BlockMD.Flag>> blockFlags;
    private final HashMap<Block, Float> blockAlphas;
    private final ModBlockDelegate modBlockDelegate = new ModBlockDelegate();

    public BlockMDCache() {
        GameRegistry.UniqueIdentifier airUid = new GameRegistry.UniqueIdentifier(GameData.getBlockRegistry().func_148750_c((Object)Blocks.field_150350_a));
        this.AIRBLOCK = new BlockMD("Air", airUid, Blocks.field_150350_a, 0, 0.0f, EnumSet.of(BlockMD.Flag.HasAir));
        GameRegistry.UniqueIdentifier voidUid = new GameRegistry.UniqueIdentifier("journeymap:void");
        this.VOIDBLOCK = new BlockMD("Void", voidUid, null, 0, 1.0f, null);
        this.blockFlags = new HashMap(64);
        this.blockAlphas = new HashMap(8);
    }

    public void initialize() {
        StatTimer timer = StatTimer.get("BlockMDCache.ensureCurrent").start();
        this.blockAlphas.clear();
        this.blockFlags.clear();
        this.setAlpha(Blocks.field_150350_a, Float.valueOf(0.0f));
        this.setAlpha(Blocks.field_150422_aJ, Float.valueOf(0.4f));
        this.setAlpha(Blocks.field_150396_be, Float.valueOf(0.4f));
        this.setAlpha((Block)Blocks.field_150358_i, Float.valueOf(0.3f));
        this.setAlpha(Blocks.field_150359_w, Float.valueOf(0.3f));
        this.setAlpha(Blocks.field_150410_aZ, Float.valueOf(0.3f));
        this.setAlpha(Blocks.field_150432_aD, Float.valueOf(0.8f));
        this.setAlpha(Blocks.field_150411_aY, Float.valueOf(0.4f));
        this.setAlpha(Blocks.field_150386_bk, Float.valueOf(0.4f));
        this.setAlpha((Block)Blocks.field_150399_cn, Float.valueOf(0.5f));
        this.setAlpha((Block)Blocks.field_150397_co, Float.valueOf(0.5f));
        this.setAlpha(Blocks.field_150478_aa, Float.valueOf(0.5f));
        this.setAlpha(Blocks.field_150395_bd, Float.valueOf(0.2f));
        this.setAlpha(Blocks.field_150355_j, Float.valueOf(0.3f));
        if (JourneyMap.getCoreProperties().caveIgnoreGlass.get()) {
            this.setFlags(Blocks.field_150359_w, BlockMD.Flag.OpenToSky);
            this.setFlags(Blocks.field_150410_aZ, BlockMD.Flag.OpenToSky);
            this.setFlags((Block)Blocks.field_150399_cn, BlockMD.Flag.OpenToSky);
            this.setFlags((Block)Blocks.field_150399_cn, BlockMD.Flag.OpenToSky);
        }
        this.setFlags(Blocks.field_150350_a, BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow, BlockMD.Flag.OpenToSky);
        this.setFlags((Block)Blocks.field_150398_cm, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150422_aJ, BlockMD.Flag.TransparentRoof);
        this.setFlags((Block)Blocks.field_150480_ab, BlockMD.Flag.NoShadow, BlockMD.Flag.Side2Texture);
        this.setFlags((Block)Blocks.field_150358_i, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150359_w, BlockMD.Flag.TransparentRoof);
        this.setFlags(Blocks.field_150410_aZ, BlockMD.Flag.TransparentRoof);
        this.setFlags((Block)Blocks.field_150349_c, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150411_aY, BlockMD.Flag.TransparentRoof);
        this.setFlags(Blocks.field_150468_ap, BlockMD.Flag.OpenToSky);
        this.setFlags(Blocks.field_150353_l, BlockMD.Flag.NoShadow);
        this.setFlags((Block)Blocks.field_150362_t, BlockMD.Flag.OpenToSky, BlockMD.Flag.BiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags((Block)Blocks.field_150361_u, BlockMD.Flag.OpenToSky, BlockMD.Flag.BiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags(Blocks.field_150364_r, BlockMD.Flag.OpenToSky, BlockMD.Flag.BiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags(Blocks.field_150363_s, BlockMD.Flag.OpenToSky, BlockMD.Flag.BiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags(Blocks.field_150429_aA, BlockMD.Flag.HasAir);
        this.setFlags(Blocks.field_150431_aC, BlockMD.Flag.NoTopo);
        this.setFlags((Block)Blocks.field_150399_cn, BlockMD.Flag.TransparentRoof, BlockMD.Flag.Transparency);
        this.setFlags((Block)Blocks.field_150397_co, BlockMD.Flag.TransparentRoof, BlockMD.Flag.Transparency);
        this.setFlags((Block)Blocks.field_150329_H, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150478_aa, BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow);
        this.setFlags(Blocks.field_150473_bD, BlockMD.Flag.NoShadow);
        this.setFlags((Block)Blocks.field_150479_bC, BlockMD.Flag.NoShadow);
        this.setFlags(Blocks.field_150437_az, BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow);
        this.setFlags(Blocks.field_150395_bd, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150355_j, BlockMD.Flag.NoShadow, BlockMD.Flag.BiomeColor);
        this.setFlags(Blocks.field_150321_G, BlockMD.Flag.OpenToSky, BlockMD.Flag.Side2Texture);
        HashMap<GameRegistry.UniqueIdentifier, EnumSet<BlockMD.Flag>> modBlockUIDs = new HashMap<GameRegistry.UniqueIdentifier, EnumSet<BlockMD.Flag>>();
        for (GameRegistry.UniqueIdentifier specialUid : ModBlockDelegate.Blocks.keySet()) {
            modBlockUIDs.put(specialUid, EnumSet.of(BlockMD.Flag.SpecialHandling));
        }
        ArrayList<String> torches = new ArrayList<String>(Arrays.asList("TConstruct:decoration.stonetorch", "CarpentersBlocks:blockCarpentersTorch", "ExtraUtilities:magnumTorch", "appliedenergistics2:tile.BlockQuartzTorch"));
        for (int i = 1; i <= 10; ++i) {
            torches.add("chisel:torch" + i);
        }
        for (String torch : torches) {
            modBlockUIDs.put(new GameRegistry.UniqueIdentifier(torch), EnumSet.of(BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow));
        }
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("Mariculture:kelp"), EnumSet.of(BlockMD.Flag.Side2Texture, BlockMD.Flag.Plant));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:LooseRock"), EnumSet.of(BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:Grass"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:Grass2"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:ClayGrass"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:ClayGrass2"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:DryGrass"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:DryGrass2"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:PeatGrass"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:TallGrass"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:SaltWater"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:SaltWaterStationary"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("terrafirmacraft:SeaGrassStill"), EnumSet.of(BlockMD.Flag.Side2Texture));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("Thaumcraft:blockMagicalLeaves"), EnumSet.of(BlockMD.Flag.BiomeColor));
        modBlockUIDs.put(new GameRegistry.UniqueIdentifier("CarpentersBlocks:blockCarpentersLadder"), EnumSet.of(BlockMD.Flag.OpenToSky));
        for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
            GameRegistry.UniqueIdentifier uid;
            if (block.func_149688_o() == Material.field_151579_a) {
                this.setFlags(block, BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow);
                continue;
            }
            if (block instanceof BlockGrass) {
                this.setFlags(block, BlockMD.Flag.BiomeColor);
            }
            if (block instanceof BlockLeavesBase || block instanceof BlockVine || block instanceof BlockLilyPad) {
                this.setFlags(block, BlockMD.Flag.BiomeColor, BlockMD.Flag.NoTopo);
            }
            if (block instanceof BlockCrops) {
                this.setFlags(block, BlockMD.Flag.Side2Texture, BlockMD.Flag.Crop, BlockMD.Flag.NoTopo);
                if (!JourneyMap.getCoreProperties().mapPlantShadows.get()) {
                    this.setFlags(block, BlockMD.Flag.NoShadow);
                }
            } else if (block instanceof BlockBush || block instanceof BlockCactus || block instanceof BlockDeadBush) {
                this.setFlags(block, BlockMD.Flag.Side2Texture, BlockMD.Flag.Plant, BlockMD.Flag.NoTopo);
                if (!JourneyMap.getCoreProperties().mapPlantShadows.get()) {
                    this.setFlags(block, BlockMD.Flag.NoShadow);
                }
            } else if (block instanceof BlockRailBase) {
                this.setFlags(block, BlockMD.Flag.NoShadow, BlockMD.Flag.NoTopo);
            }
            if (!modBlockUIDs.containsKey(uid = this.findUniqueIdentifierFor(block))) continue;
            this.setFlags(block, (Collection)modBlockUIDs.get(uid));
        }
        timer.stop();
    }

    public HashMap<Integer, BlockMD> load(Block key) throws Exception {
        return new HashMap<Integer, BlockMD>(16);
    }

    public GameRegistry.UniqueIdentifier findUniqueIdentifierFor(Block block) {
        return new GameRegistry.UniqueIdentifier(GameData.getBlockRegistry().func_148750_c((Object)block));
    }

    public BlockMD getBlockMD(LoadingCache<Block, HashMap<Integer, BlockMD>> cache, ChunkMD chunkMd, int x, int y, int z) {
        try {
            if (y >= 0) {
                Block block = chunkMd.getBlock(x, y, z);
                if (block instanceof BlockAir) {
                    return this.AIRBLOCK;
                }
                int meta = chunkMd.getChunk().func_76628_c(x, y, z);
                return this.getBlockMD(cache, chunkMd, block, meta, x, y, z);
            }
            return this.VOIDBLOCK;
        }
        catch (Exception e) {
            JourneyMap.getLogger().error(String.format("Can't get blockId/meta for chunk %s,%s block %s,%s,%s : %s", chunkMd.getChunk().field_76635_g, chunkMd.getChunk().field_76647_h, x, y, z, LogFormatter.toString(e)));
            return this.AIRBLOCK;
        }
    }

    public BlockMD getBlockMD(LoadingCache<Block, HashMap<Integer, BlockMD>> cache, ChunkMD chunkMD, Block block, int meta, int x, int y, int z) {
        BlockMD blockMD = this.getBlockMD(cache, block, meta);
        if (blockMD.hasFlag(BlockMD.Flag.SpecialHandling)) {
            blockMD = this.modBlockDelegate.handleBlock(chunkMD, blockMD, x, y, z);
        }
        return blockMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockMD getBlockMD(LoadingCache<Block, HashMap<Integer, BlockMD>> cache, Block block, int meta) {
        try {
            if (block instanceof BlockAir) {
                return this.AIRBLOCK;
            }
            HashMap map = (HashMap)cache.get((Object)block);
            BlockMD blockMD = (BlockMD)map.get(meta);
            BlockMDCache blockMDCache = this;
            synchronized (blockMDCache) {
                if (blockMD == null) {
                    String displayName = BlockMD.getBlockName(block, meta);
                    blockMD = new BlockMD(displayName, block, meta, this.getAlpha(block), this.getFlags(block));
                    map.put(meta, blockMD);
                }
            }
            return blockMD;
        }
        catch (Exception e) {
            JourneyMap.getLogger().error(String.format("Can't get blockId/meta for block %s meta %s : %s", block, meta, LogFormatter.toString(e)));
            return this.AIRBLOCK;
        }
    }

    public EnumSet<BlockMD.Flag> getFlags(Block block) {
        EnumSet<BlockMD.Flag> flags = this.blockFlags.get(block);
        return flags == null ? EnumSet.noneOf(BlockMD.Flag.class) : flags;
    }

    public void setFlags(Block block, BlockMD.Flag ... flags) {
        this.setFlags(block, Arrays.asList(flags));
    }

    public void setFlags(Block block, Collection<BlockMD.Flag> flags) {
        EnumSet<BlockMD.Flag> eset = this.getFlags(block);
        eset.addAll(flags);
        this.blockFlags.put(block, eset);
        JourneyMap.getLogger().debug(block.func_149739_a() + " flags set: " + eset);
    }

    public boolean hasFlag(Block block, BlockMD.Flag flag) {
        EnumSet<BlockMD.Flag> flags = this.blockFlags.get(block);
        return flags != null && flags.contains((Object)flag);
    }

    public boolean hasAnyFlags(Block block, BlockMD.Flag ... flags) {
        EnumSet<BlockMD.Flag> flagSet = this.blockFlags.get(block);
        if (flagSet == null) {
            return false;
        }
        for (BlockMD.Flag flag : flags) {
            if (!flagSet.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlpha(Block block) {
        return this.blockAlphas.containsKey(block);
    }

    public float getAlpha(Block block) {
        Float alpha = this.blockAlphas.get(block);
        return alpha == null ? 1.0f : alpha.floatValue();
    }

    public void setAlpha(Block block, Float alpha) {
        this.blockAlphas.put(block, alpha);
    }

    public HashMap getFlagsMap() {
        return this.blockFlags;
    }

    public HashMap getAlphaMap() {
        return this.blockAlphas;
    }

    public ModBlockDelegate getModBlockDelegate() {
        return this.modBlockDelegate;
    }
}

