/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.cartography.RGB;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.ChunkMD;

public class BlockMD {
    public final GameRegistry.UniqueIdentifier uid;
    public final int meta;
    public final String name;
    private final EnumSet<Flag> flags;
    private transient Block block;
    private Integer color;
    private float alpha;
    private String iconName;

    BlockMD(String displayName, Block block, int meta, float alpha, Flag ... flags) {
        this(displayName, block, meta, alpha, flags.length == 0 ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(Arrays.asList(flags)));
    }

    BlockMD(String displayName, Block block, int meta, float alpha, EnumSet<Flag> flags) {
        this(displayName, DataCache.instance().getBlockMetadata().findUniqueIdentifierFor(block), block, meta, alpha, flags);
    }

    BlockMD(String displayName, GameRegistry.UniqueIdentifier uid, Block block, int meta, float alpha, EnumSet<Flag> flags) {
        this.uid = uid;
        this.meta = meta;
        this.block = block;
        this.name = displayName == null ? this.uid.name : displayName;
        this.flags = flags;
        this.alpha = alpha;
        if (block == null && "Void".equals(this.name)) {
            this.color = RGB.toInteger(17, 12, 25);
        }
    }

    public static String getBlockName(Block block, int meta) {
        String name = block.func_149739_a();
        try {
            ItemStack stack;
            String displayName;
            Item item = Item.func_150898_a((Block)block);
            if (item == null) {
                item = block.func_149650_a(0, new Random(), 0);
            }
            if (item != null && !Strings.isNullOrEmpty((String)(displayName = (stack = new ItemStack(item, 1, block.func_149692_a(meta))).func_82833_r()))) {
                name = displayName;
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().debug("Displayname not available for " + name);
        }
        if (Strings.isNullOrEmpty((String)name) || name.startsWith("tile")) {
            name = block.getClass().getSimpleName().replaceAll("Block", "");
        }
        return name;
    }

    public boolean hasFlag(Flag checkFlag) {
        return this.flags.contains((Object)checkFlag);
    }

    public boolean hasAnyFlag(Flag ... checkFlags) {
        for (Flag flag : checkFlags) {
            if (!this.flags.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public void addFlags(Flag ... addFlags) {
        Collections.addAll(this.flags, addFlags);
    }

    public int getColor(ChunkMD chunkMd, int x, int y, int z) {
        if (this.color != null) {
            return this.color;
        }
        Integer color = ColorCache.instance().getBlockColor(chunkMd, this, x, y, z);
        if (color == null) {
            this.color = color = Integer.valueOf(Color.black.getRGB());
            JourneyMap.getLogger().warn("Could not get color for " + this.block);
            this.addFlags(Flag.Error);
        } else if (!this.isBiomeColored()) {
            this.color = color;
        }
        return color;
    }

    public String getIconName() {
        return this.iconName == null ? "" : this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(Flag.Transparency);
        } else if (this.hasFlag(Flag.Transparency)) {
            this.flags.remove((Object)Flag.Transparency);
        }
    }

    public Block getBlock() {
        if (this.block == null) {
            this.block = GameRegistry.findBlock((String)this.uid.modId, (String)this.uid.name);
            if (this.block == null) {
                this.block = Blocks.field_150350_a;
            }
        }
        return this.block;
    }

    public boolean hasTranparency() {
        return this.hasFlag(Flag.Transparency);
    }

    public boolean isAir() {
        return this.getBlock() instanceof BlockAir || this.hasFlag(Flag.HasAir);
    }

    public boolean isIce() {
        return this.block == Blocks.field_150432_aD;
    }

    public boolean isTorch() {
        this.getBlock();
        return this.block == Blocks.field_150478_aa || this.block == Blocks.field_150429_aA || this.block == Blocks.field_150437_az;
    }

    public boolean isWater() {
        this.getBlock();
        return this.block == Blocks.field_150355_j || this.block == Blocks.field_150358_i;
    }

    public boolean isTransparentRoof() {
        return this.hasFlag(Flag.TransparentRoof);
    }

    public boolean isLava() {
        this.getBlock();
        return this.block == Blocks.field_150353_l || this.block == Blocks.field_150356_k;
    }

    public boolean isFoliage() {
        return this.getBlock() instanceof BlockLeaves;
    }

    public boolean isBiomeColored() {
        return this.flags.contains((Object)Flag.BiomeColor) || this.flags.contains((Object)Flag.CustomBiomeColor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMD blockMD = (BlockMD)o;
        if (this.meta != blockMD.meta) {
            return false;
        }
        return this.uid.equals((Object)blockMD.uid);
    }

    public int hashCode() {
        int result = this.uid.hashCode();
        result = 31 * result + this.meta;
        return result;
    }

    public String toCacheKeyString(GameRegistry.UniqueIdentifier uid, int meta) {
        return String.format("%s:%s:%s", uid.modId, uid.name, meta);
    }

    public String toString() {
        return String.format("BlockMD [%s]", this.toCacheKeyString(this.uid, this.meta));
    }

    public String getName() {
        return this.name;
    }

    public static enum Flag {
        HasAir,
        BiomeColor,
        CustomBiomeColor,
        OpenToSky,
        NoShadow,
        Side2Texture,
        Transparency,
        Error,
        TransparentRoof,
        Plant,
        Crop,
        TileEntity,
        SpecialHandling,
        NoTopo;

    }
}

