/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io.nbt;

import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.ChunkMD;
import org.apache.logging.log4j.Logger;

public class ChunkLoader {
    private static Logger logger = JourneyMap.getLogger();

    public static AnvilChunkLoader getAnvilChunkLoader(Minecraft mc) {
        if (mc.func_71356_B()) {
            try {
                File savesDir = new File(mc.field_71412_D, "saves");
                File worldSaveDir = new File(savesDir, mc.func_71401_C().func_71270_I());
                if (mc.field_71441_e.field_73011_w.getSaveFolder() != null) {
                    File file2 = new File(worldSaveDir, mc.field_71441_e.field_73011_w.getSaveFolder());
                    file2.mkdirs();
                    return new AnvilChunkLoader(file2);
                }
                return new AnvilChunkLoader(worldSaveDir);
            }
            catch (Throwable t) {
                logger.error("Couldn't get chunk loader: %s", t);
            }
        }
        return null;
    }

    public static ChunkMD getChunkMD(AnvilChunkLoader loader, Minecraft mc, ChunkCoordIntPair coord) {
        ChunkMD chunkMD = null;
        try {
            Chunk chunk = loader.func_75815_a((World)mc.field_71441_e, coord.field_77276_a, coord.field_77275_b);
            if (chunk != null) {
                chunk.func_76590_a();
                chunk.func_76603_b();
                chunkMD = new ChunkMD(chunk);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chunkMD;
    }

    public static ChunkMD getChunkMdFromMemory(World world, int chunkX, int chunkZ) {
        Chunk chunk = ChunkLoader.getChunkFromMemory(world, chunkX, chunkZ);
        if (chunk != null && chunk.func_76621_g()) {
            return null;
        }
        if (chunk != null && !chunk.func_76621_g()) {
            return new ChunkMD(chunk);
        }
        return null;
    }

    private static Chunk getChunkFromMemory(World world, int chunkX, int chunkZ) {
        Chunk theChunk;
        Chunk result = null;
        if (world.func_72863_F().func_73149_a(chunkX, chunkZ) && !((theChunk = world.func_72964_e(chunkX, chunkZ)) instanceof EmptyChunk) && theChunk.field_76636_d && !theChunk.func_76621_g()) {
            result = theChunk;
        }
        return result;
    }
}

