/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.ui.option.StringListProvider;
import net.techbrew.journeymap.ui.theme.Theme;
import net.techbrew.journeymap.ui.theme.ThemePresets;

public class ThemeFileHandler {
    public static final String ASSETS_JOURNEYMAP_ICON_THEME = "/assets/journeymap/icon/theme";
    public static final String THEME_FILE_SUFFIX = ".theme.json";
    public static final String DEFAULT_THEME_FILE = "default.theme.config";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setVersion(1.0).create();
    private static transient Theme currentTheme = null;

    public static void initialize() {
        JourneyMap.getLogger().trace("Initializing themes ...");
        HashSet<String> themeDirNames = new HashSet<String>();
        for (Theme theme : ThemePresets.getPresets()) {
            themeDirNames.add(theme.directory);
        }
        for (String dirName : themeDirNames) {
            FileHandler.copyResources(ThemeFileHandler.getThemeIconDir(), ASSETS_JOURNEYMAP_ICON_THEME, dirName, true);
        }
        for (Theme theme : ThemePresets.getPresets()) {
            ThemeFileHandler.save(theme);
        }
        ThemeFileHandler.ensureDefaultThemeFile();
    }

    public static File getThemeIconDir() {
        File dir = new File(FMLClientHandler.instance().getClient().field_71412_D, Constants.THEME_ICON_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File[] getThemeDirectories() {
        File parentDir = ThemeFileHandler.getThemeIconDir();
        File[] themeDirs = parentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return themeDirs;
    }

    public static List<Theme> getThemes() {
        File[] themeDirs = ThemeFileHandler.getThemeDirectories();
        if (themeDirs == null || themeDirs.length == 0) {
            ThemeFileHandler.initialize();
            themeDirs = ThemeFileHandler.getThemeDirectories();
            if (themeDirs == null || themeDirs.length == 0) {
                JourneyMap.getLogger().error("Couldn't find theme directories.");
                return Collections.emptyList();
            }
        }
        ArrayList<Theme> themes = new ArrayList<Theme>();
        for (File themeDir : themeDirs) {
            File[] themeFiles = themeDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(ThemeFileHandler.THEME_FILE_SUFFIX);
                }
            });
            if (themeFiles == null || themeFiles.length <= 0) continue;
            for (File themeFile : themeFiles) {
                Theme theme = ThemeFileHandler.loadThemeFromFile(themeFile, false);
                if (theme == null) continue;
                themes.add(theme);
            }
        }
        Collections.sort(themes);
        return themes;
    }

    public static List<String> getThemeNames() {
        List<Theme> themes = ThemeFileHandler.getThemes();
        ArrayList<String> names = new ArrayList<String>(themes.size());
        for (Theme theme : themes) {
            names.add(theme.name);
        }
        return names;
    }

    public static Theme getCurrentTheme() {
        return ThemeFileHandler.getCurrentTheme(false);
    }

    public static synchronized Theme getCurrentTheme(boolean forceReload) {
        if (forceReload) {
            TextureCache.instance().purgeThemeImages();
        }
        String themeName = JourneyMap.getCoreProperties().themeName.get();
        if (forceReload || currentTheme == null || !themeName.equals(ThemeFileHandler.currentTheme.name)) {
            currentTheme = ThemeFileHandler.getThemeByName(themeName);
        }
        return currentTheme;
    }

    public static Theme getThemeByName(String themeName) {
        for (Theme theme : ThemeFileHandler.getThemes()) {
            if (!theme.name.equals(themeName)) continue;
            return theme;
        }
        JourneyMap.getLogger().warn(String.format("Theme '%s' not found, reverting to default", themeName));
        return ThemePresets.THEME_VICTORIAN;
    }

    public static Theme loadThemeFromFile(File themeFile, boolean createIfMissing) {
        try {
            if (themeFile != null && themeFile.exists()) {
                Charset UTF8 = Charset.forName("UTF-8");
                String json = Files.toString((File)themeFile, (Charset)UTF8);
                return (Theme)GSON.fromJson(json, Theme.class);
            }
            if (createIfMissing) {
                JourneyMap.getLogger().info("Generating Theme json file: " + themeFile);
                Theme theme = new Theme();
                theme.name = themeFile.getName();
                ThemeFileHandler.save(theme);
                return theme;
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Could not load Theme json file: " + LogFormatter.toString(t));
        }
        return null;
    }

    private static File getThemeFile(String themeDirName, String themeFileName) {
        File themeDir = new File(ThemeFileHandler.getThemeIconDir(), themeDirName);
        String fileName = String.format("%s%s", themeFileName.replaceAll("[\\\\/:\"*?<>|]", "_"), THEME_FILE_SUFFIX);
        return new File(themeDir, fileName);
    }

    public static void save(Theme theme) {
        try {
            File themeFile = ThemeFileHandler.getThemeFile(theme.directory, theme.name);
            Files.createParentDirs((File)themeFile);
            Charset UTF8 = Charset.forName("UTF-8");
            Files.write((CharSequence)GSON.toJson((Object)theme), (File)themeFile, (Charset)UTF8);
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Could not save Theme json file: " + t);
        }
    }

    private static void ensureDefaultThemeFile() {
        File defaultThemeFile = new File(ThemeFileHandler.getThemeIconDir(), DEFAULT_THEME_FILE);
        if (!defaultThemeFile.exists()) {
            try {
                Theme.DefaultPointer defaultPointer = new Theme.DefaultPointer(ThemePresets.THEME_VICTORIAN);
                Charset UTF8 = Charset.forName("UTF-8");
                Files.write((CharSequence)GSON.toJson((Object)defaultPointer), (File)defaultThemeFile, (Charset)UTF8);
            }
            catch (Throwable t) {
                JourneyMap.getLogger().error("Could not save DefaultTheme json file: " + t);
            }
        }
    }

    public static Theme getDefaultTheme() {
        Theme.DefaultPointer pointer = ThemeFileHandler.loadDefaultPointer();
        pointer.filename = pointer.filename.replace(THEME_FILE_SUFFIX, "");
        File themeFile = ThemeFileHandler.getThemeFile(pointer.directory, pointer.filename);
        Theme theme = ThemeFileHandler.loadThemeFromFile(themeFile, false);
        if (theme == null) {
            JMLogger.logOnce(String.format("Default theme not found in %s: %s", themeFile, pointer.name), null);
            theme = ThemePresets.THEME_VICTORIAN;
        }
        return theme;
    }

    public static synchronized void loadNextTheme() {
        List<String> themeNames = ThemeFileHandler.getThemeNames();
        int index = themeNames.indexOf(ThemeFileHandler.getCurrentTheme().name);
        index = index < 0 || index >= themeNames.size() - 1 ? 0 : ++index;
        TextureCache.instance().purgeThemeImages();
        currentTheme = ThemeFileHandler.getThemes().get(index);
        JourneyMap.getCoreProperties().themeName.set(ThemeFileHandler.currentTheme.name);
        ThemeFileHandler.getCurrentTheme(true);
    }

    private static Theme.DefaultPointer loadDefaultPointer() {
        ThemeFileHandler.ensureDefaultThemeFile();
        try {
            File defaultThemeFile = new File(ThemeFileHandler.getThemeIconDir(), DEFAULT_THEME_FILE);
            if (defaultThemeFile.exists()) {
                Charset UTF8 = Charset.forName("UTF-8");
                String json = Files.toString((File)defaultThemeFile, (Charset)UTF8);
                return (Theme.DefaultPointer)GSON.fromJson(json, Theme.DefaultPointer.class);
            }
            return new Theme.DefaultPointer(ThemePresets.THEME_VICTORIAN);
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Could not load Theme.DefaultTheme json file: " + LogFormatter.toString(t));
            return null;
        }
    }

    public static class ThemeStringListProvider
    implements StringListProvider {
        @Override
        public List<String> getStrings() {
            return ThemeFileHandler.getThemeNames();
        }

        @Override
        public String getDefaultString() {
            return ThemeFileHandler.getDefaultTheme().name;
        }
    }
}

