/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forge.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.techbrew.journeymap.JourneyMap;

public class WorldInfoHandler {
    public static final String CHANNEL_NAME = "world_info";
    public static final int PACKET_WORLDID = 0;
    public static final int MIN_DELAY_MS = 1000;
    private static long lastRequest;
    private static long lastResponse;
    private static SimpleNetworkWrapper channel;
    Minecraft mc = FMLClientHandler.instance().getClient();

    public WorldInfoHandler() {
        try {
            channel = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL_NAME);
            if (channel != null) {
                channel.registerMessage(WorldIdListener.class, WorldIdMessage.class, 0, Side.CLIENT);
                JourneyMap.getLogger().info(String.format("Registered channel: %s", CHANNEL_NAME));
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error(String.format("Failed to register channel %s: %s", CHANNEL_NAME, t));
        }
    }

    public static void requestWorldID() {
        long now;
        if (channel != null && lastRequest + 1000L < (now = System.currentTimeMillis()) && lastResponse + 1000L < now) {
            JourneyMap.getLogger().info("Requesting World ID");
            channel.sendToServer((IMessage)new WorldIdMessage());
            lastRequest = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void on(EntityJoinWorldEvent event) {
        if (!this.mc.func_71356_B() && this.mc.field_71439_g != null && !this.mc.field_71439_g.field_70128_L && event.entity.func_70005_c_().equals(this.mc.field_71439_g.func_70005_c_())) {
            WorldInfoHandler.requestWorldID();
        }
    }

    public static class WorldIdMessage
    implements IMessage {
        private String worldUid;

        public String getWorldUid() {
            return this.worldUid;
        }

        public void fromBytes(ByteBuf buf) {
            try {
                this.worldUid = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            catch (Throwable t) {
                JourneyMap.getLogger().error(String.format("Failed to read message: %s", t));
            }
        }

        public void toBytes(ByteBuf buf) {
            try {
                if (this.worldUid != null) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldUid);
                }
            }
            catch (Throwable t) {
                JourneyMap.getLogger().error(String.format("Failed to read message: %s", t));
            }
        }
    }

    public static class WorldIdListener
    implements IMessageHandler<WorldIdMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(WorldIdMessage message, MessageContext ctx) {
            lastResponse = System.currentTimeMillis();
            JourneyMap.getLogger().info(String.format("Got the World ID from server: %s", message.worldUid));
            JourneyMap.getInstance().setCurrentWorldId(message.worldUid);
            return null;
        }
    }
}

