/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw c = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int offset = 0;
        PngHelperInternal.writeInt4tobytes(this.cols, c.data, offset);
        PngHelperInternal.writeInt4tobytes(this.rows, c.data, offset += 4);
        offset += 4;
        c.data[offset++] = (byte)this.bitspc;
        c.data[offset++] = (byte)this.colormodel;
        c.data[offset++] = (byte)this.compmeth;
        c.data[offset++] = (byte)this.filmeth;
        c.data[offset++] = (byte)this.interlaced;
        return c;
    }

    @Override
    public void parseFromRaw(ChunkRaw c) {
        if (c.len != 13) {
            throw new PngjException("Bad IDHR len " + c.len);
        }
        ByteArrayInputStream st = c.getAsByteStream();
        this.cols = PngHelperInternal.readInt4(st);
        this.rows = PngHelperInternal.readInt4(st);
        this.bitspc = PngHelperInternal.readByte(st);
        this.colormodel = PngHelperInternal.readByte(st);
        this.compmeth = PngHelperInternal.readByte(st);
        this.filmeth = PngHelperInternal.readByte(st);
        this.interlaced = PngHelperInternal.readByte(st);
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkIHDR otherx = (PngChunkIHDR)other;
        this.cols = otherx.cols;
        this.rows = otherx.rows;
        this.bitspc = otherx.bitspc;
        this.colormodel = otherx.colormodel;
        this.compmeth = otherx.compmeth;
        this.filmeth = otherx.filmeth;
        this.interlaced = otherx.interlaced;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int bitspc) {
        this.bitspc = bitspc;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int colormodel) {
        this.colormodel = colormodel;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int compmeth) {
        this.compmeth = compmeth;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int filmeth) {
        this.filmeth = filmeth;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int interlaced) {
        this.interlaced = interlaced;
    }
}

