/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.vector;

import com.flansmod.common.vector.ReadableVector3f;
import com.flansmod.common.vector.Vector;
import com.flansmod.common.vector.WritableVector3f;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.FloatBuffer;
import net.minecraft.util.Vec3;

public class Vector3f
extends Vector
implements Serializable,
ReadableVector3f,
WritableVector3f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public static Vector3f Zero = new Vector3f(0.0f, 0.0f, 0.0f);

    public Vector3f() {
    }

    public Vector3f(String input) {
        String noBrackets = input.substring(1, input.length() - 1);
        String[] split = noBrackets.split(",");
        if (split.length == 3) {
            this.x = Float.parseFloat(split[0]);
            this.y = Float.parseFloat(split[1]);
            this.z = Float.parseFloat(split[2]);
        }
    }

    public Vector3f(ReadableVector3f src) {
        this.set(src);
    }

    public Vector3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    public Vector3f(Vec3 vec) {
        this((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    public Vector3f(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f set(ReadableVector3f src) {
        this.x = src.getX();
        this.y = src.getY();
        this.z = src.getZ();
        return this;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3f translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public static Vector3f add(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public static Vector3f sub(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    public static Vector3f cross(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    @Override
    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f negate(Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public Vector3f normalise(Vector3f dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vector3f(this.x / l, this.y / l, this.z / l);
        } else {
            dest.set(this.x / l, this.y / l, this.z / l);
        }
        return dest;
    }

    public static float dot(Vector3f left, Vector3f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static float angle(Vector3f a, Vector3f b) {
        float dls = Vector3f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    @Override
    public Vector3f load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        this.z = buf.get();
        return this;
    }

    @Override
    public Vector3f scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    @Override
    public Vector3f store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        return this;
    }

    public String toString() {
        return "Vector3f[" + this.x + ", " + this.y + ", " + this.z + ']';
    }

    @Override
    public final float getX() {
        return this.x;
    }

    @Override
    public final float getY() {
        return this.y;
    }

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }

    @Override
    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector3f && ((Vector3f)obj).x == this.x && ((Vector3f)obj).y == this.y && ((Vector3f)obj).z == this.z;
    }

    public void writeToBuffer(ByteBuf data) {
        data.writeFloat(this.x);
        data.writeFloat(this.y);
        data.writeFloat(this.z);
    }

    public static Vector3f readFromBuffer(ByteBuf data) {
        return new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
    }
}

