/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Team
extends InfoType {
    public static List<Team> teams = new ArrayList<Team>();
    public List<String> members = new ArrayList<String>();
    public List<PlayerClass> classes = new ArrayList<PlayerClass>();
    public static Team spectators;
    public int score = 0;
    public int teamColour = 0xFFFFFF;
    public char textColour = (char)102;
    public boolean allowedForRoundsGenerator = false;
    public ItemStack hat;
    public ItemStack chest;
    public ItemStack legs;
    public ItemStack shoes;

    public Team(String s, String s1, int teamCol, char textCol) {
        super(new TypeFile(EnumType.team, s, "", false));
        this.shortName = s;
        this.name = s1;
        this.teamColour = teamCol;
        this.textColour = textCol;
    }

    public Team(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    protected void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            teams.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            String string;
            String string2;
            String chestShortName;
            String[] split = ConfigUtils.getSplitFromKey(config, "TeamColour");
            if (split != null) {
                this.teamColour = (Integer.parseInt(split[1]) << 16) + (Integer.parseInt(split[2]) << 8) + Integer.parseInt(split[3]);
            }
            this.textColour = Team.getColourCode(ConfigUtils.configString(config, "TextColour", "Black"));
            String hatShortName = ConfigUtils.configString(config, new String[]{"Hat", "Helmet"}, null);
            if (hatShortName != null && !hatShortName.equalsIgnoreCase("None")) {
                for (ItemTeamArmour itemTeamArmour : FlansMod.armourItems) {
                    ArmourType armourType = itemTeamArmour.type;
                    if (armourType == null || !armourType.shortName.equals(hatShortName)) continue;
                    this.hat = new ItemStack((Item)itemTeamArmour);
                }
            }
            if ((chestShortName = ConfigUtils.configString(config, new String[]{"Chest", "Top"}, null)) != null && !chestShortName.equalsIgnoreCase("None")) {
                for (ItemTeamArmour itemTeamArmour : FlansMod.armourItems) {
                    ArmourType armourType = itemTeamArmour.type;
                    if (armourType == null || !armourType.shortName.equals(chestShortName)) continue;
                    this.chest = new ItemStack((Item)itemTeamArmour);
                }
            }
            if ((string2 = ConfigUtils.configString(config, new String[]{"Legs", "Bottom"}, null)) != null && !string2.equalsIgnoreCase("None")) {
                for (ItemTeamArmour itemTeamArmour : FlansMod.armourItems) {
                    ArmourType armour = itemTeamArmour.type;
                    if (armour == null || !armour.shortName.equals(string2)) continue;
                    this.legs = new ItemStack((Item)itemTeamArmour);
                }
            }
            if ((string = ConfigUtils.configString(config, new String[]{"Shoes", "Boots"}, null)) != null && !string.equalsIgnoreCase("None")) {
                for (ItemTeamArmour item : FlansMod.armourItems) {
                    ArmourType armour = item.type;
                    if (armour == null || !armour.shortName.equals(string)) continue;
                    this.shoes = new ItemStack((Item)item);
                }
            }
            ArrayList<String[]> arrayList = ConfigUtils.getSplitsFromKey(config, new String[]{"AddDefaultClass", "AddClass"});
            for (String[] aSplit : arrayList) {
                try {
                    if (aSplit.length == 2) {
                        PlayerClass playerClass = PlayerClass.getClass(aSplit[1]);
                        if (playerClass != null) {
                            this.classes.add(playerClass);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find PlayerClass for AddClass", split, null);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Wrong number of arguments given to AddClass", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding AddClass failed", split, ex);
                }
            }
            this.allowedForRoundsGenerator = ConfigUtils.configBool(config, "AllowedForRoundsGenerator", this.allowedForRoundsGenerator);
        }
        catch (Exception e) {
            FlansMod.log("Reading team file failed.");
            e.printStackTrace();
            this.isValid = false;
        }
    }

    public static Team getTeam(String s) {
        for (Team team : teams) {
            if (!team.shortName.equals(s)) continue;
            return team;
        }
        if (FlansMod.spectators.shortName.equals(s)) {
            return FlansMod.spectators;
        }
        return null;
    }

    private static char getColourCode(String colour) {
        char textCode;
        switch (colour) {
            case "Blue": {
                textCode = '1';
                break;
            }
            case "Green": {
                textCode = '2';
                break;
            }
            case "Aqua": {
                textCode = '3';
                break;
            }
            case "Purple": {
                textCode = '5';
                break;
            }
            case "Orange": {
                textCode = '6';
                break;
            }
            case "LGrey": {
                textCode = '7';
                break;
            }
            case "Grey": {
                textCode = '8';
                break;
            }
            case "LBlue": {
                textCode = '9';
                break;
            }
            case "LGreen": {
                textCode = 'a';
                break;
            }
            case "LAqua": {
                textCode = 'b';
                break;
            }
            case "Red": {
                textCode = 'c';
                break;
            }
            case "Pink": {
                textCode = 'd';
                break;
            }
            case "Yellow": {
                textCode = 'e';
                break;
            }
            case "White": {
                textCode = 'f';
                break;
            }
            default: {
                textCode = '0';
            }
        }
        return textCode;
    }

    public void removePlayer(EntityPlayer player) {
        this.removePlayer(player.func_70005_c_());
    }

    public String removePlayer(String username) {
        this.members.remove(username);
        if (PlayerHandler.getPlayerData(username) != null) {
            PlayerHandler.getPlayerData((String)username).team = null;
        }
        return username;
    }

    public EntityPlayer addPlayer(EntityPlayer player) {
        this.addPlayer(player.func_70005_c_());
        return player;
    }

    public String addPlayer(String username) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(username);
        for (Team team : teams) {
            team.members.removeAll(list);
        }
        this.members.add(username);
        PlayerHandler.getPlayerData((String)username).newTeam = PlayerHandler.getPlayerData((String)username).team = this;
        return username;
    }

    public String removeWorstPlayer() {
        this.sortPlayers();
        if (this.members.size() == 0) {
            return null;
        }
        return this.removePlayer(this.members.get(this.members.size() - 1));
    }

    public void sortPlayers() {
        Collections.sort(this.members, new ComparatorScore());
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }

    public static class ComparatorScore
    implements Comparator<String> {
        @Override
        public int compare(String a, String b) {
            PlayerData dataA = PlayerHandler.getPlayerData(a);
            PlayerData dataB = PlayerHandler.getPlayerData(b);
            if (dataA == null || dataB == null) {
                return 0;
            }
            return dataB.score - dataA.score;
        }
    }
}

