/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ArmourBoxType
extends InfoType {
    public String topTexturePath;
    public String sideTexturePath;
    public String bottomTexturePath;
    public IIcon top;
    public IIcon side;
    public IIcon bottom;
    public BlockArmourBox block;
    public ArrayList<ArmourBoxEntry> pages = new ArrayList();
    public static HashMap<String, ArmourBoxType> boxes = new HashMap();

    public ArmourBoxType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            boxes.put(this.shortName, this);
        }
    }

    @Override
    protected void readLine(String[] split, TypeFile file) {
        if (split.length > 0 && (split[0].equalsIgnoreCase("AddArmour") || split[0].equalsIgnoreCase("AddArmor"))) {
            try {
                StringBuilder name = new StringBuilder(split[2]);
                for (int i = 3; i < split.length; ++i) {
                    name.append(" ").append(split[i]);
                }
                ArmourBoxEntry entry = new ArmourBoxEntry(split[1], name.toString());
                for (int i = 0; i < 4; ++i) {
                    String line = file.readLine();
                    if (line == null) continue;
                    if (line.startsWith("//")) {
                        --i;
                        continue;
                    }
                    String[] lineSplit = line.split(" ");
                    ArmourType armourType = ArmourType.getArmourType(lineSplit[0]);
                    if (armourType != null) {
                        entry.armours[i] = armourType;
                        for (int j = 0; j < (lineSplit.length - 1) / 2; ++j) {
                            ItemStack recipeElement = null;
                            recipeElement = lineSplit[j * 2 + 1].contains(".") ? ArmourBoxType.getRecipeElement(lineSplit[j * 2 + 1].split("\\.")[0], Integer.parseInt(lineSplit[j * 2 + 2]), Integer.parseInt(lineSplit[j * 2 + 1].split("\\.")[1]), this.shortName) : ArmourBoxType.getRecipeElement(lineSplit[j * 2 + 1], Integer.parseInt(lineSplit[j * 2 + 2]), 0, this.shortName);
                            if (recipeElement != null) {
                                entry.requiredStacks[i].add(recipeElement);
                                continue;
                            }
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find item for armour recipe", split, null);
                        }
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't find armour type for armour box", lineSplit, null);
                }
                this.pages.add(entry);
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding armour to box failed", split, ex);
            }
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.topTexturePath = ConfigUtils.configString(config, "TopTexture", this.topTexturePath);
            this.bottomTexturePath = ConfigUtils.configString(config, "BottomTexture", this.bottomTexturePath);
            this.sideTexturePath = ConfigUtils.configString(config, "SideTexture", this.sideTexturePath);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading armour box", null, ex);
            this.isValid = false;
        }
    }

    public static ArmourBoxType getBox(String boxShortName) {
        return boxes.get(boxShortName);
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }

    public class ArmourBoxEntry {
        public String shortName;
        public String name;
        public ArmourType[] armours;
        public ArrayList<ItemStack>[] requiredStacks;

        public ArmourBoxEntry(String s, String s1) {
            this.shortName = s;
            this.name = s1;
            this.armours = new ArmourType[4];
            this.requiredStacks = new ArrayList[4];
            for (int i = 0; i < 4; ++i) {
                this.requiredStacks[i] = new ArrayList();
            }
        }
    }
}

