/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.paintjob;

import com.flansmod.common.FlansMod;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public abstract class PaintableType
extends InfoType {
    public ArrayList<Paintjob> paintjobs = new ArrayList();
    public Paintjob defaultPaintjob;
    public Boolean addAnyPaintjobToTables = true;
    private int nextPaintjobID = 1;

    public PaintableType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        this.defaultPaintjob = new Paintjob(0, "default", this.iconPath, this.texture, new ItemStack[0], true);
        ArrayList<Paintjob> newPaintjobList = new ArrayList<Paintjob>();
        newPaintjobList.add(this.defaultPaintjob);
        newPaintjobList.addAll(this.paintjobs);
        this.paintjobs = newPaintjobList;
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            ArrayList<String[]> lines = ConfigUtils.getSplitsFromKey(config, new String[]{"PaintJob"});
            for (String[] split : lines) {
                try {
                    int numDyes = (split.length - 2) / 2;
                    ItemStack[] dyeStacks = new ItemStack[numDyes];
                    for (int i = 0; i < numDyes; ++i) {
                        int dyeID = this.getDyeDamageValue(split[i * 2 + 3]);
                        if (dyeID == -1) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Unknown dye name for Paintjob", split, null);
                        }
                        dyeStacks[i] = new ItemStack(Items.field_151100_aR, Integer.parseInt(split[i * 2 + 4]), dyeID);
                    }
                    this.paintjobs.add(new Paintjob(this.nextPaintjobID++, split[1], split[2], dyeStacks, true));
                }
                catch (Exception e) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Reading paintjob line failed", split, e);
                }
            }
            lines = ConfigUtils.getSplitsFromKey(config, new String[]{"AdvPaintJob"});
            for (String[] split : lines) {
                try {
                    ItemStack[] dyeStacks = new ItemStack[(split.length - 4) / 2];
                    for (int i = 0; i < (split.length - 4) / 2; ++i) {
                        int dyeID = this.getDyeDamageValue(split[i * 2 + 4]);
                        if (dyeID == -1) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Unknown dye name for AdvPaintjob", split, null);
                        }
                        dyeStacks[i] = new ItemStack(Items.field_151100_aR, Integer.parseInt(split[i * 2 + 5]), dyeID);
                    }
                    this.paintjobs.add(new Paintjob(this.nextPaintjobID++, split[1], split[2], split[3], dyeStacks, true));
                }
                catch (Exception e) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Reading advanced paintjob line failed", split, e);
                }
            }
            lines = ConfigUtils.getSplitsFromKey(config, new String[]{"AddPaintableToTables"});
            for (String[] split : lines) {
                try {
                    if (split.length == 2) {
                        this.addAnyPaintjobToTables = Boolean.parseBoolean(split[1]);
                        continue;
                    }
                    if (split.length != 3) continue;
                    String paintjobId = split[1];
                    for (Paintjob paintjob : this.paintjobs) {
                        if (!paintjob.textureName.equals(paintjobId)) continue;
                        paintjob.addToTables = Boolean.parseBoolean(split[2]);
                    }
                }
                catch (Exception e) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Paintable table configuration failed", split, e);
                }
            }
        }
        catch (Exception e) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading paintjob", null, e);
            this.isValid = false;
        }
    }

    public Paintjob getPaintjob(int i) {
        if (i >= this.paintjobs.size()) {
            return this.defaultPaintjob;
        }
        return this.paintjobs.get(i);
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }
}

