/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PenetrableBlock;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.PenetrationLoss;
import com.flansmod.common.guns.raytracing.BlockHit;
import com.flansmod.common.guns.raytracing.EntityHit;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerBulletHit;
import com.flansmod.common.guns.raytracing.PlayerHitbox;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.network.PacketHitMarker;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.sync.HitData;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;

public class TEST_PacketClientHits
extends PacketBase {
    public ArrayList<HitData> hitData = new ArrayList();
    public Random rand = new Random();
    public boolean lastHitHeadshot = false;
    public float lastHitPenAmount = 1.0f;

    public TEST_PacketClientHits() {
    }

    public TEST_PacketClientHits(ArrayList<HitData> hitData) {
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.hitData.size());
        for (HitData sd : this.hitData) {
            if (sd.hit instanceof PlayerBulletHit) {
                PlayerBulletHit phit = (PlayerBulletHit)sd.hit;
                data.writeByte(2);
                data.writeInt(sd.bullet.field_71093_bK);
                data.writeInt(phit.hitbox.player.func_145782_y());
                data.writeInt(sd.bullet.func_145782_y());
                data.writeFloat(phit.intersectTime);
                phit.hitbox.axes.getMatrix().writeToByteBuf(data);
                data.writeFloat(phit.hitbox.axes.getYaw());
                data.writeFloat(phit.hitbox.axes.getPitch());
                data.writeFloat(phit.hitbox.axes.getRoll());
                data.writeFloat(phit.hitbox.rP.x);
                data.writeFloat(phit.hitbox.rP.y);
                data.writeFloat(phit.hitbox.rP.z);
                data.writeFloat(phit.hitbox.o.x);
                data.writeFloat(phit.hitbox.o.y);
                data.writeFloat(phit.hitbox.o.z);
                data.writeFloat(phit.hitbox.d.x);
                data.writeFloat(phit.hitbox.d.y);
                data.writeFloat(phit.hitbox.d.z);
                data.writeFloat(phit.hitbox.vel.x);
                data.writeFloat(phit.hitbox.vel.y);
                data.writeFloat(phit.hitbox.vel.z);
                data.writeInt(phit.hitbox.type.ordinal());
                continue;
            }
            if (sd.hit instanceof EntityHit) {
                data.writeByte(3);
                EntityHit ehit = (EntityHit)sd.hit;
                data.writeInt(sd.bullet.field_71093_bK);
                data.writeInt(ehit.entity.func_145782_y());
                data.writeInt(sd.bullet.func_145782_y());
                data.writeFloat(ehit.intersectTime);
                continue;
            }
            if (!(sd.hit instanceof BlockHit)) continue;
            data.writeByte(4);
            BlockHit bhit = (BlockHit)sd.hit;
            data.writeInt(sd.bullet.field_71093_bK);
            data.writeInt(sd.bullet.func_145782_y());
            BlockHit.writeMOPToByteBuf(bhit.raytraceResult, data);
            data.writeFloat(bhit.intersectTime);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        int hitsSize = data.readInt();
        for (int i = 0; i < hitsSize; ++i) {
            WorldServer world;
            float intersectTime;
            int dim;
            byte typeOfHit = data.readByte();
            if (typeOfHit == 1) {
                System.out.println("driveable hit recived");
                continue;
            }
            if (typeOfHit == 2) {
                dim = data.readInt();
                int playerID = data.readInt();
                int bulletID = data.readInt();
                float phitIntersectTime = data.readFloat();
                RotatedAxes axes = new RotatedAxes();
                axes.getMatrix().readFromByteBuf(data);
                axes.setAngles(data.readFloat(), data.readFloat(), data.readFloat());
                Vector3f rp = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
                Vector3f o = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
                Vector3f d = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
                Vector3f vel = new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
                EnumHitboxType type = EnumHitboxType.values()[data.readInt()];
                WorldServer world2 = MinecraftServer.func_71276_C().func_71218_a(dim);
                EntityPlayerMP player = (EntityPlayerMP)world2.func_73045_a(playerID);
                EntityBullet bullet = (EntityBullet)world2.func_73045_a(bulletID);
                PlayerHitbox pbox = new PlayerHitbox((EntityPlayer)player, axes, rp, o, d, vel, type);
                PlayerBulletHit phit = new PlayerBulletHit(pbox, phitIntersectTime);
                this.hitData.add(new HitData(phit, bullet));
                continue;
            }
            if (typeOfHit == 3) {
                dim = data.readInt();
                int entityID = data.readInt();
                int bulletID = data.readInt();
                intersectTime = data.readFloat();
                world = MinecraftServer.func_71276_C().func_71218_a(dim);
                Entity entity = world.func_73045_a(entityID);
                EntityBullet bullet = (EntityBullet)world.func_73045_a(bulletID);
                EntityHit ehit = new EntityHit(entity, intersectTime);
                this.hitData.add(new HitData(ehit, bullet));
                continue;
            }
            if (typeOfHit != 4) continue;
            dim = data.readInt();
            int bulletID = data.readInt();
            MovingObjectPosition mop = BlockHit.readMOPFromByteBuf(data);
            intersectTime = data.readFloat();
            world = MinecraftServer.func_71276_C().func_71218_a(dim);
            EntityBullet bullet = (EntityBullet)world.func_73045_a(bulletID);
            BlockHit bhit = new BlockHit(mop, intersectTime);
            this.hitData.add(new HitData(bhit, bullet));
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        boolean showCrosshair = false;
        this.lastHitPenAmount = 0.0f;
        this.lastHitHeadshot = false;
        for (HitData sd : this.hitData) {
            if (sd.hit instanceof PlayerBulletHit) {
                if (sd.bullet == null) {
                    return;
                }
                PlayerBulletHit phit = (PlayerBulletHit)sd.hit;
                float prevPenetratingPower = sd.bullet.penetratingPower;
                sd.bullet.penetratingPower = phit.hitbox.hitByBullet(sd.bullet, sd.bullet.penetratingPower);
                sd.bullet.penetrationLosses.add(new PenetrationLoss(prevPenetratingPower - sd.bullet.penetratingPower, PenetrationLoss.PenetrationLossType.PLAYER));
                if (FlansMod.DEBUG) {
                    playerEntity.field_70170_p.func_72838_d((Entity)new EntityDebugDot(playerEntity.field_70170_p, new Vector3f(sd.bullet.field_70165_t + sd.bullet.field_70159_w * (double)phit.intersectTime, sd.bullet.field_70163_u + sd.bullet.field_70181_x * (double)phit.intersectTime, sd.bullet.field_70161_v + sd.bullet.field_70179_y * (double)phit.intersectTime), 1000, 1.0f, 0.0f, 0.0f));
                }
            } else if (sd.hit instanceof EntityHit) {
                if (sd.bullet == null) {
                    return;
                }
                if (sd.bullet.type.entityHitSoundEnable) {
                    PacketPlaySound.sendSoundPacket(sd.bullet.field_70165_t, sd.bullet.field_70163_u, sd.bullet.field_70161_v, sd.bullet.type.hitSoundRange, sd.bullet.field_71093_bK, sd.bullet.type.hitSound, true);
                }
                if (!sd.bullet.field_70170_p.field_72995_K && sd.bullet.owner instanceof EntityPlayer) {
                    showCrosshair = true;
                    this.lastHitPenAmount = 1.0f;
                }
                EntityHit entityHit = (EntityHit)sd.hit;
                float d = sd.bullet.getDamageAffectedByPenetration();
                if (entityHit.entity instanceof EntityLivingBase) {
                    d *= sd.bullet.type.damageVsLiving;
                    if (entityHit.entity != sd.bullet.owner) {
                        FlansMod.proxy.spawnParticle("reddust", entityHit.entity.field_70165_t, entityHit.entity.field_70163_u, entityHit.entity.field_70161_v, 0.0, 0.0, 0.0);
                    }
                } else {
                    d *= sd.bullet.type.damageVsEntity;
                }
                if (entityHit.entity.func_70097_a(sd.bullet.getBulletDamage(false), d) && entityHit.entity instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)entityHit.entity;
                    for (PotionEffect effect : sd.bullet.type.hitEffects) {
                        living.func_70690_d(new PotionEffect(effect));
                    }
                    ++living.field_70720_be;
                    living.field_70172_ad = living.field_70771_an / 2;
                }
                if (sd.bullet.type.setEntitiesOnFire) {
                    entityHit.entity.func_70015_d(20);
                }
                sd.bullet.penetratingPower -= 1.0f;
                sd.bullet.penetrationLosses.add(new PenetrationLoss(1.0f, PenetrationLoss.PenetrationLossType.ENTITY));
                if (FlansMod.DEBUG) {
                    sd.bullet.field_70170_p.func_72838_d((Entity)new EntityDebugDot(sd.bullet.field_70170_p, new Vector3f(sd.bullet.field_70165_t + sd.bullet.field_70159_w * (double)entityHit.intersectTime, sd.bullet.field_70163_u + sd.bullet.field_70181_x * (double)entityHit.intersectTime, sd.bullet.field_70161_v + sd.bullet.field_70179_y * (double)entityHit.intersectTime), 1000, 1.0f, 1.0f, 0.0f));
                    FlansMod.log(entityHit.entity.toString() + ": d=" + d + ": damage=" + sd.bullet.damage + ": type.damageVsEntity=" + sd.bullet.type.damageVsEntity);
                }
            } else if (sd.hit instanceof BlockHit) {
                if (sd.bullet == null) {
                    return;
                }
                BlockHit blockHit = (BlockHit)sd.hit;
                MovingObjectPosition raytraceResult = blockHit.raytraceResult;
                Vec3 hitVec = raytraceResult.field_72307_f;
                int xTile = raytraceResult.field_72311_b;
                int yTile = raytraceResult.field_72312_c;
                int zTile = raytraceResult.field_72309_d;
                if (FlansMod.DEBUG) {
                    sd.bullet.field_70170_p.func_72838_d((Entity)new EntityDebugDot(sd.bullet.field_70170_p, new Vector3f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c), 1000, 0.0f, 1.0f, 0.0f));
                }
                Block block = sd.bullet.field_70170_p.func_147439_a(xTile, yTile, zTile);
                Material mat = block.func_149688_o();
                if (FlansMod.enableBlockPenetration) {
                    boolean penetrableBlockFound = false;
                    for (PenetrableBlock penetrableBlock : FlansMod.penetrableBlocks) {
                        int metadata;
                        if (block != penetrableBlock.getBlock() || (metadata = penetrableBlock.getMetadata()) != -1 && metadata != sd.bullet.field_70170_p.func_72805_g(xTile, yTile, zTile)) continue;
                        float hardness = penetrableBlock.getHardness() * (sd.bullet.type.getBlockPenetrationModifier() > 0.0f ? 1.0f / sd.bullet.type.getBlockPenetrationModifier() : 1.0f);
                        sd.bullet.penetratingPower -= hardness;
                        if (sd.bullet.penetratingPower < 0.0f) break;
                        FlansMod.proxy.playBlockBreakSound(xTile, yTile, zTile, block, sd.bullet.field_71093_bK);
                        if (penetrableBlock.breaks()) {
                            sd.bullet.field_70170_p.func_147468_f(xTile, yTile, zTile);
                        }
                        sd.bullet.penetrationLosses.add(new PenetrationLoss(hardness, PenetrationLoss.PenetrationLossType.BLOCK));
                        penetrableBlockFound = true;
                    }
                    if (penetrableBlockFound) continue;
                }
                if (sd.bullet.type.hitSoundEnable && sd.bullet.type.breaksGlass && mat == Material.field_151592_s && TeamsManager.canBreakGlass) {
                    sd.bullet.field_70170_p.func_147468_f(xTile, yTile, zTile);
                    FlansMod.proxy.playBlockBreakSound(xTile, yTile, zTile, block, sd.bullet.field_71093_bK);
                }
                if (sd.bullet.type.hitSoundEnable) {
                    String hitToUse = null;
                    if (sd.bullet.type.hitSound != null) {
                        hitToUse = sd.bullet.type.hitSound;
                    } else if (block.equals(Blocks.field_150336_V)) {
                        hitToUse = "impact_bricks";
                    } else if (mat == Material.field_151578_c || mat == Material.field_151577_b || mat == Material.field_151595_p || mat == Material.field_151571_B || mat == Material.field_151590_u) {
                        hitToUse = "impact_dirt";
                    } else if (mat == Material.field_151592_s || mat == Material.field_151591_t || mat == Material.field_151588_w || mat == Material.field_151598_x) {
                        hitToUse = "impact_glass";
                    } else if (mat == Material.field_151573_f || mat == Material.field_151574_g) {
                        hitToUse = "impact_metal";
                    } else if (mat == Material.field_151576_e) {
                        hitToUse = "impact_rock";
                    } else if (mat == Material.field_151575_d) {
                        hitToUse = "impact_wood";
                    }
                    PacketPlaySound.sendSoundPacket(sd.bullet.field_70165_t, sd.bullet.field_70163_u, sd.bullet.field_70161_v, sd.bullet.type.hitSoundRange, sd.bullet.field_71093_bK, hitToUse, true);
                }
                if (sd.bullet.field_70170_p.field_72995_K && block.func_149688_o() != Material.field_151579_a && sd.bullet.type.explosionRadius <= 30.0f && sd.bullet.type.blockHitFXScale > 0.0f) {
                    double scalingFactor = Minecraft.func_71410_x().field_71474_y.field_74347_j ? 10.0 : 2.0;
                    int numBlockParticles = (int)(Math.pow(sd.bullet.type.explosionRadius + 1.0f, 1.5) * scalingFactor + 20.0);
                    double velocityFactor = Math.sqrt(sd.bullet.type.explosionRadius + 1.0f) * (double)sd.bullet.type.blockHitFXScale * 0.5;
                    for (int i = 0; i < numBlockParticles; ++i) {
                        FlansMod.proxy.spawnParticle("blockdust_" + Block.func_149682_b((Block)block) + "_" + sd.bullet.field_70170_p.func_72805_g(xTile, xTile, xTile), raytraceResult.field_72307_f.field_72450_a + ((double)this.rand.nextFloat() - 0.3) * (double)sd.bullet.field_70130_N * 0.05, raytraceResult.field_72307_f.field_72448_b + ((double)this.rand.nextFloat() - 0.3) * (double)sd.bullet.field_70130_N * 0.05, raytraceResult.field_72307_f.field_72449_c + ((double)this.rand.nextFloat() - 0.3) * (double)sd.bullet.field_70130_N * 0.05, -sd.bullet.field_70159_w * (0.0011 + this.rand.nextGaussian() * 0.008) * velocityFactor, Math.abs(0.305 + this.rand.nextDouble() * 0.125) * velocityFactor, -sd.bullet.field_70179_y * (0.0011 + this.rand.nextGaussian() * 0.008) * velocityFactor);
                        FlansMod.proxy.spawnParticle("blockcrack_" + Block.func_149682_b((Block)block) + "_" + sd.bullet.field_70170_p.func_72805_g(xTile, xTile, xTile), raytraceResult.field_72307_f.field_72450_a + ((double)this.rand.nextFloat() - 0.6) * (double)sd.bullet.field_70130_N * 0.75, raytraceResult.field_72307_f.field_72448_b + ((double)this.rand.nextFloat() - 0.6) * (double)sd.bullet.field_70130_N * 0.75, raytraceResult.field_72307_f.field_72449_c + ((double)this.rand.nextFloat() - 0.6) * (double)sd.bullet.field_70130_N * 0.75, -sd.bullet.field_70159_w * (0.415 + this.rand.nextGaussian() * 0.1) * velocityFactor, -sd.bullet.field_70181_x * (0.425 + Math.abs(this.rand.nextGaussian() * 0.1)) * velocityFactor, -sd.bullet.field_70179_y * (0.415 + this.rand.nextGaussian() * 0.1) * velocityFactor);
                    }
                }
                if (sd.bullet.type.bounciness > 0.0f) {
                    Vector3f surfaceNormal;
                    Vector3f origin = new Vector3f(sd.bullet.field_70165_t, sd.bullet.field_70163_u, sd.bullet.field_70161_v);
                    Vector3f motion = new Vector3f(sd.bullet.field_70159_w, sd.bullet.field_70181_x, sd.bullet.field_70179_y);
                    Vector3f hitPos = new Vector3f(hitVec);
                    Vector3f preHitVel = Vector3f.sub(hitPos, origin, null);
                    Vector3f postHitVel = Vector3f.sub(motion, preHitVel, null);
                    int sideHit = blockHit.raytraceResult.field_72310_e;
                    switch (sideHit) {
                        case 0: {
                            surfaceNormal = new Vector3f(0.0f, -1.0f, 0.0f);
                            break;
                        }
                        case 1: {
                            surfaceNormal = new Vector3f(0.0f, 1.0f, 0.0f);
                            break;
                        }
                        case 2: {
                            surfaceNormal = new Vector3f(0.0f, 0.0f, -1.0f);
                            break;
                        }
                        case 3: {
                            surfaceNormal = new Vector3f(0.0f, 0.0f, 1.0f);
                            break;
                        }
                        case 5: {
                            surfaceNormal = new Vector3f(1.0f, 0.0f, 0.0f);
                            break;
                        }
                        default: {
                            surfaceNormal = new Vector3f(-1.0f, 0.0f, 0.0f);
                        }
                    }
                    if (motion.lengthSquared() < 0.1f * sd.bullet.initialSpeed) {
                        sd.bullet.func_70107_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                        sd.bullet.func_70106_y();
                        break;
                    }
                    float lambda = postHitVel.length() / motion.length();
                    float normalProjection = Vector3f.dot(surfaceNormal, postHitVel);
                    Vector3f normal = new Vector3f(surfaceNormal).scale(-normalProjection);
                    Vector3f orthog = Vector3f.add(postHitVel, normal, null);
                    normal.scale(sd.bullet.type.bounciness / 3.0f);
                    orthog.scale(sd.bullet.type.bounciness);
                    postHitVel = Vector3f.add(orthog, normal, null);
                    Vector3f totalVel = Vector3f.add(preHitVel, postHitVel, null);
                    sd.bullet.func_70107_b(sd.bullet.field_70165_t + (double)totalVel.x, sd.bullet.field_70163_u + (double)totalVel.y, sd.bullet.field_70161_v + (double)totalVel.z);
                    sd.bullet.func_70016_h(postHitVel.x / lambda, postHitVel.y / lambda, postHitVel.z / lambda);
                    break;
                }
                sd.bullet.func_70107_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                sd.bullet.func_70106_y();
                break;
            }
            if (sd.bullet.penetratingPower <= 0.0f || sd.bullet.type.explodeOnImpact && sd.bullet.ticksInAir > 1) {
                sd.bullet.func_70107_b(sd.bullet.field_70165_t + sd.bullet.field_70159_w * (double)sd.hit.intersectTime, sd.bullet.field_70163_u + sd.bullet.field_70181_x * (double)sd.hit.intersectTime, sd.bullet.field_70161_v + sd.bullet.field_70179_y * (double)sd.hit.intersectTime);
                sd.bullet.func_70106_y();
                break;
            }
            if (!showCrosshair || !(sd.bullet.owner instanceof EntityPlayerMP)) continue;
            FlansMod.getPacketHandler().sendTo(new PacketHitMarker(this.lastHitHeadshot, this.lastHitPenAmount, false), (EntityPlayerMP)sd.bullet.owner);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log("Skip on client");
    }
}

