/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.raytracing;

import com.flansmod.common.guns.raytracing.BulletHit;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class BlockHit
extends BulletHit {
    public MovingObjectPosition raytraceResult;

    public BlockHit(MovingObjectPosition mop, float f) {
        super(f);
        this.raytraceResult = mop;
    }

    public static void writeMOPToByteBuf(MovingObjectPosition mop, ByteBuf buffer) {
        buffer.writeInt(mop.field_72313_a.ordinal());
        buffer.writeInt(mop.field_72311_b);
        buffer.writeInt(mop.field_72312_c);
        buffer.writeInt(mop.field_72309_d);
        buffer.writeInt(mop.field_72310_e);
        BlockHit.writeVec3ToByteBuf(mop.field_72307_f, buffer);
        if (mop.hitInfo != null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
        }
    }

    private static void writeVec3ToByteBuf(Vec3 vec, ByteBuf buffer) {
        if (vec != null) {
            buffer.writeFloat((float)vec.field_72450_a);
            buffer.writeFloat((float)vec.field_72448_b);
            buffer.writeFloat((float)vec.field_72449_c);
        } else {
            buffer.writeFloat(0.0f);
            buffer.writeFloat(0.0f);
            buffer.writeFloat(0.0f);
        }
    }

    public static MovingObjectPosition readMOPFromByteBuf(ByteBuf buffer) {
        MovingObjectPosition.MovingObjectType type = MovingObjectPosition.MovingObjectType.values()[buffer.readInt()];
        int blockX = buffer.readInt();
        int blockY = buffer.readInt();
        int blockZ = buffer.readInt();
        int sideHit = buffer.readInt();
        Vec3 hitVec = BlockHit.readVec3FromByteBuf(buffer);
        Object hitInfo = null;
        if (buffer.readBoolean()) {
            // empty if block
        }
        return new MovingObjectPosition(blockX, blockY, blockZ, sideHit, hitVec);
    }

    private static Vec3 readVec3FromByteBuf(ByteBuf buffer) {
        double x = buffer.readFloat();
        double y = buffer.readFloat();
        double z = buffer.readFloat();
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }
}

