/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.guns.BulletType;

public class PenetrationLoss {
    private final PenetrationLossType type;
    private final float loss;

    public PenetrationLoss(float loss, PenetrationLossType type) {
        this.loss = loss;
        this.type = type;
    }

    public float getLoss() {
        return this.loss;
    }

    public PenetrationLossType getType() {
        return this.type;
    }

    public static enum PenetrationLossType {
        PLAYER,
        ENTITY,
        BLOCK,
        DECAY;


        public float getEffectOnDamage(BulletType bulletType) {
            switch (this) {
                case BLOCK: {
                    return bulletType.blockPenetrationEffectOnDamage;
                }
                case DECAY: {
                    return bulletType.penetrationDecayEffectOnDamage;
                }
                case ENTITY: {
                    return bulletType.entityPenetrationEffectOnDamage;
                }
                case PLAYER: {
                    return bulletType.playerPenetrationEffectOnDamage;
                }
            }
            return 1.0f;
        }
    }
}

